/*
 * Decompiled with CFR 0.152.
 */
package dev.plasticstraw.inf_music.config;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.fabricmc.loader.api.FabricLoader;

public class InfiniteMusicConfig {
    private static final String CONFIG_FILE_NAME = "infinite-music-options.json";
    private static final Gson json = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).setPrettyPrinting().excludeFieldsWithModifiers(new int[]{2}).create();
    public final MainMenuMusic mainMenuMusic = new MainMenuMusic();
    public final GameplayMusic gameplayMusic = new GameplayMusic();
    public final GameplayMusic creativeMusic = new GameplayMusic();
    public final GameplayMusic underwaterMusic = new GameplayMusic();
    public final EndMusic endMusic = new EndMusic();
    public boolean pauseForDiscMusic = true;
    public boolean playMusicImmediately = false;
    public boolean enableSoundOptionsButton = true;

    public static InfiniteMusicConfig load() {
        InfiniteMusicConfig config;
        block8: {
            Path path = InfiniteMusicConfig.getConfigPath();
            if (Files.exists(path, new LinkOption[0])) {
                try (FileReader reader = new FileReader(path.toFile());){
                    config = (InfiniteMusicConfig)json.fromJson((Reader)reader, InfiniteMusicConfig.class);
                    break block8;
                }
                catch (IOException exception) {
                    throw new RuntimeException("Invalid config", exception);
                }
            }
            config = new InfiniteMusicConfig();
        }
        return config;
    }

    public void write() {
        Path directory = InfiniteMusicConfig.getConfigPath().getParent();
        try {
            Files.createDirectories(directory, new FileAttribute[0]);
        }
        catch (IOException exception) {
            throw new RuntimeException("Invalid directory", exception);
        }
        try {
            Files.writeString(InfiniteMusicConfig.getConfigPath(), (CharSequence)json.toJson((Object)this), new OpenOption[0]);
        }
        catch (IOException exception) {
            throw new RuntimeException("Couldn't write config", exception);
        }
    }

    private static Path getConfigPath() {
        return FabricLoader.getInstance().getConfigDir().resolve(CONFIG_FILE_NAME);
    }

    public static class MainMenuMusic
    extends MusicOptions {
        @Override
        public int getDefaultDelay() {
            return 15;
        }

        @Override
        public int getDefaultRandomness() {
            return 15;
        }

        @Override
        public boolean usesMinutes() {
            return false;
        }
    }

    public static class GameplayMusic
    extends MusicOptions {
        @Override
        public int getDefaultDelay() {
            return 900;
        }

        @Override
        public int getDefaultRandomness() {
            return 300;
        }
    }

    public static class EndMusic
    extends MusicOptions {
        @Override
        public int getDefaultDelay() {
            return 780;
        }

        @Override
        public int getDefaultRandomness() {
            return 420;
        }
    }

    private static interface MusicDefaults {
        public int getDefaultDelay();

        public int getDefaultRandomness();

        default public boolean usesMinutes() {
            return true;
        }
    }

    public static abstract class MusicOptions
    implements MusicDefaults {
        public boolean enabled = true;
        public int delay = 0;
        public int randomness = 0;

        public int getMinTicks() {
            return Math.max(this.delay - this.randomness, 0) * 20;
        }

        public int getMaxTicks() {
            return (this.delay + this.randomness) * 20;
        }
    }
}

