/*
 * Decompiled with CFR 0.152.
 */
package ludichat.cobbreeding.gui;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.CobblemonSounds;
import com.cobblemon.mod.common.api.net.NetworkPacket;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import ludichat.cobbreeding.CustomProperties;
import ludichat.cobbreeding.network.ToggleBreedingPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0002\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u001f\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0019\u0010\u0013\u001a\u00020\u000e2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0011H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J/\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u0017H\u0014\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0017\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u001bH\u0014\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0017\u0010!\u001a\u00020\u000e2\u0006\u0010 \u001a\u00020\u001fH\u0016\u00a2\u0006\u0004\b!\u0010\"R\u001a\u0010\b\u001a\u00020\u00078\u0004X\u0084\u0004\u00a2\u0006\f\n\u0004\b\b\u0010#\u001a\u0004\b$\u0010%R\"\u0010'\u001a\u00020&8\u0004@\u0004X\u0084\u000e\u00a2\u0006\u0012\n\u0004\b'\u0010(\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,R\"\u0010-\u001a\u00020&8\u0004@\u0004X\u0084\u000e\u00a2\u0006\u0012\n\u0004\b-\u0010(\u001a\u0004\b.\u0010*\"\u0004\b/\u0010,R\"\u00101\u001a\u0002008\u0004@\u0004X\u0084\u000e\u00a2\u0006\u0012\n\u0004\b1\u00102\u001a\u0004\b3\u00104\"\u0004\b5\u00106\u00a8\u00067"}, d2={"Lludichat/cobbreeding/gui/PastureBreedingButton;", "Lnet/minecraft/client/gui/components/AbstractWidget;", "", "x", "y", "width", "height", "Lnet/minecraft/core/BlockPos;", "blockPos", "<init>", "(IIIILnet/minecraft/core/BlockPos;)V", "", "mouseX", "mouseY", "", "onClick", "(DD)V", "Lnet/minecraft/client/gui/components/Tooltip;", "tooltip", "setTooltip", "(Lnet/minecraft/client/gui/components/Tooltip;)V", "Lnet/minecraft/client/gui/GuiGraphics;", "guiGraphics", "", "partialTick", "renderWidget", "(Lnet/minecraft/client/gui/GuiGraphics;IIF)V", "Lnet/minecraft/client/gui/narration/NarrationElementOutput;", "narrationElementOutput", "updateWidgetNarration", "(Lnet/minecraft/client/gui/narration/NarrationElementOutput;)V", "Lnet/minecraft/client/sounds/SoundManager;", "soundManager", "playDownSound", "(Lnet/minecraft/client/sounds/SoundManager;)V", "Lnet/minecraft/core/BlockPos;", "getBlockPos", "()Lnet/minecraft/core/BlockPos;", "Lnet/minecraft/resources/ResourceLocation;", "texture", "Lnet/minecraft/resources/ResourceLocation;", "getTexture", "()Lnet/minecraft/resources/ResourceLocation;", "setTexture", "(Lnet/minecraft/resources/ResourceLocation;)V", "cross", "getCross", "setCross", "Lnet/minecraft/world/level/block/state/BlockState;", "state", "Lnet/minecraft/world/level/block/state/BlockState;", "getState", "()Lnet/minecraft/world/level/block/state/BlockState;", "setState", "(Lnet/minecraft/world/level/block/state/BlockState;)V", "common"})
public final class PastureBreedingButton
extends AbstractWidget {
    @NotNull
    private final BlockPos blockPos;
    @NotNull
    private ResourceLocation texture;
    @NotNull
    private ResourceLocation cross;
    @NotNull
    private BlockState state;

    public PastureBreedingButton(int x, int y, int width, int height, @NotNull BlockPos blockPos) {
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        super(x, y, width, height, (Component)Component.empty());
        this.blockPos = blockPos;
        ResourceLocation resourceLocation = ResourceLocation.fromNamespaceAndPath((String)"cobbreeding", (String)"textures/gui/breeding_button.png");
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"fromNamespaceAndPath(...)");
        this.texture = resourceLocation;
        ResourceLocation resourceLocation2 = ResourceLocation.fromNamespaceAndPath((String)"cobbreeding", (String)"textures/gui/cross.png");
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation2, (String)"fromNamespaceAndPath(...)");
        this.cross = resourceLocation2;
        ClientLevel clientLevel = Minecraft.getInstance().level;
        Intrinsics.checkNotNull((Object)clientLevel);
        BlockState blockState = clientLevel.getBlockState(this.blockPos);
        Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"getBlockState(...)");
        this.state = blockState;
    }

    @NotNull
    protected final BlockPos getBlockPos() {
        return this.blockPos;
    }

    @NotNull
    protected final ResourceLocation getTexture() {
        return this.texture;
    }

    protected final void setTexture(@NotNull ResourceLocation resourceLocation) {
        Intrinsics.checkNotNullParameter((Object)resourceLocation, (String)"<set-?>");
        this.texture = resourceLocation;
    }

    @NotNull
    protected final ResourceLocation getCross() {
        return this.cross;
    }

    protected final void setCross(@NotNull ResourceLocation resourceLocation) {
        Intrinsics.checkNotNullParameter((Object)resourceLocation, (String)"<set-?>");
        this.cross = resourceLocation;
    }

    @NotNull
    protected final BlockState getState() {
        return this.state;
    }

    protected final void setState(@NotNull BlockState blockState) {
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"<set-?>");
        this.state = blockState;
    }

    public void onClick(double mouseX, double mouseY) {
        Cobblemon.INSTANCE.getImplementation().getNetworkManager().sendToServer((NetworkPacket)new ToggleBreedingPacket());
    }

    public void setTooltip(@Nullable Tooltip tooltip) {
        super.setTooltip(Tooltip.create((Component)((Component)Component.translatable((String)"cobbreeding.msg.pasture_button.tooltip"))));
    }

    protected void renderWidget(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        Intrinsics.checkNotNullParameter((Object)guiGraphics, (String)"guiGraphics");
        guiGraphics.blit(this.texture, this.getX(), this.getY(), this.width, this.height, 0.0f, 0.0f, this.width, this.height, this.width, this.height);
        ClientLevel clientLevel = Minecraft.getInstance().level;
        Intrinsics.checkNotNull((Object)clientLevel);
        BlockState blockState = clientLevel.getBlockState(this.blockPos);
        Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"getBlockState(...)");
        this.state = blockState;
        if (!((Boolean)this.state.getValue((Property)CustomProperties.BREEDING_ACTIVATED)).booleanValue()) {
            guiGraphics.blit(this.cross, this.getX() + 3, this.getY() + 3, 14, 14, 0.0f, 0.0f, 14, 14, 14, 14);
        }
    }

    protected void updateWidgetNarration(@NotNull NarrationElementOutput narrationElementOutput) {
        Intrinsics.checkNotNullParameter((Object)narrationElementOutput, (String)"narrationElementOutput");
        String isOn = (Boolean)this.state.getValue((Property)CustomProperties.BREEDING_ACTIVATED) != false ? "ON" : "OFF";
        narrationElementOutput.add(NarratedElementType.TITLE, "Breeding " + isOn);
    }

    public void playDownSound(@NotNull SoundManager soundManager) {
        Intrinsics.checkNotNullParameter((Object)soundManager, (String)"soundManager");
        soundManager.play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)CobblemonSounds.PC_CLICK, (float)1.0f));
    }
}

