/*
 * Decompiled with CFR 0.152.
 */
package ludichat.cobbreeding.mixin;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.pokemon.PokemonProperties;
import com.cobblemon.mod.common.api.pokemon.PokemonSpecies;
import com.cobblemon.mod.common.block.entity.PokemonPastureBlockEntity;
import com.cobblemon.mod.common.pokemon.FormData;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.pokemon.Species;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import kotlin.Pair;
import kotlin.UninitializedPropertyAccessException;
import ludichat.cobbreeding.BreedingUtilities;
import ludichat.cobbreeding.Cobbreeding;
import ludichat.cobbreeding.Config;
import ludichat.cobbreeding.CustomProperties;
import ludichat.cobbreeding.EggUtilities;
import ludichat.cobbreeding.PastureBreedingData;
import ludichat.cobbreeding.PastureInventory;
import ludichat.cobbreeding.components.CobbreedingComponents;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PokemonPastureBlockEntity.class})
public abstract class PokemonPastureBlockEntityMixin
extends BlockEntity
implements PastureInventory,
WorldlyContainer {
    @Unique
    private static final Logger cobbreeding$LOGGER = Cobbreeding.LOGGER;
    @Unique
    private static final BooleanProperty cobbreeding$HAS_EGG = CustomProperties.HAS_EGG;
    @Unique
    private static final BooleanProperty cobbreeding$BREEDING_ACTIVATED = CustomProperties.BREEDING_ACTIVATED;
    @Unique
    private static int[] COBBREEDING_INVENTORY_SLOTS = null;

    public PokemonPastureBlockEntityMixin(BlockEntityType<?> type, BlockPos pos, BlockState blockState) {
        super(type, pos, blockState);
    }

    @Override
    public NonNullList<ItemStack> getItems() {
        PastureBreedingData data;
        BlockPos pos = this.worldPosition;
        if (PastureBreedingData.registry.containsKey(pos)) {
            data = PastureBreedingData.registry.get(pos);
        } else {
            data = new PastureBreedingData(-1L, (NonNullList<ItemStack>)NonNullList.withSize((int)PokemonPastureBlockEntityMixin.cobbreeding$getConfig().getPastureInventorySize(), (Object)ItemStack.EMPTY), PokemonPastureBlockEntityMixin.cobbreeding$getNewBreedingTime());
            PastureBreedingData.registry.put(pos, data);
        }
        return data.getEggs();
    }

    @Unique
    private static Config cobbreeding$getConfig() {
        Config config;
        try {
            config = Cobbreeding.INSTANCE.getConfig();
        }
        catch (UninitializedPropertyAccessException e) {
            cobbreeding$LOGGER.warn("Trying to read configurations but they haven't been initialized. Returning Default configs instead. This might happen because the client is running logic it shouldn't.");
            return new Config();
        }
        return config;
    }

    @Unique
    private static int cobbreeding$getNewBreedingTime() {
        return new Random().nextInt(PokemonPastureBlockEntityMixin.cobbreeding$getConfig().getMinBreedingTimeInTicks(), PokemonPastureBlockEntityMixin.cobbreeding$getConfig().getMaxBreedingTimeInTicks() + 1);
    }

    @Inject(at={@At(value="HEAD")}, method={"TICKER$lambda$0"})
    private static void tick(Level world, BlockPos pos, BlockState state, PokemonPastureBlockEntity blockEntity, CallbackInfo ci) {
        long world_time = world.getGameTime();
        if (!world.isClientSide && world_time % (long)Cobblemon.config.getPastureBlockUpdateTicks() == 0L) {
            PastureBreedingData data;
            List<Object> pokemon = new LinkedList();
            try {
                List tetheredPokemon = blockEntity.getTetheredPokemon();
                pokemon = BreedingUtilities.getPokemon(tetheredPokemon);
            }
            catch (NullPointerException tetheredPokemon) {
                // empty catch block
            }
            if (world_time % (long)PokemonPastureBlockEntityMixin.cobbreeding$getConfig().getMirrorHerbTimeInTicks() == 0L) {
                BreedingUtilities.applyMirrorHerb(pokemon);
            }
            if (PastureBreedingData.registry.containsKey(pos)) {
                data = PastureBreedingData.registry.get(pos);
            } else {
                data = new PastureBreedingData(world.getGameTime(), (NonNullList<ItemStack>)NonNullList.withSize((int)PokemonPastureBlockEntityMixin.cobbreeding$getConfig().getPastureInventorySize(), (Object)ItemStack.EMPTY), PokemonPastureBlockEntityMixin.cobbreeding$getNewBreedingTime());
                PastureBreedingData.registry.put(pos, data);
            }
            Collection<Map.Entry<FormData, List<Pair<Pokemon, Pokemon>>>> possibleEggs = BreedingUtilities.getPossibleEggs(pokemon);
            if (((Boolean)state.getValue((Property)cobbreeding$BREEDING_ACTIVATED)).booleanValue() && !possibleEggs.isEmpty()) {
                if (data.getEggs().stream().anyMatch(itemStack -> itemStack.getCount() == 0)) {
                    boolean egg_created = false;
                    long pasture_time = data.getTime() == -1L ? world_time : data.getTime();
                    data.setTime(pasture_time);
                    for (long time_difference = world_time - pasture_time; time_difference >= (long)data.getRequiredTicks(); time_difference -= (long)data.getRequiredTicks()) {
                        egg_created = true;
                        PokemonPastureBlockEntityMixin.cobbreeding$addEgg(data, possibleEggs);
                        data.setRequiredTicks(PokemonPastureBlockEntityMixin.cobbreeding$getNewBreedingTime());
                        if (!data.getEggs().stream().noneMatch(itemStack -> itemStack.getCount() == 0)) continue;
                    }
                    if (egg_created) {
                        data.setTime(world_time);
                        world.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)cobbreeding$HAS_EGG, (Comparable)Boolean.valueOf(data.getEggs().stream().anyMatch(itemStack -> itemStack.getCount() != 0))));
                        world.playSound(null, pos, SoundEvents.CHICKEN_EGG, SoundSource.BLOCKS, 1.0f, 1.0f);
                    }
                }
            } else {
                data.setTime(-1L);
            }
            if (((Boolean)state.getValue((Property)cobbreeding$HAS_EGG)).booleanValue() && data.getEggs().stream().allMatch(itemStack -> itemStack.getCount() == 0)) {
                world.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)cobbreeding$HAS_EGG, (Comparable)Boolean.valueOf(false)));
            }
        }
    }

    @Unique
    private static void cobbreeding$addEgg(PastureBreedingData data, Collection<Map.Entry<FormData, List<Pair<Pokemon, Pokemon>>>> possibleEggs) {
        PokemonProperties eggData = BreedingUtilities.chooseEgg(possibleEggs);
        ItemStack eggItem = null;
        if (eggData != null) {
            if (eggData.getSpecies() != null) {
                Species egg_pokemon = PokemonSpecies.getByName((String)eggData.getSpecies());
                if (egg_pokemon != null) {
                    FormData form = egg_pokemon.getStandardForm();
                    if (eggData.getForm() != null) {
                        form = egg_pokemon.getFormByShowdownId(eggData.getForm());
                    }
                    eggItem = Cobbreeding.config.getCustomColors() ? EggUtilities.selectEggItem(form) : new ItemStack((ItemLike)Cobbreeding.EGG_ITEMS.get("pokemon_egg").get());
                    Object name = eggData.getSpecies();
                    if (eggData.getForm() != null && !form.getName().equals("Normal")) {
                        name = (String)name + " " + form.getName();
                    }
                    eggItem.set((DataComponentType)CobbreedingComponents.NAME.get(), name);
                    eggItem.set((DataComponentType)CobbreedingComponents.TIMER.get(), (Object)EggUtilities.calculateTimer(egg_pokemon));
                }
                if (eggData.getSpecies().equals("random")) {
                    eggItem = new ItemStack((ItemLike)Cobbreeding.EGG_ITEMS.get("pokemon_egg").get());
                    eggItem.set((DataComponentType)CobbreedingComponents.TIMER.get(), (Object)EggUtilities.calculateTimer(PokemonSpecies.random()));
                }
                if (egg_pokemon != null || eggData.getSpecies().equals("random")) {
                    if (!PokemonPastureBlockEntityMixin.cobbreeding$getConfig().getEggEncryptionEnabled()) {
                        eggItem.set((DataComponentType)CobbreedingComponents.POKEMON_PROPERTIES.get(), (Object)eggData.asString(" "));
                    }
                    eggItem.set((DataComponentType)CobbreedingComponents.EGG_INFO.get(), (Object)EggUtilities.encrypt(eggData));
                    eggItem.set((DataComponentType)CobbreedingComponents.VERSION.get(), (Object)"2.1.0");
                    PokemonPastureBlockEntityMixin.cobbreeding$set(data.getEggs(), eggItem);
                }
            }
            if (eggItem == null) {
                Cobbreeding.LOGGER.error("Couldn't add egg to pasture. Properties : {}", (Object)eggData);
            }
        }
        data.setRequiredTicks(PokemonPastureBlockEntityMixin.cobbreeding$getNewBreedingTime());
    }

    @Unique
    private static void cobbreeding$set(NonNullList<ItemStack> list, ItemStack stack) {
        for (int slot = 0; slot < list.size(); ++slot) {
            ItemStack itemStack = (ItemStack)list.get(slot);
            if (itemStack.getCount() != 0) continue;
            list.set(slot, (Object)stack);
            return;
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"saveAdditional"})
    private void writeNbt(CompoundTag nbt, HolderLookup.Provider provider, CallbackInfo ci) {
        ContainerHelper.saveAllItems((CompoundTag)nbt, this.getItems(), (HolderLookup.Provider)provider);
    }

    @Inject(at={@At(value="TAIL")}, method={"loadAdditional"})
    private void readNbt(CompoundTag nbt, HolderLookup.Provider provider, CallbackInfo ci) {
        ContainerHelper.loadAllItems((CompoundTag)nbt, this.getItems(), (HolderLookup.Provider)provider);
    }

    public boolean canPlaceItemThroughFace(int slot, ItemStack stack, Direction direction) {
        return false;
    }

    public boolean canTakeItemThroughFace(int slot, ItemStack stack, Direction direction) {
        return PokemonPastureBlockEntityMixin.cobbreeding$getConfig().getAllowHoppersToPullFromPastureBlock();
    }

    public int @NotNull [] getSlotsForFace(Direction direction) {
        if (COBBREEDING_INVENTORY_SLOTS == null || COBBREEDING_INVENTORY_SLOTS.length > PokemonPastureBlockEntityMixin.cobbreeding$getConfig().getPastureInventorySize()) {
            COBBREEDING_INVENTORY_SLOTS = new int[PokemonPastureBlockEntityMixin.cobbreeding$getConfig().getPastureInventorySize()];
            for (int i = 0; i < COBBREEDING_INVENTORY_SLOTS.length; ++i) {
                PokemonPastureBlockEntityMixin.COBBREEDING_INVENTORY_SLOTS[i] = i;
            }
        }
        return COBBREEDING_INVENTORY_SLOTS;
    }
}

