/*
 * Decompiled with CFR 0.152.
 */
package ludichat.cobbreeding.network;

import com.cobblemon.mod.common.api.net.ServerNetworkPacketHandler;
import com.cobblemon.mod.common.api.pasture.PastureLink;
import com.cobblemon.mod.common.api.pasture.PastureLinkManager;
import java.io.File;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import ludichat.cobbreeding.Cobbreeding;
import ludichat.cobbreeding.CustomProperties;
import ludichat.cobbreeding.network.ToggleBreedingPacket;
import ludichat.cobbreeding.utils.CobbreedingFile;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.LevelResource;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J'\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lludichat/cobbreeding/network/ToggleBreedingPacketPacketHandler;", "Lcom/cobblemon/mod/common/api/net/ServerNetworkPacketHandler;", "Lludichat/cobbreeding/network/ToggleBreedingPacket;", "<init>", "()V", "packet", "Lnet/minecraft/server/MinecraftServer;", "server", "Lnet/minecraft/server/level/ServerPlayer;", "player", "", "handle", "(Lludichat/cobbreeding/network/ToggleBreedingPacket;Lnet/minecraft/server/MinecraftServer;Lnet/minecraft/server/level/ServerPlayer;)V", "common"})
public final class ToggleBreedingPacketPacketHandler
implements ServerNetworkPacketHandler<ToggleBreedingPacket> {
    @NotNull
    public static final ToggleBreedingPacketPacketHandler INSTANCE = new ToggleBreedingPacketPacketHandler();

    private ToggleBreedingPacketPacketHandler() {
    }

    public void handle(@NotNull ToggleBreedingPacket packet, @NotNull MinecraftServer server, @NotNull ServerPlayer player) {
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        String string = player.getStringUUID();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStringUUID(...)");
        String uuid = string;
        Level world = player.level();
        PastureLink pastureLink = PastureLinkManager.getLinkByPlayer((ServerPlayer)player);
        if (pastureLink == null) {
            return;
        }
        BlockPos pastureBlock = pastureLink.getPos();
        BlockState pastureState = world.getBlockState(pastureBlock);
        Path path = server.getWorldPath(LevelResource.ROOT).resolve("pokemon").resolve("cobbreeding");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        Path path2 = path;
        File file = path2.resolve("pastures").toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
        File pastureFile = file;
        File file2 = path2.resolve(StringsKt.take((String)uuid, (int)2)).resolve(uuid).toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"toFile(...)");
        File playerFile = file2;
        playerFile.getParentFile().mkdirs();
        if (((Boolean)pastureState.getValue((Property)CustomProperties.BREEDING_ACTIVATED)).booleanValue()) {
            String string2 = pastureBlock.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            String ownerUuid = String.valueOf(CobbreedingFile.getUuid(pastureFile, string2));
            File ownerFile = path2.resolve(StringsKt.take((String)ownerUuid, (int)2)).resolve(ownerUuid).toFile();
            String string3 = pastureBlock.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
            CobbreedingFile.removeCompoundTag(pastureFile, string3);
            Intrinsics.checkNotNull((Object)ownerFile);
            String string4 = pastureBlock.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toString(...)");
            CobbreedingFile.removeCompoundTag(ownerFile, string4);
            world.setBlockAndUpdate(pastureBlock, (BlockState)pastureState.setValue((Property)CustomProperties.BREEDING_ACTIVATED, (Comparable)Boolean.valueOf(false)));
        } else {
            int activatedPasture = CobbreedingFile.getNumberOfActivatedPastures(playerFile);
            if (Cobbreeding.INSTANCE.getConfig().getMaxNumberOfActivatedPasturePerPlayer() == -1 || activatedPasture < Cobbreeding.INSTANCE.getConfig().getMaxNumberOfActivatedPasturePerPlayer() && activatedPasture != -1) {
                String string5 = pastureBlock.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toString(...)");
                CobbreedingFile.addCompoundTag(pastureFile, string5, null, player.getUUID());
                String string6 = pastureBlock.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"toString(...)");
                int[] nArray = new int[]{pastureBlock.getX(), pastureBlock.getY(), pastureBlock.getZ()};
                CobbreedingFile.addCompoundTag(playerFile, string6, nArray, null);
                world.setBlockAndUpdate(pastureBlock, (BlockState)pastureState.setValue((Property)CustomProperties.BREEDING_ACTIVATED, (Comparable)Boolean.valueOf(true)));
            } else if (activatedPasture == -1) {
                player.sendSystemMessage((Component)Component.translatable((String)"cobbreeding.msg.add_pasture.fail"));
            } else {
                player.sendSystemMessage((Component)Component.translatable((String)"cobbreeding.msg.add_pasture.too_many_pastures"));
            }
        }
    }
}

