/*
 * Decompiled with CFR 0.152.
 */
package ludichat.cobbreeding.utils;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Base64;
import java.util.UUID;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import ludichat.cobbreeding.Cobbreeding;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\t\u0010\nJ3\u0010\u0012\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u00042\b\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0010H\u0007\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u001f\u0010\u0014\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0014\u0010\u0015J!\u0010\u0016\u001a\u0004\u0018\u00010\u00102\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0017\u0010\u0019\u001a\u00020\u00182\u0006\u0010\f\u001a\u00020\u000bH\u0007\u00a2\u0006\u0004\b\u0019\u0010\u001aJ!\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\u000b2\b\b\u0002\u0010\u001c\u001a\u00020\u0018H\u0007\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u000f\u0010 \u001a\u00020\u001fH\u0007\u00a2\u0006\u0004\b \u0010!\u00a8\u0006\""}, d2={"Lludichat/cobbreeding/utils/CobbreedingFile;", "", "<init>", "()V", "", "path", "", "read", "", "logIOError", "(Ljava/lang/String;Z)V", "Ljava/io/File;", "file", "key", "", "posValue", "Ljava/util/UUID;", "uuidValue", "addCompoundTag", "(Ljava/io/File;Ljava/lang/String;[ILjava/util/UUID;)V", "removeCompoundTag", "(Ljava/io/File;Ljava/lang/String;)V", "getUuid", "(Ljava/io/File;Ljava/lang/String;)Ljava/util/UUID;", "", "getNumberOfActivatedPastures", "(Ljava/io/File;)I", "encryptionFile", "keySize", "generateAESKey", "(Ljava/io/File;I)V", "Ljavax/crypto/SecretKey;", "getEncryptionKey", "()Ljavax/crypto/SecretKey;", "common"})
public final class CobbreedingFile {
    @NotNull
    public static final CobbreedingFile INSTANCE = new CobbreedingFile();

    private CobbreedingFile() {
    }

    private final void logIOError(String path, boolean read) {
        Cobbreeding.LOGGER.error("Couldn't " + (read ? "read" : "write") + " in file " + path);
    }

    @JvmStatic
    public static final void addCompoundTag(@NotNull File file, @NotNull String key, @Nullable int[] posValue, @Nullable UUID uuidValue) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        CompoundTag nbt = new CompoundTag();
        try {
            if (file.exists()) {
                CompoundTag compoundTag = NbtIo.read((Path)file.toPath());
                Intrinsics.checkNotNull((Object)compoundTag);
                nbt = compoundTag;
            }
            if (posValue != null && !(posValue.length == 0)) {
                nbt.putIntArray(key, posValue);
            }
            if (uuidValue != null) {
                nbt.putUUID(key, uuidValue);
            }
            NbtIo.write((CompoundTag)nbt, (Path)file.toPath());
        }
        catch (IOException iOException) {
            String string = file.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            INSTANCE.logIOError(string, false);
        }
    }

    @JvmStatic
    public static final void removeCompoundTag(@NotNull File file, @NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        CompoundTag nbt = new CompoundTag();
        try {
            if (file.exists()) {
                CompoundTag compoundTag = NbtIo.read((Path)file.toPath());
                Intrinsics.checkNotNull((Object)compoundTag);
                nbt = compoundTag;
            }
            nbt.remove(key);
            NbtIo.write((CompoundTag)nbt, (Path)file.toPath());
        }
        catch (IOException iOException) {
            String string = file.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            INSTANCE.logIOError(string, false);
        }
    }

    @JvmStatic
    @Nullable
    public static final UUID getUuid(@NotNull File file, @NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        CompoundTag nbt = new CompoundTag();
        try {
            if (file.exists()) {
                CompoundTag compoundTag = NbtIo.read((Path)file.toPath());
                Intrinsics.checkNotNull((Object)compoundTag);
                nbt = compoundTag;
            }
            return nbt.getUUID(key);
        }
        catch (IOException iOException) {
            String string = file.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            INSTANCE.logIOError(string, true);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return null;
    }

    @JvmStatic
    public static final int getNumberOfActivatedPastures(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        CompoundTag nbt = new CompoundTag();
        try {
            if (file.exists()) {
                CompoundTag compoundTag = NbtIo.read((Path)file.toPath());
                Intrinsics.checkNotNull((Object)compoundTag);
                nbt = compoundTag;
            }
            return nbt.size();
        }
        catch (IOException iOException) {
            String string = file.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            INSTANCE.logIOError(string, true);
        }
        catch (NullPointerException nullPointerException) {
            return 0;
        }
        return -1;
    }

    @JvmStatic
    public static final void generateAESKey(@NotNull File encryptionFile, int keySize) {
        Intrinsics.checkNotNullParameter((Object)encryptionFile, (String)"encryptionFile");
        try {
            KeyGenerator keyGenerator = KeyGenerator.getInstance("AES");
            keyGenerator.init(keySize);
            String string = Base64.getEncoder().encodeToString(keyGenerator.generateKey().getEncoded());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"encodeToString(...)");
            FilesKt.writeText$default((File)encryptionFile, (String)string, null, (int)2, null);
        }
        catch (IOException iOException) {
            Cobbreeding.LOGGER.error("Couldn't create encryption key.");
        }
    }

    public static /* synthetic */ void generateAESKey$default(File file, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 128;
        }
        CobbreedingFile.generateAESKey(file, n);
    }

    @JvmStatic
    @NotNull
    public static final SecretKey getEncryptionKey() {
        File encryptionFile = new File("config/cobbreeding/encryption");
        if (!encryptionFile.exists()) {
            CobbreedingFile.generateAESKey$default(encryptionFile, 0, 2, null);
        }
        byte[] byArray = Base64.getDecoder().decode(FilesKt.readText$default((File)encryptionFile, null, (int)1, null));
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"decode(...)");
        byte[] decodedKey = byArray;
        return new SecretKeySpec(decodedKey, 0, decodedKey.length, "AES");
    }
}

