/*
 * Decompiled with CFR 0.152.
 */
package kiwiapollo.tmcraft.datagen;

import java.util.concurrent.CompletableFuture;
import kiwiapollo.tmcraft.datagen.BlankDiscRecipeGenerator;
import kiwiapollo.tmcraft.datagen.BlockTagProvider;
import kiwiapollo.tmcraft.datagen.CopperTMRecipeGenerator;
import kiwiapollo.tmcraft.datagen.DiamondTMRecipeGenerator;
import kiwiapollo.tmcraft.datagen.EmeraldTMRecipeGenerator;
import kiwiapollo.tmcraft.datagen.GoldTMRecipeGenerator;
import kiwiapollo.tmcraft.datagen.IronTMRecipeGenerator;
import kiwiapollo.tmcraft.datagen.LootTableProvider;
import kiwiapollo.tmcraft.datagen.ModTagRegistry;
import kiwiapollo.tmcraft.datagen.MoveTutorTableRecipeGenerator;
import kiwiapollo.tmcraft.datagen.NetheriteTMRecipeGenerator;
import kiwiapollo.tmcraft.datagen.PoiTagProvider;
import kiwiapollo.tmcraft.datagen.PokemonBreederTableRecipeGenerator;
import kiwiapollo.tmcraft.datagen.SmithingTemplateRecipeGenerator;
import kiwiapollo.tmcraft.item.eggmove.EggMoveItem;
import kiwiapollo.tmcraft.item.misc.BlankBookItem;
import kiwiapollo.tmcraft.item.misc.BlankDiscItem;
import kiwiapollo.tmcraft.item.misc.BlankEggItem;
import kiwiapollo.tmcraft.item.misc.BlankStarItem;
import kiwiapollo.tmcraft.item.tmmove.TMMoveItem;
import kiwiapollo.tmcraft.item.tutormove.TutorMoveItem;
import net.fabricmc.fabric.api.datagen.v1.DataGeneratorEntrypoint;
import net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricRecipeProvider;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricTagProvider;
import net.minecraft.class_1792;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import net.minecraft.class_8790;

public class DataGenerator
implements DataGeneratorEntrypoint {
    public void onInitializeDataGenerator(FabricDataGenerator fabricDataGenerator) {
        FabricDataGenerator.Pack pack = fabricDataGenerator.createPack();
        pack.addProvider(RecipeProvider::new);
        pack.addProvider(ItemTagProvider::new);
        pack.addProvider(PoiTagProvider::new);
        pack.addProvider(BlockTagProvider::new);
        pack.addProvider(LootTableProvider::new);
    }

    private static class ItemTagProvider
    extends FabricTagProvider<class_1792> {
        public ItemTagProvider(FabricDataOutput output, CompletableFuture<class_7225.class_7874> registriesFuture) {
            super(output, class_7924.field_41197, registriesFuture);
        }

        protected void method_10514(class_7225.class_7874 arg) {
            TMMoveItem.getAll().forEach(arg_0 -> ((FabricTagProvider.FabricTagBuilder)this.getOrCreateTagBuilder(ModTagRegistry.TM_MOVES)).add(arg_0));
            EggMoveItem.getAll().forEach(arg_0 -> ((FabricTagProvider.FabricTagBuilder)this.getOrCreateTagBuilder(ModTagRegistry.EGG_MOVES)).add(arg_0));
            TutorMoveItem.getAll().forEach(arg_0 -> ((FabricTagProvider.FabricTagBuilder)this.getOrCreateTagBuilder(ModTagRegistry.TUTOR_MOVES)).add(arg_0));
            TutorMoveItem.getAll().forEach(arg_0 -> ((FabricTagProvider.FabricTagBuilder)this.getOrCreateTagBuilder(ModTagRegistry.STAR_MOVES)).add(arg_0));
            BlankDiscItem.getAll().forEach(arg_0 -> ((FabricTagProvider.FabricTagBuilder)this.getOrCreateTagBuilder(ModTagRegistry.BLANK_DISCS)).add(arg_0));
            BlankEggItem.getAll().forEach(arg_0 -> ((FabricTagProvider.FabricTagBuilder)this.getOrCreateTagBuilder(ModTagRegistry.BLANK_EGGS)).add(arg_0));
            BlankBookItem.getAll().forEach(arg_0 -> ((FabricTagProvider.FabricTagBuilder)this.getOrCreateTagBuilder(ModTagRegistry.BLANK_BOOKS)).add(arg_0));
            BlankStarItem.getAll().forEach(arg_0 -> ((FabricTagProvider.FabricTagBuilder)this.getOrCreateTagBuilder(ModTagRegistry.BLANK_STARS)).add(arg_0));
        }
    }

    private static class RecipeProvider
    extends FabricRecipeProvider {
        public RecipeProvider(FabricDataOutput output, CompletableFuture<class_7225.class_7874> registriesFuture) {
            super(output, registriesFuture);
        }

        public void method_10419(class_8790 exporter) {
            new CopperTMRecipeGenerator().generate(exporter);
            new IronTMRecipeGenerator().generate(exporter);
            new GoldTMRecipeGenerator().generate(exporter);
            new DiamondTMRecipeGenerator().generate(exporter);
            new EmeraldTMRecipeGenerator().generate(exporter);
            new NetheriteTMRecipeGenerator().generate(exporter);
            new BlankDiscRecipeGenerator().generate(exporter);
            new SmithingTemplateRecipeGenerator().generate(exporter);
            new MoveTutorTableRecipeGenerator().generate(exporter);
            new PokemonBreederTableRecipeGenerator().generate(exporter);
        }
    }
}

