/*
 * Decompiled with CFR 0.152.
 */
package com.jummit.nethermap.config;

import com.jummit.nethermap.CreationHeight;
import com.jummit.nethermap.FixedHeight;
import com.jummit.nethermap.Height;
import com.jummit.nethermap.HeightmapHeight;
import com.jummit.nethermap.config.FixedEntry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.annotation.ConfigEntry;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_22;
import net.minecraft.class_2818;

@Config(name="nethermap")
public class NetherMapConfig
implements ConfigData {
    @ConfigEntry.Gui.Tooltip
    public boolean useMapCreationHeight = true;
    @ConfigEntry.Gui.Tooltip
    public int fixedHeight = 100;
    @ConfigEntry.Gui.Tooltip
    public List<FixedEntry> fixedEntries = Arrays.asList(new FixedEntry("minecraft:the_nether", 40));
    @ConfigEntry.Gui.Tooltip
    public List<String> creationHeightEntries = new ArrayList<String>();

    public static NetherMapConfig getInstance() {
        return (NetherMapConfig)AutoConfig.getConfigHolder(NetherMapConfig.class).getConfig();
    }

    public Height getHeightFor(class_2818 chunk, int x, int z, class_1937 world, class_1297 entity, class_22 state) {
        String dimension = world.method_27983().method_29177().toString();
        HeightmapHeight heightmapHeight = new HeightmapHeight(chunk, x, z);
        CreationHeight creationHeight = new CreationHeight(world, entity, state, heightmapHeight);
        for (FixedEntry fixedEntry : this.fixedEntries) {
            if (!fixedEntry.dimension.equals(dimension)) continue;
            return new FixedHeight(fixedEntry.height);
        }
        for (String string : this.creationHeightEntries) {
            if (!string.equals(dimension)) continue;
            return creationHeight;
        }
        if (!world.method_8597().comp_643()) {
            return heightmapHeight;
        }
        if (this.useMapCreationHeight) {
            return creationHeight;
        }
        return new FixedHeight(this.fixedHeight);
    }
}

