/*
 * Decompiled with CFR 0.152.
 */
package com.dremixam.pastureLoot;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;

public class Config {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final String CONFIG_FILE = "config/PastureLoot.json";
    private int dropCheckTicks = 1200;
    private float dropChance = 0.05f;
    private String[] itemBlacklist = Defaults.ITEM_BLACKLIST;
    private boolean legacyFlattenItemQuantity = false;
    private double dropChancePerTick;

    private Config() {
        this.updateDropChancePerTick();
    }

    public int getDropCheckTicks() {
        return this.dropCheckTicks;
    }

    public float getDropChance() {
        return this.dropChance;
    }

    private void updateDropChancePerTick() {
        this.dropChancePerTick = 1.0 - Math.pow(1.0f - this.dropChance, 1.0 / (double)this.dropCheckTicks);
    }

    public double getDropChancePerTick() {
        return this.dropChancePerTick;
    }

    public String[] getItemBlacklist() {
        return this.itemBlacklist;
    }

    public boolean legacyFlattenItemQuantity() {
        return this.legacyFlattenItemQuantity;
    }

    public static Config load() {
        Config config = new Config();
        boolean needsSave = false;
        try (FileReader reader = new FileReader(CONFIG_FILE);){
            JsonObject json = JsonParser.parseReader((Reader)reader).getAsJsonObject();
            config.dropCheckTicks = json.get("tick_per_minute").getAsInt();
            config.dropChance = json.get("drop_chance_per_minute").getAsFloat();
            config.itemBlacklist = (String[])GSON.fromJson(json.get("item_blacklist"), String[].class);
            if (json.has("legacy_flatten_item_quantity")) {
                config.legacyFlattenItemQuantity = json.get("legacy_flatten_item_quantity").getAsBoolean();
            } else {
                needsSave = true;
            }
            config.updateDropChancePerTick();
        }
        catch (IOException e) {
            config = new Config();
            config.save();
        }
        if (needsSave) {
            config.save();
        }
        return config;
    }

    private void save() {
        JsonObject json = new JsonObject();
        json.addProperty("tick_per_minute", (Number)this.dropCheckTicks);
        json.addProperty("drop_chance_per_minute", (Number)Float.valueOf(this.dropChance));
        json.add("item_blacklist", GSON.toJsonTree((Object)this.itemBlacklist));
        json.addProperty("legacy_flatten_item_quantity", Boolean.valueOf(this.legacyFlattenItemQuantity));
        try (FileWriter writer = new FileWriter(CONFIG_FILE);){
            GSON.toJson((JsonElement)json, (Appendable)writer);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static class Defaults {
        public static final int DROP_CHECK_TICKS = 1200;
        public static final float DROP_CHANCE = 0.05f;
        public static final String[] ITEM_BLACKLIST = new String[]{"minecraft:porkchop", "minecraft:beef", "minecraft:chicken", "minecraft:mutton", "minecraft:rabbit", "minecraft:fish", "minecraft:cooked_porkchop", "minecraft:cooked_beef", "minecraft:cooked_chicken", "minecraft:cooked_mutton", "minecraft:cooked_rabbit", "minecraft:cooked_fish", "minecraft:leather", "minecraft:bone", "minecraft:spider_eye", "minecraft:rotten_flesh", "minecraft:rabbit_hide", "minecraft:rabbit_foot", "minecraft:cod", "minecraft:pufferfish", "minecraft:bone_block", "minecraft:bone_meal", "cobblemon:sharp_beak", "minecraft:honey_bottle", "minecraft:salmon", "minecraft:white_wool"};
        public static final boolean LEGACY_FLATTEN_ITEM_QUANTITY = false;
    }
}

