/*
 * Decompiled with CFR 0.152.
 */
package com.dremixam.pastureLoot.mixin;

import com.cobblemon.mod.common.api.drop.DropEntry;
import com.cobblemon.mod.common.api.drop.DropTable;
import com.cobblemon.mod.common.api.drop.ItemDropEntry;
import com.cobblemon.mod.common.block.entity.PokemonPastureBlockEntity;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.FormData;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.dremixam.pastureLoot.Config;
import com.dremixam.pastureLoot.PastureLoot;
import java.util.Arrays;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_7924;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PokemonPastureBlockEntity.class})
public abstract class PokemonPastureBlockEntityMixin {
    @Unique
    private static final Logger LOGGER = PastureLoot.LOGGER;

    @Unique
    private static Config getConfig() {
        return PastureLoot.INSTANCE.getConfig();
    }

    @Inject(at={@At(value="HEAD")}, method={"TICKER$lambda$0"})
    private static void tick(class_1937 world, class_2338 pos, class_2680 state, PokemonPastureBlockEntity blockEntity, CallbackInfo ci) {
        if (world.field_9236) {
            return;
        }
        blockEntity.getTetheredPokemon().forEach(tethering -> {
            Pokemon pokemon;
            double randomNumber = Math.random();
            if (randomNumber < PokemonPastureBlockEntityMixin.getConfig().getDropChancePerTick() && (pokemon = tethering.getPokemon()) != null && !pokemon.isFainted()) {
                PokemonEntity entity = pokemon.getEntity();
                if (entity == null) {
                    return;
                }
                try {
                    FormData form = pokemon.getForm();
                    DropTable dropTable = form.getDrops();
                    List drops = dropTable.getDrops(dropTable.getAmount(), pokemon);
                    class_3218 serverWorld = (class_3218)world;
                    if (drops.isEmpty()) {
                        return;
                    }
                    DropEntry drop = (DropEntry)drops.get(serverWorld.field_9229.method_43048(drops.size()));
                    if (drop instanceof ItemDropEntry) {
                        ItemDropEntry itemDropEntry = (ItemDropEntry)drop;
                        if (!Arrays.asList(PokemonPastureBlockEntityMixin.getConfig().getItemBlacklist()).contains(itemDropEntry.getItem().toString())) {
                            if (PokemonPastureBlockEntityMixin.getConfig().legacyFlattenItemQuantity()) {
                                class_1792 item = (class_1792)world.method_30349().method_30530(class_7924.field_41197).method_10223(itemDropEntry.getItem());
                                if (item != null) {
                                    class_1799 stack = new class_1799((class_1935)item, 1);
                                    world.method_8649((class_1297)new class_1542(world, entity.method_23317(), entity.method_23318(), entity.method_23321(), stack));
                                    LOGGER.debug("Dropped " + String.valueOf(stack) + " from " + pokemon.getSpecies().getName() + " at " + String.valueOf(pos));
                                }
                            } else {
                                itemDropEntry.drop((class_1309)entity, serverWorld, entity.method_19538(), null);
                                LOGGER.debug("Dropping {} from {} with quantityRange={} at {}", new Object[]{itemDropEntry.getItem(), pokemon.getSpecies().getName(), itemDropEntry.getQuantityRange(), pos});
                            }
                        }
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Error while dropping loot", (Throwable)e);
                }
            }
        });
    }
}

