/*
 * Decompiled with CFR 0.152.
 */
package io.strikeknight57.bca.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.strikeknight57.bca.net.packet.RaycastBlockC2SPayload;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2621;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_7225;
import net.minecraft.class_7924;

public class RaycastReceiver {
    public static void init() {
        PayloadTypeRegistry.playC2S().register(RaycastBlockC2SPayload.ID, RaycastBlockC2SPayload.CODEC);
        ServerPlayNetworking.registerGlobalReceiver(RaycastBlockC2SPayload.ID, (payload, context) -> {
            if (!context.player().method_7337()) {
                return;
            }
            context.server().execute(() -> {
                class_2621 lootable;
                class_5321 tableKey;
                class_1937 world = context.player().method_37908();
                class_2586 block = world.method_8321(payload.pos());
                if (block == null) {
                    return;
                }
                RaycastReceiver.replaceLoot(context, block, world, payload);
                if (block instanceof class_2621 && (tableKey = (lootable = (class_2621)block).method_54869()) != null) {
                    class_52 lootTable = world.method_8503().method_58576().method_58295(tableKey);
                    class_52.field_50021.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)lootTable).resultOrPartial(System.err::println).ifPresent(json -> {
                        if (json.isJsonObject()) {
                            RaycastReceiver.sendLootTableInfo(context.player(), json.getAsJsonObject());
                        } else {
                            System.err.println("LootTable codec returned non-object: " + String.valueOf(json));
                        }
                    });
                }
            });
        });
    }

    private static void replaceLoot(ServerPlayNetworking.Context context, class_2586 block, class_1937 world, RaycastBlockC2SPayload payload) {
        String raw = payload.lootTable().trim();
        class_2960 id = class_2960.method_12829((String)raw);
        if (id == null) {
            context.player().method_43496((class_2561)class_2561.method_43470((String)("Invalid loot table id: " + raw)));
            return;
        }
        class_5321 key = class_5321.method_29179((class_5321)class_7924.field_50079, (class_2960)id);
        class_52 table = world.method_8503().method_58576().method_58295(key);
        if (table == class_52.field_948) {
            context.player().method_43496((class_2561)class_2561.method_43470((String)("Unknown loot table: " + String.valueOf(id))));
            return;
        }
        class_2487 nbtCompound = new class_2487();
        nbtCompound.method_10582("LootTable", id.toString());
        class_2680 state = block.method_10997().method_8320(payload.pos());
        block.method_58690(nbtCompound, (class_7225.class_7874)world.method_30349());
        block.method_5431();
        block.method_10997().method_8413(payload.pos(), state, state, 1);
        context.player().method_43496((class_2561)class_2561.method_43470((String)("Loot table set: " + String.valueOf(id))));
    }

    private static String getCountRange(JsonObject entry) {
        Object countRange = "1";
        if (entry.has("functions") && entry.get("functions").isJsonArray()) {
            for (JsonElement funcEl : entry.getAsJsonArray("functions")) {
                JsonObject func;
                if (!funcEl.isJsonObject() || !(func = funcEl.getAsJsonObject()).has("function") || !"minecraft:set_count".equals(func.get("function").getAsString()) || !func.has("count")) continue;
                JsonElement countEl = func.get("count");
                if (countEl.isJsonPrimitive() && countEl.getAsJsonPrimitive().isNumber()) {
                    int n = countEl.getAsInt();
                    countRange = String.valueOf(n);
                    continue;
                }
                if (!countEl.isJsonObject()) continue;
                JsonObject countObj = countEl.getAsJsonObject();
                int min = countObj.has("min") ? countObj.get("min").getAsInt() : 1;
                int max = countObj.has("max") ? countObj.get("max").getAsInt() : min;
                countRange = min == max ? String.valueOf(min) : min + "-" + max;
            }
        }
        return countRange;
    }

    private static double getTotalWeight(JsonArray entries) {
        double total = 0.0;
        for (JsonElement entryEl : entries) {
            if (!entryEl.isJsonObject()) continue;
            JsonObject entry = entryEl.getAsJsonObject();
            total += entry.has("weight") ? entry.get("weight").getAsDouble() : 1.0;
        }
        return total;
    }

    private static String formatName(String rawName) {
        if (rawName == null || rawName.isEmpty()) {
            return "(unnamed)";
        }
        if (rawName.contains(":")) {
            rawName = rawName.substring(rawName.indexOf(":") + 1);
        }
        String[] words = rawName.split("_");
        StringBuilder formatted = new StringBuilder();
        for (String word : words) {
            if (word.isEmpty()) continue;
            formatted.append(Character.toUpperCase(word.charAt(0))).append(word.substring(1)).append(" ");
        }
        return formatted.toString().trim();
    }

    private static List<EntryInfo> buildVerboseEntries(JsonArray entries) {
        double totalWeight = RaycastReceiver.getTotalWeight(entries);
        ArrayList<EntryInfo> infos = new ArrayList<EntryInfo>();
        for (JsonElement entryEl : entries) {
            String label;
            if (!entryEl.isJsonObject()) {
                infos.add(new EntryInfo(0.0, "  - (skipped non-object entry): " + String.valueOf(entryEl) + "\n"));
                continue;
            }
            JsonObject entry = entryEl.getAsJsonObject();
            String type = entry.get("type").getAsString();
            String countRange = "1";
            if (type.contains("loot_table")) {
                String rawId = entry.has("value") ? entry.get("value").getAsString() : (entry.has("name") ? entry.get("name").getAsString() : "(missing value)");
                int lastSlash = rawId.lastIndexOf(47);
                String Id = rawId.substring(lastSlash + 1);
                label = RaycastReceiver.formatName(Id);
            } else {
                String rawName = entry.has("name") ? entry.get("name").getAsString() : "(no name)";
                label = RaycastReceiver.formatName(rawName);
                countRange = RaycastReceiver.getCountRange(entry);
            }
            double weight = entry.has("weight") ? entry.get("weight").getAsDouble() : 1.0;
            double chanceVal = totalWeight > 0.0 ? weight / totalWeight * 100.0 : 0.0;
            String chanceStr = String.format("%.2f%%", chanceVal);
            infos.add(new EntryInfo(chanceVal, "  - " + chanceStr + " chance to spawn " + countRange + " " + label + "\n"));
        }
        infos.sort((a, b) -> Double.compare(b.chance, a.chance));
        return infos;
    }

    private static List<String> buildCompactEntries(JsonArray entries) {
        double totalWeight = RaycastReceiver.getTotalWeight(entries);
        ArrayList<String> compact = new ArrayList<String>();
        for (JsonElement entryEl : entries) {
            if (!entryEl.isJsonObject()) {
                compact.add("(skip non-object: " + String.valueOf(entryEl) + ")");
                continue;
            }
            JsonObject entry = entryEl.getAsJsonObject();
            String type = entry.has("type") ? entry.get("type").getAsString() : "item";
            double weight = entry.has("weight") ? entry.get("weight").getAsDouble() : 1.0;
            double chance = totalWeight > 0.0 ? weight / totalWeight * 100.0 : 0.0;
            String chanceStr = String.format("%.2f%%", chance);
            if ("loot_table".equals(type)) {
                String rawId = entry.has("value") ? entry.get("value").getAsString() : (entry.has("name") ? entry.get("name").getAsString() : "(missing value)");
                compact.add("Loot table \u2192 " + RaycastReceiver.formatName(rawId) + ": " + chanceStr);
                continue;
            }
            String rawName = entry.has("name") ? entry.get("name").getAsString() : "(no name)";
            String countRange = RaycastReceiver.getCountRange(entry);
            compact.add(countRange + " " + RaycastReceiver.formatName(rawName) + ": " + chanceStr);
        }
        return compact;
    }

    private static long countLines(String text) {
        return text.chars().filter(ch -> ch == 10).count() + (long)(!text.isEmpty() && text.charAt(text.length() - 1) != '\n' ? 1 : 0);
    }

    private static void sendLootTableInfo(class_3222 player, JsonObject root) {
        if (!root.has("pools") || !root.get("pools").isJsonArray()) {
            return;
        }
        JsonArray pools = root.getAsJsonArray("pools");
        StringBuilder output = new StringBuilder("Total Pools: ").append(pools.size()).append("\n");
        for (int i = 0; i < pools.size(); ++i) {
            JsonElement poolEl = pools.get(i);
            if (!poolEl.isJsonObject()) {
                output.append("  Pool ").append(i + 1).append(" is not an object: ").append(poolEl).append("\n");
                continue;
            }
            JsonObject pool = poolEl.getAsJsonObject();
            if (pool.has("rolls")) {
                JsonElement rollsEl = pool.get("rolls");
                String rollText = RaycastReceiver.formatRolls(rollsEl);
                output.append("  Pool ").append(i + 1).append(" Rolled ").append(rollText).append(" Times:\n");
            }
            if (!pool.has("entries") || !pool.get("entries").isJsonArray()) continue;
            for (EntryInfo info : RaycastReceiver.buildVerboseEntries(pool.getAsJsonArray("entries"))) {
                output.append(info.line);
            }
        }
        if (RaycastReceiver.countLines(output.toString()) <= 75L) {
            player.method_43496((class_2561)class_2561.method_43470((String)output.toString()));
            return;
        }
        StringBuilder compactOutput = new StringBuilder("Total Pools: ").append(pools.size()).append("\n");
        for (int i = 0; i < pools.size(); ++i) {
            JsonElement poolEl = pools.get(i);
            if (!poolEl.isJsonObject()) {
                compactOutput.append("  Pool ").append(i + 1).append(": [skip non-object]\n");
                continue;
            }
            JsonObject pool = poolEl.getAsJsonObject();
            if (pool.has("rolls")) {
                JsonElement rollsEl = pool.get("rolls");
                String rollText = RaycastReceiver.formatRolls(rollsEl).replace(" - ", "-");
                compactOutput.append("  Pool ").append(i + 1).append(" Rolled ").append(rollText).append(" Times:\n");
            }
            if (!pool.has("entries") || !pool.get("entries").isJsonArray()) continue;
            compactOutput.append("    [").append(String.join((CharSequence)", ", RaycastReceiver.buildCompactEntries(pool.getAsJsonArray("entries")))).append("]\n");
        }
        if (RaycastReceiver.countLines(compactOutput.toString()) <= 25L) {
            player.method_43496((class_2561)class_2561.method_43470((String)compactOutput.toString()));
            return;
        }
        ArrayList<CallSite> poolStrings = new ArrayList<CallSite>();
        for (int i = 0; i < pools.size(); ++i) {
            JsonElement poolEl = pools.get(i);
            if (!poolEl.isJsonObject()) {
                poolStrings.add((CallSite)((Object)("Pool " + (i + 1) + ": [skip non-object]")));
                continue;
            }
            JsonObject pool = poolEl.getAsJsonObject();
            Object rollInfo = "";
            if (pool.has("rolls")) {
                JsonElement rollsEl = pool.get("rolls");
                String rollText = RaycastReceiver.formatRolls(rollsEl).replace(" - ", "-");
                rollInfo = "Pool " + (i + 1) + " Rolled " + rollText + " Times: ";
            }
            Object entriesStr = "[]";
            if (pool.has("entries") && pool.get("entries").isJsonArray()) {
                entriesStr = "[" + String.join((CharSequence)", ", RaycastReceiver.buildCompactEntries(pool.getAsJsonArray("entries"))) + "]";
            }
            poolStrings.add((CallSite)((Object)((String)rollInfo + (String)entriesStr)));
        }
        player.method_43496((class_2561)class_2561.method_43470((String)(pools.size() + " Total Pools: {" + String.join((CharSequence)", ", poolStrings) + "}")));
    }

    private static String formatRolls(JsonElement rollsEl) {
        if (rollsEl.isJsonPrimitive() && rollsEl.getAsJsonPrimitive().isNumber()) {
            int n = rollsEl.getAsInt();
            return n + " - " + n;
        }
        if (rollsEl.isJsonObject()) {
            JsonObject rollsObj = rollsEl.getAsJsonObject();
            int min = rollsObj.has("min") ? rollsObj.get("min").getAsInt() : 1;
            int max = rollsObj.has("max") ? rollsObj.get("max").getAsInt() : min;
            return min + " - " + max;
        }
        return "(unknown)";
    }

    private static class EntryInfo {
        double chance;
        String line;

        EntryInfo(double chance, String line) {
            this.chance = chance;
            this.line = line;
        }
    }
}

