"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var formats_exports = {};
__export(formats_exports, {
  Formats: () => Formats
});
module.exports = __toCommonJS(formats_exports);
const Formats = [
  // S/V Singles
  ///////////////////////////////////////////////////////////////////
  {
    section: "S/V Singles"
  },
  {
    name: "[Gen 9] Random Battle",
    desc: `Randomized teams of Pok&eacute;mon with sets that are generated to be competitively viable.`,
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3712619/">Random Battle Suggestions</a>`
    ],
    mod: "gen9",
    team: "random",
    ruleset: ["PotD", "Obtainable", "Species Clause", "HP Percentage Mod", "Cancel Mod", "Sleep Clause Mod", "Illusion Level Mod"]
  },
  {
    name: "[Gen 9] Unrated Random Battle",
    mod: "gen9",
    team: "random",
    challengeShow: false,
    rated: false,
    ruleset: ["Obtainable", "Species Clause", "HP Percentage Mod", "Cancel Mod", "Sleep Clause Mod", "Illusion Level Mod"]
  },
  {
    name: "[Gen 9] Free-For-All Random Battle",
    mod: "gen9",
    team: "random",
    gameType: "freeforall",
    tournamentShow: false,
    rated: false,
    ruleset: ["Obtainable", "Species Clause", "HP Percentage Mod", "Cancel Mod", "Sleep Clause Mod", "Illusion Level Mod"]
  },
  {
    name: "[Gen 9] Random Battle (Blitz)",
    mod: "gen9",
    team: "random",
    ruleset: ["[Gen 9] Random Battle", "Blitz"]
  },
  {
    name: "[Gen 9] Multi Random Battle",
    mod: "gen9",
    team: "random",
    gameType: "multi",
    searchShow: false,
    tournamentShow: false,
    rated: false,
    ruleset: [
      "Max Team Size = 3",
      "Obtainable",
      "Species Clause",
      "HP Percentage Mod",
      "Cancel Mod",
      "Sleep Clause Mod",
      "Illusion Level Mod"
    ]
  },
  {
    name: "[Gen 9] OU",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3732644/">SV OU Metagame Discussion</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3712513/">SV OU Sample Teams</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3732813/">SV OU Viability Rankings</a>`
    ],
    mod: "gen9",
    ruleset: ["Standard", "Sleep Moves Clause", "!Sleep Clause Mod"],
    banlist: ["Uber", "AG", "Arena Trap", "Moody", "Sand Veil", "Shadow Tag", "Snow Cloak", "King's Rock", "Razor Fang", "Baton Pass", "Last Respects", "Shed Tail"]
  },
  {
    name: "[Gen 9] Ubers",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3732719/">Ubers Metagame Discussion</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3724082/">Ubers Viability Rankings</a>`
    ],
    mod: "gen9",
    ruleset: ["Standard"],
    banlist: ["AG", "Moody", "King's Rock", "Razor Fang", "Baton Pass"]
  },
  {
    name: "[Gen 9] UU",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3728797/">UU Metagame Discussion</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3729854/">UU Viability Rankings</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3720278/">UU Sample Teams</a>`
    ],
    mod: "gen9",
    ruleset: ["[Gen 9] OU"],
    banlist: ["OU", "UUBL"]
  },
  {
    name: "[Gen 9] RU",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3725482/">RU Metagame Discussion</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3729823/">RU Viability Rankings</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3717072/">RU Sample Teams</a>`
    ],
    mod: "gen9",
    ruleset: ["[Gen 9] UU"],
    banlist: ["UU", "RUBL", "Light Clay"]
  },
  {
    name: "[Gen 9] NU",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3715408/">NU Metagame Discussion</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3729943/">NU Viability Rankings</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3730216/">NU Sample Teams</a>`
    ],
    mod: "gen9",
    ruleset: ["[Gen 9] RU"],
    banlist: ["RU", "NUBL", "Quick Claw"]
  },
  {
    name: "[Gen 9] PU",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3729623/">PU Viability Rankings</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3719989/">PU Sample Teams</a>`
    ],
    mod: "gen9",
    ruleset: ["[Gen 9] NU"],
    banlist: ["NU", "PUBL", "Drought"]
  },
  {
    name: "[Gen 9] LC",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3710868/">Little Cup Metagame Discussion</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3712989/">Little Cup Sample Teams</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3712664/">Little Cup Viability Rankings</a>`
    ],
    mod: "gen9",
    ruleset: ["Little Cup", "Standard"],
    banlist: [
      "Aipom",
      "Basculin-White-Striped",
      "Cutiefly",
      "Diglett-Base",
      "Dunsparce",
      "Duraludon",
      "Flittle",
      "Girafarig",
      "Gligar",
      "Meditite",
      "Misdreavus",
      "Murkrow",
      "Porygon",
      "Qwilfish-Hisui",
      "Rufflet",
      "Scraggy",
      "Scyther",
      "Sneasel",
      "Sneasel-Hisui",
      "Snivy",
      "Stantler",
      "Vulpix",
      "Vulpix-Alola",
      "Yanma",
      "Moody",
      "Baton Pass",
      "Sticky Web"
    ]
  },
  {
    name: "[Gen 9] Monotype",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3727849/">Monotype Metagame Discussion</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3727976/">Monotype Sample Teams</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3729937/">Monotype Viability Rankings</a>`
    ],
    mod: "gen9",
    ruleset: ["Standard", "Evasion Abilities Clause", "Same Type Clause", "Terastal Clause"],
    banlist: [
      "Annihilape",
      "Arceus",
      "Calyrex-Ice",
      "Calyrex-Shadow",
      "Chi-Yu",
      "Blaziken",
      "Deoxys-Base",
      "Deoxys-Attack",
      "Dialga",
      "Dialga-Origin",
      "Eternatus",
      "Giratina",
      "Giratina-Origin",
      "Groudon",
      "Ho-Oh",
      "Iron Bundle",
      "Koraidon",
      "Kyogre",
      "Kyurem-Black",
      "Kyurem-White",
      "Lugia",
      "Lunala",
      "Magearna",
      "Mewtwo",
      "Miraidon",
      "Necrozma-Dawn-Wings",
      "Necrozma-Dusk-Mane",
      "Palafin",
      "Palkia",
      "Palkia-Origin",
      "Rayquaza",
      "Reshiram",
      "Shaymin-Sky",
      "Solgaleo",
      "Urshifu-Base",
      "Zacian",
      "Zacian-Crowned",
      "Zamazenta-Crowned",
      "Zekrom",
      "Moody",
      "Shadow Tag",
      "Booster Energy",
      "Damp Rock",
      "Focus Band",
      "King's Rock",
      "Quick Claw",
      "Razor Fang",
      "Smooth Rock",
      "Acupressure",
      "Baton Pass",
      "Last Respects",
      "Shed Tail"
    ]
  },
  {
    name: "[Gen 9] CAP",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3712857/">SV CAP Metagame Discussion</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3718107/">SV CAP Sample Teams</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3714023/">SV CAP Viability Rankings</a>`
    ],
    mod: "gen9",
    ruleset: ["[Gen 9] OU", "+CAP"],
    banlist: ["Crucibellite"]
  },
  {
    name: "[Gen 9] BSS Reg F",
    mod: "gen9",
    bestOfDefault: true,
    ruleset: ["Flat Rules", "!! Adjust Level = 50", "Min Source Gen = 9", "VGC Timer"],
    banlist: []
  },
  {
    name: "[Gen 9] Custom Game",
    mod: "gen9",
    searchShow: false,
    debug: true,
    battle: { trunc: Math.trunc },
    // no restrictions, for serious (other than team preview)
    ruleset: ["Team Preview", "Cancel Mod", "Max Team Size = 24", "Max Move Count = 24", "Max Level = 9999", "Default Level = 100"]
  },
  // S/V Doubles
  ///////////////////////////////////////////////////////////////////
  {
    section: "S/V Doubles"
  },
  {
    name: "[Gen 9] Random Doubles Battle",
    mod: "gen9",
    gameType: "doubles",
    team: "random",
    ruleset: ["PotD", "Obtainable", "Species Clause", "HP Percentage Mod", "Cancel Mod", "Illusion Level Mod", "Sleep Clause Mod"]
  },
  {
    name: "[Gen 9] Doubles OU",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3710876/">Doubles OU Sample Teams</a>`
    ],
    mod: "gen9",
    gameType: "doubles",
    ruleset: ["Standard Doubles"],
    banlist: ["DUber", "Shadow Tag"]
  },
  {
    name: "[Gen 9] Doubles Ubers",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3712864/">Doubles Ubers</a>`
    ],
    mod: "gen9",
    gameType: "doubles",
    ruleset: ["Standard Doubles", "!Gravity Sleep Clause"]
  },
  {
    name: "[Gen 9] Doubles UU",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3712825/">Doubles UU</a>`
    ],
    mod: "gen9",
    gameType: "doubles",
    ruleset: ["[Gen 9] Doubles OU", "Evasion Abilities Clause"],
    banlist: ["DOU", "DBL"]
  },
  {
    name: "[Gen 9] Doubles LC",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3710957/">Doubles LC</a>`
    ],
    mod: "gen9",
    gameType: "doubles",
    searchShow: false,
    ruleset: ["Standard Doubles", "Little Cup", "Sleep Clause Mod"],
    banlist: ["Basculin-White-Striped", "Dunsparce", "Gligar", "Murkrow", "Qwilfish-Hisui", "Scyther", "Sneasel", "Sneasel-Hisui", "Vulpix", "Vulpix-Alola", "Yanma"]
  },
  {
    name: "[Gen 9] VGC 2023 Reg D",
    mod: "gen9predlc",
    gameType: "doubles",
    searchShow: false,
    bestOfDefault: true,
    ruleset: ["Flat Rules", "!! Adjust Level = 50", "Min Source Gen = 9", "VGC Timer", "Open Team Sheets"],
    banlist: ["Walking Wake", "Iron Leaves"]
  },
  {
    name: "[Gen 9] VGC 2024 Reg F",
    mod: "gen9",
    gameType: "doubles",
    bestOfDefault: true,
    ruleset: ["Flat Rules", "!! Adjust Level = 50", "Min Source Gen = 9", "VGC Timer", "Open Team Sheets"],
    banlist: []
  },
  {
    name: "[Gen 9] VGC 2024 Reg F (Bo3)",
    mod: "gen9",
    gameType: "doubles",
    challengeShow: false,
    ruleset: ["Flat Rules", "!! Adjust Level = 50", "Min Source Gen = 9", "VGC Timer", "Force Open Team Sheets", "Best of = 3"],
    banlist: []
  },
  {
    name: "[Gen 9] Doubles Custom Game",
    mod: "gen9",
    gameType: "doubles",
    searchShow: false,
    battle: { trunc: Math.trunc },
    debug: true,
    // no restrictions, for serious (other than team preview)
    ruleset: ["Team Preview", "Cancel Mod", "Max Team Size = 24", "Max Move Count = 24", "Max Level = 9999", "Default Level = 100"]
  },
  // S/V Doubles
  ///////////////////////////////////////////////////////////////////
  {
    section: "Unofficial Metagames"
  },
  {
    name: "[Gen 9] 1v1",
    desc: `Bring three Pok&eacute;mon to Team Preview and choose one to battle.`,
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3710864/">1v1 Metagame Discussion</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3712375/">1v1 Viability Rankings</a>`
    ],
    mod: "gen9",
    ruleset: [
      "Picked Team Size = 1",
      "Max Team Size = 3",
      "Standard",
      "Terastal Clause",
      "Sleep Moves Clause",
      "Accuracy Moves Clause",
      "!Sleep Clause Mod"
    ],
    banlist: [
      "Arceus",
      "Calyrex-Ice",
      "Calyrex-Shadow",
      "Chi-Yu",
      "Cinderace",
      "Deoxys",
      "Deoxys-Attack",
      "Deoxys-Defense",
      "Deoxys-Speed",
      "Dialga",
      "Dialga-Origin",
      "Dragonite",
      "Eternatus",
      "Flutter Mane",
      "Gholdengo",
      "Giratina",
      "Giratina-Origin",
      "Groudon",
      "Ho-Oh",
      "Jirachi",
      "Koraidon",
      "Kyogre",
      "Kyurem-Black",
      "Kyurem-White",
      "Lugia",
      "Lunala",
      "Magearna",
      "Meloetta",
      "Mew",
      "Mewtwo",
      "Mimikyu",
      "Miraidon",
      "Necrozma",
      "Necrozma-Dawn-Wings",
      "Necrozma-Dusk-Mane",
      "Ogerpon-Cornerstone",
      "Palkia",
      "Palkia-Origin",
      "Rayquaza",
      "Reshiram",
      "Scream Tail",
      "Shaymin-Sky",
      "Snorlax",
      "Solgaleo",
      "Terapagos",
      "Zacian",
      "Zacian-Crowned",
      "Zamazenta",
      "Zamazenta-Crowned",
      "Zekrom",
      "Moody",
      "Focus Band",
      "Focus Sash",
      "King's Rock",
      "Razor Fang",
      "Quick Claw",
      "Acupressure",
      "Perish Song"
    ]
  },
  {
    name: "[Gen 9] 2v2 Doubles",
    desc: `Double battle where you bring four Pok&eacute;mon to Team Preview and choose only two.`,
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3710849/">2v2 Doubles</a>`
    ],
    mod: "gen9",
    gameType: "doubles",
    ruleset: [
      "Picked Team Size = 2",
      "Max Team Size = 4",
      "Standard Doubles",
      "Accuracy Moves Clause",
      "Terastal Clause",
      "Sleep Clause Mod",
      "Evasion Items Clause"
    ],
    banlist: [
      "Arceus",
      "Calyrex-Ice",
      "Calyrex-Shadow",
      "Chi-Yu",
      "Deoxys-Attack",
      "Dialga",
      "Dialga-Origin",
      "Eternatus",
      "Giratina",
      "Giratina-Origin",
      "Groudon",
      "Ho-Oh",
      "Iron Hands",
      "Koraidon",
      "Kyogre",
      "Kyurem-White",
      "Lugia",
      "Lunala",
      "Magearna",
      "Mewtwo",
      "Miraidon",
      "Necrozma-Dawn-Wings",
      "Necrozma-Dusk-Mane",
      "Palkia",
      "Palkia-Origin",
      "Rayquaza",
      "Reshiram",
      "Solgaleo",
      "Urshifu",
      "Urshifu-Rapid-Strike",
      "Zacian",
      "Zacian-Crowned",
      "Zamazenta",
      "Zamazenta-Crowned",
      "Zekrom",
      "Commander",
      "Moody",
      "Focus Sash",
      "King's Rock",
      "Razor Fang",
      "Ally Switch",
      "Final Gambit",
      "Perish Song",
      "Swagger"
    ]
  },
  {
    name: "[Gen 9] Anything Goes",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3722196/">AG Metagame Discussion</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3724219/">AG Viability Rankings</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3727176/">AG Sample Teams</a>`
    ],
    mod: "gen9",
    ruleset: ["Min Source Gen = 9", "Obtainable", "Team Preview", "HP Percentage Mod", "Cancel Mod", "Endless Battle Clause"]
  },
  {
    name: "[Gen 9] NFE",
    desc: `Only Pok&eacute;mon that can evolve are allowed.`,
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3710638/">NFE</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3712567/">NFE Resources</a>`
    ],
    mod: "gen9",
    ruleset: ["Standard OMs", "Not Fully Evolved", "Sleep Moves Clause", "Terastal Clause", "Min Source Gen = 9"],
    banlist: [
      "Basculin-White-Striped",
      "Bisharp",
      "Chansey",
      "Dipplin",
      "Duraludon",
      "Gurdurr",
      "Haunter",
      "Magmar",
      "Magneton",
      "Porygon2",
      "Primeape",
      "Qwilfish-Hisui",
      "Rhydon",
      "Scyther",
      "Sneasel",
      "Sneasel-Hisui",
      "Ursaring",
      "Vulpix-Base",
      "Arena Trap",
      "Magnet Pull",
      "Shadow Tag",
      "Baton Pass"
    ]
  },
  {
    name: "[Gen 9] Ubers UU",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3731761/">Ubers UU Metagame Discussion</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3731754/">Ubers UU Viability Rankings</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3731755/">Ubers UU Sample Teams</a>`
    ],
    mod: "gen9",
    ruleset: ["[Gen 9] Ubers"],
    banlist: [
      // Ubers OU
      "Arceus-Base",
      "Arceus-Fairy",
      "Arceus-Ground",
      "Basculegion-Base",
      "Calyrex-Ice",
      "Chien-Pao",
      "Clodsire",
      "Deoxys-Attack",
      "Ditto",
      "Eternatus",
      "Flutter Mane",
      "Giratina-Origin",
      "Glimmora",
      "Gliscor",
      "Grimmsnarl",
      "Groudon",
      "Ho-Oh",
      "Iron Bundle",
      "Iron Treads",
      "Koraidon",
      "Kyogre",
      "Kyurem-Black",
      "Lunala",
      "Miraidon",
      "Necrozma-Dusk-Mane",
      "Rayquaza",
      "Ribombee",
      "Skeledirge",
      "Terapagos",
      "Ting-Lu",
      "Zacian-Crowned",
      // Ubers UUBL
      "Arceus-Fire",
      "Arceus-Flying",
      "Arceus-Ghost",
      "Arceus-Steel",
      "Arceus-Water",
      "Necrozma-Dawn-Wings",
      "Shaymin-Sky",
      "Zekrom",
      "Last Respects"
    ]
  },
  {
    name: "[Gen 9] ZU",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3719022/">ZU Metagame Discussion</a>`
    ],
    mod: "gen9",
    ruleset: ["[Gen 9] PU"],
    banlist: ["PU", "ZUBL"]
  },
  {
    name: "[Gen 9] Free-For-All",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3711724/">Free-For-All</a>`
    ],
    mod: "gen9",
    gameType: "freeforall",
    rated: false,
    tournamentShow: false,
    ruleset: ["Standard", "Sleep Moves Clause", "!Sleep Clause Mod", "!Evasion Items Clause"],
    banlist: [
      "Annihilape",
      "Arceus",
      "Calyrex-Ice",
      "Calyrex-Shadow",
      "Chi-Yu",
      "Darkrai",
      "Deoxys-Base",
      "Deoxys-Attack",
      "Dialga",
      "Dialga-Origin",
      "Eternatus",
      "Flutter Mane",
      "Giratina",
      "Giratina-Origin",
      "Groudon",
      "Ho-Oh",
      "Hoopa-Unbound",
      "Iron Bundle",
      "Koraidon",
      "Kyogre",
      "Kyurem-White",
      "Landorus-Base",
      "Lugia",
      "Lunala",
      "Magearna",
      "Mewtwo",
      "Miraidon",
      "Necrozma-Dawn-Wings",
      "Necrozma-Dusk-Mane",
      "Palkia",
      "Palkia-Origin",
      "Rayquaza",
      "Reshiram",
      "Shaymin-Sky",
      "Solgaleo",
      "Spectrier",
      "Terapagos",
      "Ursaluna",
      "Ursaluna-Bloodmoon",
      "Urshifu-Base",
      "Zacian",
      "Zacian-Crowned",
      "Zekrom",
      "Moody",
      "Shadow Tag",
      "Toxic Chain",
      "Toxic Debris",
      "Acupressure",
      "Aromatic Mist",
      "Baton Pass",
      "Coaching",
      "Court Change",
      "Decorate",
      "Dragon Cheer",
      "Final Gambit",
      "Flatter",
      "Floral Healing",
      "Follow Me",
      "Heal Pulse",
      "Last Respects",
      "Malignant Chain",
      "Poison Fang",
      "Rage Powder",
      "Spicy Extract",
      "Swagger",
      "Toxic",
      "Toxic Spikes"
    ]
  },
  {
    name: "[Gen 3] LC",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3722418/">ADV LC</a>`
    ],
    mod: "gen3",
    // searchShow: false,
    ruleset: ["Standard", "Little Cup", "Sleep Moves Clause", "Accuracy Moves Clause"],
    banlist: ["Chansey", "Meditite", "Omanyte", "Scyther", "Wynaut", "Zigzagoon", "Deep Sea Tooth", "Baton Pass", "Dragon Rage", "Sonic Boom", "Swagger"]
  },
  {
    name: "[Gen 9] LC UU",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3711750/">LC UU Metagame Discussion</a>`
    ],
    mod: "gen9",
    searchShow: false,
    ruleset: ["[Gen 9] LC"],
    banlist: [
      "Diglett-Alola",
      "Drifloon",
      "Drilbur",
      "Elekid",
      "Foongus",
      "Gastly",
      "Glimmet",
      "Gothita",
      "Grimer-Alola",
      "Growlithe-Hisui",
      "Impidimp",
      "Koffing",
      "Magby",
      "Magnemite",
      "Mareanie",
      "Meowth-Base",
      "Mienfoo",
      "Minccino",
      "Mudbray",
      "Pawniard",
      "Shellder",
      "Shroodle",
      "Snubbull",
      "Stunky",
      "Tentacool",
      "Timburr",
      "Tinkatink",
      "Toedscool",
      "Trapinch",
      "Voltorb-Hisui",
      "Vullaby",
      "Wattrel"
    ]
  },
  {
    name: "[Gen 9] Monothreat Normal",
    desc: `Monotype where every Pok&eacute;mon is required to be part Normal.`,
    mod: "gen9",
    searchShow: false,
    ruleset: ["[Gen 9] Monotype", "Force Monotype = Normal"]
  },
  {
    name: "[Gen 9] Monotype CAP",
    desc: `Monotype where CAP Pok&eacute;mon are legal.`,
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/posts/9476494">Monotype CAP</a>`
    ],
    mod: "gen9",
    searchShow: false,
    ruleset: ["[Gen 9] Monotype", "+CAP"],
    banlist: ["Cawmodore", "Fidgit", "Hemogoblin", "Heat Rock"]
  },
  {
    name: "[Gen 9] Monotype LC",
    desc: `Monotype where every Pok&eacute;mon must be in the first stage in their evolution line.`,
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/posts/9476493">Monotype LC</a>`
    ],
    mod: "gen9",
    searchShow: false,
    ruleset: ["[Gen 9] LC", "Same Type Clause", "Terastal Clause"],
    banlist: ["Minccino", "Damp Rock", "Focus Band", "Heat Rock", "Icy Rock", "Quick Claw"],
    unbanlist: ["Diglett-Base", "Growlithe-Hisui", "Porygon", "Scraggy", "Vulpix", "Vulpix-Alola", "Sticky Web"]
  },
  // Pet Mods
  ///////////////////////////////////////////////////////////////////
  {
    section: "Pet Mods"
  },
  {
    name: "[Gen 9] VaporeMons",
    desc: `A Gen 9 mod where Pok&eacute;mon, moves, items, abilities, and non-stat Pok&eacute;mon adjustments are added to the game.`,
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/vaporemons-slate-1-discussion-phase.3722917/">VaporeMons</a>`,
      `&bullet; <a href="https://docs.google.com/spreadsheets/d/1_5AwZ24dPu3-5m5yOyIO4OTPmW9OwIWXXzZ5IJZkj4c/edit?usp=sharing">Spreadsheet</a>`
    ],
    mod: "vaporemons",
    ruleset: ["Standard", "Terastal Clause", "VaporeMons Mod", "Sleep Moves Clause", "!Sleep Clause Mod"],
    banlist: ["Uber", "AG", "Arena Trap", "Moody", "Shadow Tag", "King's Rock", "Baton Pass", "Last Respects", "Shed Tail", "Light Clay", "Fling + Segin Star Shard"],
    onSwitchIn(pokemon) {
      this.add("-start", pokemon, "typechange", (pokemon.illusion || pokemon).getTypes(true).join("/"), "[silent]");
    }
  },
  {
    name: "[Gen 1] Modern Gen 1",
    desc: `A Gen 1 solomod where all Pok&eacute;mon and moves from future generations are legal.`,
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/gen-9-modern-gen-1.3711533/">Modern Gen 1</a>`
    ],
    mod: "moderngen1",
    ruleset: ["Standard", "Partial Trapping Clause", "Protect Clause", "Field Effect Clause", "Sleep Moves Clause", "Useless Moves Clause", "MG1 Mod"],
    banlist: ["Uber", "Fake Out", "Confuse Ray", "Supersonic", "Swagger", "Sweet Kiss", "Flatter"]
  },
  {
    name: "[Gen 6] NEXT OU",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3476151/">Gen-NEXT Development Thread</a>`
    ],
    mod: "gennext",
    searchShow: false,
    challengeShow: false,
    ruleset: ["Obtainable", "Standard NEXT", "Team Preview"],
    banlist: ["Uber"]
  },
  // Draft League
  ///////////////////////////////////////////////////////////////////
  {
    section: "Draft",
    column: 1
  },
  {
    name: "[Gen 9] Draft",
    mod: "gen9",
    searchShow: false,
    ruleset: ["Standard Draft", "Min Source Gen = 9"]
  },
  {
    name: "[Gen 9] Tera Preview Draft",
    mod: "gen9",
    searchShow: false,
    ruleset: ["[Gen 9] Draft", "Tera Type Preview"]
  },
  {
    name: "[Gen 9] 6v6 Doubles Draft",
    mod: "gen9",
    gameType: "doubles",
    searchShow: false,
    ruleset: ["Standard Draft", "!Sleep Clause Mod", "!Evasion Clause", "Min Source Gen = 9"]
  },
  {
    name: "[Gen 9] 4v4 Doubles Draft",
    mod: "gen9",
    gameType: "doubles",
    searchShow: false,
    bestOfDefault: true,
    ruleset: ["Standard Draft", "Item Clause", "VGC Timer", "!Sleep Clause Mod", "!OHKO Clause", "!Evasion Clause", "Adjust Level = 50", "Picked Team Size = 4", "Min Source Gen = 9"]
  },
  {
    name: "[Gen 9] NatDex Draft",
    mod: "gen9",
    searchShow: false,
    ruleset: ["Standard Draft", "+Unobtainable", "+Past"]
  },
  {
    name: "[Gen 9] Tera Preview NatDex Draft",
    mod: "gen9",
    searchShow: false,
    ruleset: ["[Gen 9] NatDex Draft", "Tera Type Preview"]
  },
  {
    name: "[Gen 9] NatDex 6v6 Doubles Draft",
    mod: "gen9",
    gameType: "doubles",
    searchShow: false,
    ruleset: ["[Gen 9] 6v6 Doubles Draft", "+Unobtainable", "+Past", "!! Min Source Gen = 3"]
  },
  {
    name: "[Gen 9] NatDex LC Draft",
    mod: "gen9",
    searchShow: false,
    ruleset: ["[Gen 9] NatDex Draft", "Double Item Clause", "Little Cup"],
    banlist: ["Dragon Rage", "Sonic Boom"]
  },
  {
    name: "[Gen 8] Galar Dex Draft",
    mod: "gen8",
    searchShow: false,
    ruleset: ["Standard Draft", "Dynamax Clause"]
  },
  {
    name: "[Gen 8] NatDex Draft",
    mod: "gen8",
    searchShow: false,
    ruleset: ["Standard Draft", "Dynamax Clause", "+Past"]
  },
  {
    name: "[Gen 8] NatDex 4v4 Doubles Draft",
    mod: "gen8",
    gameType: "doubles",
    searchShow: false,
    ruleset: ["Standard Draft", "Item Clause", "!Sleep Clause Mod", "!OHKO Clause", "!Evasion Moves Clause", "Adjust Level = 50", "Picked Team Size = 4", "+Past"]
  },
  {
    name: "[Gen 7] Draft",
    mod: "gen7",
    searchShow: false,
    ruleset: ["Standard Draft", "+LGPE"]
  },
  {
    name: "[Gen 6] Draft",
    mod: "gen6",
    searchShow: false,
    ruleset: ["Standard Draft", "Moody Clause", "Swagger Clause"],
    banlist: ["Soul Dew"]
  },
  // OM of the Month
  ///////////////////////////////////////////////////////////////////
  {
    section: "OM of the Month",
    column: 2
  },
  {
    name: "[Gen 9] Frantic Fusions",
    desc: `Pok&eacute;mon nicknamed after another Pok&eacute;mon get their stats buffed by 1/4 of that Pok&eacute;mon's stats, barring HP, and access to one of their abilities.`,
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3725593/">Frantic Fusions</a>`
    ],
    mod: "gen9",
    // searchShow: false,
    ruleset: ["Standard OMs", "!Nickname Clause", "!Obtainable Abilities", "Sleep Moves Clause", "Frantic Fusions Mod", "Terastal Clause", "Min Source Gen = 9"],
    banlist: [
      "Annihilape",
      "Arceus",
      "Baxcalibur",
      "Calyrex-Ice",
      "Calyrex-Shadow",
      "Chi-Yu",
      "Chien-Pao",
      "Comfey",
      "Cresselia",
      "Darkrai",
      "Deoxys-Base",
      "Deoxys-Attack",
      "Deoxys-Speed",
      "Dialga",
      "Dialga-Origin",
      "Ditto",
      "Dragapult",
      "Enamorus-Base",
      "Eternatus",
      "Flutter Mane",
      "Giratina",
      "Giratina-Origin",
      "Groudon",
      "Ho-Oh",
      "Hoopa-Unbound",
      "Iron Boulder",
      "Iron Bundle",
      "Iron Moth",
      "Iron Valiant",
      "Keldeo",
      "Koraidon",
      "Komala",
      "Kyogre",
      "Kyurem",
      "Kyurem-Black",
      "Kyurem-White",
      "Landorus-Base",
      "Lugia",
      "Lunala",
      "Magearna",
      "Mewtwo",
      "Miraidon",
      "Necrozma-Dawn-Wings",
      "Necrozma-Dusk-Mane",
      "Numel",
      "Ogerpon-Hearthflame",
      "Palafin",
      "Palkia",
      "Palkia-Origin",
      "Persian-Alola",
      "Rayquaza",
      "Regieleki",
      "Regigigas",
      "Reshiram",
      "Shaymin-Sky",
      "Slaking",
      "Solgaleo",
      "Spectrier",
      "Toxapex",
      "Urshifu",
      "Urshifu-Rapid-Strike",
      "Volcarona",
      "Walking Wake",
      "Weavile",
      "Zacian",
      "Zacian-Crowned",
      "Zamazenta",
      "Zamazenta-Crowned",
      "Zekrom",
      "Arena Trap",
      "Contrary",
      "Huge Power",
      "Ice Scales",
      "Illusion",
      "Magnet Pull",
      "Moody",
      "Neutralizing Gas",
      "Poison Heal",
      "Pure Power",
      "Shadow Tag",
      "Stakeout",
      "Stench",
      "Speed Boost",
      "Unburden",
      "Water Bubble",
      "Damp Rock",
      "Heat Rock",
      "King's Rock",
      "Quick Claw",
      "Razor Fang",
      "Baton Pass",
      "Last Respects",
      "Revival Blessing",
      "Shed Tail"
    ]
  },
  {
    name: "[Gen 9] Re-Evolution",
    desc: `Pok&eacute;mon gain the stat changes they receive from evolving again.`,
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3710983/">Re-Evolution</a>`
    ],
    mod: "gen9",
    ruleset: ["Standard OMs", "Sleep Moves Clause", "Re-Evolution Mod", "Terastal Clause", "Min Source Gen = 9"],
    banlist: [
      "Basculegion-Base",
      "Baxcalibur",
      "Gholdengo",
      "Gyarados",
      "Houndstone",
      "Lunala",
      "Milotic",
      "Solgaleo",
      "Urshifu-Base",
      "Arena Trap",
      "Light Clay",
      "Moody",
      "Shadow Tag",
      "King's Rock",
      "Razor Fang",
      "Baton Pass"
    ]
  },
  {
    name: "[Gen 9] Godly Gift",
    desc: `Each Pok&eacute;mon receives one base stat from a God (Restricted Pok&eacute;mon) depending on its position in the team. If there is no restricted Pok&eacute;mon, it uses the Pok&eacute;mon in the first slot.`,
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3710734/">Godly Gift</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3718065/">Godly Gift Resources</a>`
    ],
    mod: "gen9",
    ruleset: ["Standard OMs", "Sleep Moves Clause", "Godly Gift Mod", "Min Source Gen = 9"],
    banlist: [
      "Blissey",
      "Calyrex-Shadow",
      "Chansey",
      "Deoxys-Attack",
      "Koraidon",
      "Miraidon",
      "Arena Trap",
      "Moody",
      "Shadow Tag",
      "Swift Swim",
      "Bright Powder",
      "Focus Band",
      "King's Rock",
      "Quick Claw",
      "Razor Fang",
      "Baton Pass",
      "Last Respects",
      "Shed Tail"
    ],
    restricted: [
      "Annihilape",
      "Arceus",
      "Azumarill",
      "Calyrex-Ice",
      "Chi-Yu",
      "Crawdaunt",
      "Deoxys-Base",
      "Deoxys-Speed",
      "Dialga",
      "Dialga-Origin",
      "Eternatus",
      "Giratina",
      "Giratina-Origin",
      "Gliscor",
      "Groudon",
      "Ho-Oh",
      "Iron Bundle",
      "Kingambit",
      "Kyogre",
      "Kyurem",
      "Kyurem-Black",
      "Kyurem-White",
      "Lugia",
      "Lunala",
      "Magearna",
      "Medicham",
      "Mewtwo",
      "Necrozma-Dawn-Wings",
      "Necrozma-Dusk-Mane",
      "Ogerpon-Hearthflame",
      "Palafin",
      "Palkia",
      "Palkia-Origin",
      "Rayquaza",
      "Regieleki",
      "Reshiram",
      "Shaymin-Sky",
      "Smeargle",
      "Solgaleo",
      "Terapagos",
      "Toxapex",
      "Ursaluna",
      "Ursaluna-Bloodmoon",
      "Zacian",
      "Zacian-Crowned",
      "Zamazenta-Crowned",
      "Zekrom"
    ]
  },
  // Other Metagames
  ///////////////////////////////////////////////////////////////////
  {
    section: "Other Metagames",
    column: 2
  },
  {
    name: "[Gen 9] Almost Any Ability",
    desc: `Pok&eacute;mon have access to almost any ability.`,
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3710568/">Almost Any Ability</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3710571/">AAA Resources</a>`
    ],
    mod: "gen9",
    ruleset: ["Standard OMs", "!Obtainable Abilities", "Ability Clause = 1", "Sleep Moves Clause", "Terastal Clause", "Min Source Gen = 9"],
    banlist: [
      "Annihilape",
      "Arceus",
      "Baxcalibur",
      "Calyrex-Ice",
      "Calyrex-Shadow",
      "Darkrai",
      "Deoxys-Base",
      "Deoxys-Attack",
      "Dialga",
      "Dialga-Origin",
      "Dragapult",
      "Enamorus-Base",
      "Eternatus",
      "Flutter Mane",
      "Giratina",
      "Giratina-Origin",
      "Gouging Fire",
      "Groudon",
      "Ho-Oh",
      "Hoopa-Unbound",
      "Iron Bundle",
      "Iron Valiant",
      "Keldeo",
      "Koraidon",
      "Kyogre",
      "Kyurem",
      "Kyurem-Black",
      "Kyurem-White",
      "Lugia",
      "Lunala",
      "Magearna",
      "Mewtwo",
      "Miraidon",
      "Necrozma-Dawn-Wings",
      "Necrozma-Dusk-Mane",
      "Noivern",
      "Palkia",
      "Palkia-Origin",
      "Raging Bolt",
      "Rayquaza",
      "Regigigas",
      "Reshiram",
      "Shaymin-Sky",
      "Slaking",
      "Sneasler",
      "Solgaleo",
      "Spectrier",
      "Urshifu",
      "Urshifu-Rapid-Strike",
      "Weavile",
      "Zacian",
      "Zacian-Crowned",
      "Zekrom",
      "Arena Trap",
      "Comatose",
      "Contrary",
      "Fur Coat",
      "Good as Gold",
      "Gorilla Tactics",
      "Huge Power",
      "Ice Scales",
      "Illusion",
      "Imposter",
      "Innards Out",
      "Magic Bounce",
      "Magnet Pull",
      "Moody",
      "Neutralizing Gas",
      "Orichalcum Pulse",
      "Parental Bond",
      "Poison Heal",
      "Pure Power",
      "Shadow Tag",
      "Simple",
      "Speed Boost",
      "Stakeout",
      "Toxic Debris",
      "Triage",
      "Unburden",
      "Water Bubble",
      "Wonder Guard",
      "King's Rock",
      "Razor Fang",
      "Baton Pass",
      "Last Respects",
      "Revival Blessing",
      "Shed Tail"
    ]
  },
  {
    name: "[Gen 9] Balanced Hackmons",
    desc: `Anything directly hackable onto a set (EVs, IVs, forme, ability, item, and move) and is usable in local battles is allowed.`,
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3710859/">Balanced Hackmons</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3712766/">BH Resources</a>`
    ],
    mod: "gen9",
    ruleset: [
      "OHKO Clause",
      "Evasion Clause",
      "Species Clause",
      "Team Preview",
      "HP Percentage Mod",
      "Cancel Mod",
      "Sleep Moves Clause",
      "Endless Battle Clause",
      "Hackmons Forme Legality",
      "Species Reveal Clause",
      "Terastal Clause"
    ],
    banlist: [
      "Calyrex-Shadow",
      "Deoxys-Attack",
      "Diancie-Mega",
      "Gengar-Mega",
      "Groudon-Primal",
      "Kartana",
      "Mewtwo-Mega-X",
      "Mewtwo-Mega-Y",
      "Rayquaza-Mega",
      "Regigigas",
      "Shedinja",
      "Slaking",
      "Arena Trap",
      "Comatose",
      "Contrary",
      "Gorilla Tactics",
      "Hadron Engine",
      "Huge Power",
      "Illusion",
      "Innards Out",
      "Libero",
      "Liquid Ooze",
      "Magnet Pull",
      "Moody",
      "Neutralizing Gas",
      "Orichalcum Pulse",
      "Parental Bond",
      "Poison Heal",
      "Protean",
      "Pure Power",
      "Shadow Tag",
      "Stakeout",
      "Water Bubble",
      "Wonder Guard",
      "Baton Pass",
      "Belly Drum",
      "Ceaseless Edge",
      "Dire Claw",
      "Electro Shot",
      "Fillet Away",
      "Imprison",
      "Last Respects",
      "Lumina Crash",
      "Photon Geyser",
      "Quiver Dance",
      "Rage Fist",
      "Revival Blessing",
      "Shed Tail",
      "Substitute",
      "Shell Smash",
      "Tail Glow"
    ]
  },
  {
    name: "[Gen 9] Inheritance",
    desc: `Pok&eacute;mon may use the ability and moves of another, as long as they forfeit their own learnset.`,
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3712296/">Inheritance</a>`
    ],
    mod: "gen9",
    ruleset: ["Standard OMs", "Ability Clause = 1", "Sleep Moves Clause", "Terastal Clause", "Min Source Gen = 9"],
    banlist: [
      "Arceus",
      "Calyrex-Ice",
      "Calyrex-Shadow",
      "Chien-Pao",
      "Cresselia",
      "Deoxys-Base",
      "Deoxys-Attack",
      "Dialga",
      "Dialga-Origin",
      "Dondozo",
      "Dragapult",
      "Enamorus-Base",
      "Eternatus",
      "Flutter Mane",
      "Giratina",
      "Giratina-Origin",
      "Groudon",
      "Hoopa-Unbound",
      "Ho-Oh",
      "Iron Bundle",
      "Iron Valiant",
      "Koraidon",
      "Kyogre",
      "Kyurem-Black",
      "Kyurem-White",
      "Lugia",
      "Lunala",
      "Magearna",
      "Mewtwo",
      "Miraidon",
      "Necrozma-Dawn-Wings",
      "Necrozma-Dusk-Mane",
      "Palkia",
      "Palkia-Origin",
      "Pecharunt",
      "Rayquaza",
      "Regieleki",
      "Regigigas",
      "Reshiram",
      "Sableye",
      "Samurott-Hisui",
      "Scream Tail",
      "Shaymin-Sky",
      "Slaking",
      "Smeargle",
      "Solgaleo",
      "Spectrier",
      "Torkoal",
      "Urshifu-Base",
      "Weavile",
      "Zacian",
      "Zacian-Crowned",
      "Zamazenta",
      "Zamazenta-Crowned",
      "Zekrom",
      "Arena Trap",
      "Drizzle",
      "Huge Power",
      "Imposter",
      "Magnet Pull",
      "Moody",
      "Poison Heal",
      "Pure Power",
      "Shadow Tag",
      "Speed Boost",
      "Stakeout",
      "Water Bubble",
      "King's Rock",
      "Razor Fang",
      "Baton Pass",
      "Fillet Away",
      "Last Respects",
      "Rage Fist",
      "Shed Tail",
      "Shell Smash"
    ],
    getEvoFamily(speciesid) {
      let species = Dex.species.get(speciesid);
      while (species.prevo) {
        const prevoSpecies = Dex.species.get(species.prevo);
        if (prevoSpecies.evos.length > 1)
          break;
        species = prevoSpecies;
      }
      return species.id;
    },
    validateSet(set, teamHas) {
      if (!teamHas.abilityMap) {
        teamHas.abilityMap = /* @__PURE__ */ Object.create(null);
        for (const pokemon of Dex.species.all()) {
          if (pokemon.isNonstandard && !this.ruleTable.has(`+pokemontag:${this.toID(pokemon.isNonstandard)}`))
            continue;
          if (pokemon.battleOnly)
            continue;
          if (this.ruleTable.isBannedSpecies(pokemon))
            continue;
          for (const key of Object.values(pokemon.abilities)) {
            const abilityId = this.dex.toID(key);
            if (abilityId in teamHas.abilityMap) {
              teamHas.abilityMap[abilityId][pokemon.evos ? "push" : "unshift"](pokemon.id);
            } else {
              teamHas.abilityMap[abilityId] = [pokemon.id];
            }
          }
        }
      }
      const problem = this.validateForme(set);
      if (problem.length)
        return problem;
      const species = this.dex.species.get(set.species);
      if (!species.exists || species.num < 1)
        return [`The Pok\xE9mon "${set.species}" does not exist.`];
      if (species.isNonstandard && !this.ruleTable.has(`+pokemontag:${this.toID(species.isNonstandard)}`)) {
        return [`${species.name} is not obtainable in Generation ${this.dex.gen}.`];
      }
      const name = set.name;
      if (this.ruleTable.isBannedSpecies(species)) {
        return this.validateSet(set, teamHas);
      }
      const ability = this.dex.abilities.get(set.ability);
      if (!ability.exists || ability.isNonstandard)
        return [`${name} needs to have a valid ability.`];
      const pokemonWithAbility = teamHas.abilityMap[ability.id];
      if (!pokemonWithAbility)
        return [`${ability.name} is not available on a legal Pok\xE9mon.`];
      this.format.debug = true;
      if (!teamHas.abilitySources)
        teamHas.abilitySources = /* @__PURE__ */ Object.create(null);
      const validSources = teamHas.abilitySources[this.toID(set.species)] = [];
      let canonicalSource = "";
      const hpType = set.hpType;
      for (const donor of pokemonWithAbility) {
        const donorSpecies = this.dex.species.get(donor);
        let format = this.format;
        if (!format.getEvoFamily)
          format = this.dex.formats.get("gen9inheritance");
        const evoFamily = format.getEvoFamily(donorSpecies.id);
        if (validSources.includes(evoFamily))
          continue;
        set.species = donorSpecies.name;
        set.name = donorSpecies.baseSpecies;
        const annoyingPokemon = ["Iron Leaves", "Walking Wake", "Iron Boulder", "Gouging Fire", "Iron Crown", "Raging Bolt"];
        if (annoyingPokemon.includes(donorSpecies.name) || annoyingPokemon.includes(species.name)) {
          set.hpType = "Dark";
        }
        const problems = this.validateSet(set, teamHas);
        if (!problems?.length) {
          validSources.push(evoFamily);
          canonicalSource = donorSpecies.name;
        }
        if (validSources.length > 1)
          break;
      }
      this.format.debug = false;
      set.name = name;
      set.species = species.name;
      set.hpType = hpType;
      if (!validSources.length) {
        if (pokemonWithAbility.length > 1)
          return [`${name}'s set is illegal.`];
        return [`${name} has an illegal set with an ability from ${this.dex.species.get(pokemonWithAbility[0]).name}.`];
      }
      set.pokeball = `${set.pokeball}0${canonicalSource}`;
      return null;
    },
    onValidateTeam(team, f, teamHas) {
      if (this.ruleTable.has("abilityclause")) {
        const abilityTable = /* @__PURE__ */ new Map();
        const base = {
          airlock: "cloudnine",
          armortail: "queenlymajesty",
          battlearmor: "shellarmor",
          clearbody: "whitesmoke",
          dazzling: "queenlymajesty",
          emergencyexit: "wimpout",
          filter: "solidrock",
          gooey: "tanglinghair",
          insomnia: "vitalspirit",
          ironbarbs: "roughskin",
          keeneye: "illuminate",
          libero: "protean",
          minus: "plus",
          moxie: "chillingneigh",
          powerofalchemy: "receiver",
          propellertail: "stalwart",
          teravolt: "moldbreaker",
          turboblaze: "moldbreaker"
        };
        const num = parseInt(this.ruleTable.valueRules.get("abilityclause"));
        for (const set of team) {
          let ability = this.toID(set.ability.split("0")[0]);
          if (!ability)
            continue;
          if (ability in base)
            ability = base[ability];
          if ((abilityTable.get(ability) || 0) >= num) {
            return [
              `You are limited to ${num} of each ability by ${num} Ability Clause.`,
              `(You have more than ${num} ${this.dex.abilities.get(ability).name} variants)`
            ];
          }
          abilityTable.set(ability, (abilityTable.get(ability) || 0) + 1);
        }
      }
      const evoFamilyLists = [];
      for (const set of team) {
        const abilitySources = teamHas.abilitySources?.[this.toID(set.species)];
        if (!abilitySources)
          continue;
        let format = this.format;
        if (!format.getEvoFamily)
          format = this.dex.formats.get("gen9inheritance");
        evoFamilyLists.push(abilitySources.map(format.getEvoFamily));
      }
      const requiredFamilies = /* @__PURE__ */ Object.create(null);
      for (const evoFamilies of evoFamilyLists) {
        if (evoFamilies.length !== 1)
          continue;
        const [familyId] = evoFamilies;
        if (!(familyId in requiredFamilies)) {
          requiredFamilies[familyId] = 1;
        } else {
          requiredFamilies[familyId]++;
        }
        if (requiredFamilies[familyId] > 1) {
          return [
            `You are limited to up to one inheritance from each evolution family by the Donor Clause.`,
            `(You inherit more than once from ${this.dex.species.get(familyId).name}).`
          ];
        }
      }
    },
    onBegin() {
      for (const pokemon of this.getAllPokemon()) {
        if (pokemon.pokeball.includes("0")) {
          const donor = pokemon.pokeball.split("0")[1];
          pokemon.m.donor = this.toID(donor);
          pokemon.pokeball = this.toID(pokemon.pokeball.split("0")[0]);
        }
      }
    },
    onSwitchIn(pokemon) {
      if (!pokemon.m.donor)
        return;
      const donorTemplate = this.dex.species.get(pokemon.m.donor);
      if (!donorTemplate.exists)
        return;
      this.add("-start", pokemon, donorTemplate.name, "[silent]");
    }
  },
  {
    name: "[Gen 9] Mix and Mega",
    desc: `Mega evolve any Pok&eacute;mon with any mega stone, or transform them with Primal orbs, Origin orbs, and Rusted items with no limit. Mega and Primal boosts based on form changes from gen 7.`,
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3710921/">Mix and Mega</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3716385/">Mix and Mega Resources</a>`
    ],
    mod: "mixandmega",
    ruleset: ["Standard OMs", "Evasion Items Clause", "Evasion Abilities Clause", "Sleep Moves Clause", "Terastal Clause", "Min Source Gen = 9"],
    banlist: [
      "Calyrex-Shadow",
      "Koraidon",
      "Kyogre",
      "Miraidon",
      "Moody",
      "Rusted Sword",
      "Shadow Tag",
      "Beedrillite",
      "Blazikenite",
      "Gengarite",
      "Kangaskhanite",
      "Mawilite",
      "Medichamite",
      "Pidgeotite",
      "Baton Pass",
      "Shed Tail"
    ],
    restricted: [
      "Arceus",
      "Basculegion-Base",
      "Calyrex-Ice",
      "Deoxys-Base",
      "Deoxys-Attack",
      "Dialga",
      "Dragapult",
      "Enamorus-Base",
      "Eternatus",
      "Flutter Mane",
      "Gengar",
      "Gholdengo",
      "Giratina",
      "Groudon",
      "Ho-Oh",
      "Iron Bundle",
      "Jolteon",
      "Kilowattrel",
      "Kyurem-Black",
      "Kyurem-White",
      "Lunala",
      "Manaphy",
      "Mewtwo",
      "Necrozma-Dawn-Wings",
      "Necrozma-Dusk-Mane",
      "Palkia",
      "Rayquaza",
      "Regigigas",
      "Reshiram",
      "Slaking",
      "Sneasler",
      "Ursaluna-Bloodmoon",
      "Urshifu-Base",
      "Zacian",
      "Zekrom"
    ],
    onValidateTeam(team) {
      const itemTable = /* @__PURE__ */ new Set();
      for (const set of team) {
        const item = this.dex.items.get(set.item);
        if (!item.megaStone && !item.onPrimal && !item.forcedForme?.endsWith("Origin") && !item.name.startsWith("Rusted") && !item.name.endsWith("Mask"))
          continue;
        const natdex = this.ruleTable.has("standardnatdex");
        if (natdex && item.id !== "ultranecroziumz")
          continue;
        const species = this.dex.species.get(set.species);
        if (species.isNonstandard && !this.ruleTable.has(`+pokemontag:${this.toID(species.isNonstandard)}`)) {
          return [`${species.baseSpecies} does not exist in gen 9.`];
        }
        if (item.itemUser?.includes(species.name) && !item.megaStone && !item.onPrimal || natdex && species.name.startsWith("Necrozma-") && item.id === "ultranecroziumz") {
          continue;
        }
        if (this.ruleTable.isRestrictedSpecies(species) || this.toID(set.ability) === "powerconstruct") {
          return [`${species.name} is not allowed to hold ${item.name}.`];
        }
        if (itemTable.has(item.id)) {
          return [
            `You are limited to one of each mega stone/orb/rusted item/sinnoh item/mask.`,
            `(You have more than one ${item.name})`
          ];
        }
        itemTable.add(item.id);
      }
    },
    onBegin() {
      for (const pokemon of this.getAllPokemon()) {
        pokemon.m.originalSpecies = pokemon.baseSpecies.name;
      }
    },
    onSwitchIn(pokemon) {
      const originalFormeSecies = this.dex.species.get(pokemon.species.originalSpecies);
      if (originalFormeSecies.exists && pokemon.m.originalSpecies !== originalFormeSecies.baseSpecies) {
        this.add("-start", pokemon, originalFormeSecies.requiredItem || originalFormeSecies.requiredMove, "[silent]");
        const oSpecies = this.dex.species.get(pokemon.m.originalSpecies);
        if (oSpecies.types.length !== pokemon.species.types.length || oSpecies.types[1] !== pokemon.species.types[1]) {
          this.add("-start", pokemon, "typechange", pokemon.species.types.join("/"), "[silent]");
        }
      }
    },
    onSwitchOut(pokemon) {
      const oMegaSpecies = this.dex.species.get(pokemon.species.originalSpecies);
      if (oMegaSpecies.exists && pokemon.m.originalSpecies !== oMegaSpecies.baseSpecies) {
        this.add("-end", pokemon, oMegaSpecies.requiredItem || oMegaSpecies.requiredMove, "[silent]");
      }
    }
  },
  {
    name: "[Gen 9] Partners in Crime",
    desc: `Doubles-based metagame where both active ally Pok&eacute;mon share abilities and moves.`,
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3710997/">Partners in Crime</a>`
    ],
    mod: "partnersincrime",
    gameType: "doubles",
    ruleset: ["Standard Doubles"],
    banlist: [
      "Annihilape",
      "Arceus",
      "Calyrex-Ice",
      "Calyrex-Shadow",
      "Chi-Yu",
      "Cresselia",
      "Darkrai",
      "Dialga",
      "Dialga-Origin",
      "Eternatus",
      "Flutter Mane",
      "Giratina",
      "Giratina-Origin",
      "Groudon",
      "Ho-Oh",
      "Koraidon",
      "Kyogre",
      "Kyurem-Black",
      "Kyurem-White",
      "Lugia",
      "Lunala",
      "Magearna",
      "Mewtwo",
      "Miraidon",
      "Necrozma-Dawn-Wings",
      "Necrozma-Dusk-Mane",
      "Palkia",
      "Palkia-Origin",
      "Rayquaza",
      "Reshiram",
      "Smeargle",
      "Solgaleo",
      "Terapagos",
      "Urshifu",
      "Urshifu-Rapid-Strike",
      "Zacian",
      "Zacian-Crowned",
      "Zamazenta",
      "Zamazenta-Crowned",
      "Zekrom",
      "Contrary",
      "Dancer",
      "Huge Power",
      "Moody",
      "Pure Power",
      "Serene Grace",
      "Shadow Tag",
      "Bright Powder",
      "King's Rock",
      "Razor Fang",
      "Ally Switch",
      "Last Respects",
      "Revival Blessing",
      "Swagger"
    ],
    onBegin() {
      for (const pokemon of this.getAllPokemon()) {
        pokemon.m.trackPP = /* @__PURE__ */ new Map();
      }
    },
    onBeforeSwitchIn(pokemon) {
      pokemon.m.curMoves = this.dex.deepClone(pokemon.moves);
      let ngas = false;
      for (const poke of this.getAllActive()) {
        if (this.toID(poke.ability) === "neutralizinggas") {
          ngas = true;
          break;
        }
      }
      const BAD_ABILITIES = ["trace", "imposter", "neutralizinggas", "illusion", "wanderingspirit"];
      const ally = pokemon.side.active.find((mon) => mon && mon !== pokemon && !mon.fainted);
      if (ally && ally.ability !== pokemon.ability) {
        if (!pokemon.m.innate && !BAD_ABILITIES.includes(this.toID(ally.ability))) {
          pokemon.m.innate = "ability:" + ally.ability;
          if (!ngas || ally.getAbility().flags["cantsuppress"] || pokemon.hasItem("Ability Shield")) {
            pokemon.volatiles[pokemon.m.innate] = { id: pokemon.m.innate, target: pokemon };
            pokemon.m.startVolatile = true;
          }
        }
        if (!ally.m.innate && !BAD_ABILITIES.includes(this.toID(pokemon.ability))) {
          ally.m.innate = "ability:" + pokemon.ability;
          if (!ngas || pokemon.getAbility().flags["cantsuppress"] || ally.hasItem("Ability Shield")) {
            ally.volatiles[ally.m.innate] = { id: ally.m.innate, target: ally };
            ally.m.startVolatile = true;
          }
        }
      }
    },
    // Starting innate abilities in scripts#actions
    onSwitchOut(pokemon) {
      if (pokemon.m.innate) {
        pokemon.removeVolatile(pokemon.m.innate);
        delete pokemon.m.innate;
      }
      const ally = pokemon.side.active.find((mon) => mon && mon !== pokemon && !mon.fainted);
      if (ally && ally.m.innate) {
        ally.removeVolatile(ally.m.innate);
        delete ally.m.innate;
      }
    },
    onFaint(pokemon) {
      if (pokemon.m.innate) {
        pokemon.removeVolatile(pokemon.m.innate);
        delete pokemon.m.innate;
      }
      const ally = pokemon.side.active.find((mon) => mon && mon !== pokemon && !mon.fainted);
      if (ally && ally.m.innate) {
        ally.removeVolatile(ally.m.innate);
        delete ally.m.innate;
      }
    }
  },
  {
    name: "[Gen 9] Shared Power",
    desc: `Once a Pok&eacute;mon switches in, its ability is shared with the rest of the team.`,
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3711011/">Shared Power</a>`
    ],
    mod: "sharedpower",
    ruleset: ["Standard OMs", "Evasion Abilities Clause", "Evasion Items Clause", "Sleep Moves Clause", "Min Source Gen = 9"],
    banlist: [
      "Arceus",
      "Calyrex-Shadow",
      "Chi-Yu",
      "Chien-Pao",
      "Clefable",
      "Deoxys-Base",
      "Deoxys-Attack",
      "Dondozo",
      "Eternatus",
      "Flutter Mane",
      "Greninja",
      "Iron Crown",
      "Kingambit",
      "Kyurem-Black",
      "Kyurem-White",
      "Koraidon",
      "Landorus-Base",
      "Lunala",
      "Magearna",
      "Mewtwo",
      "Miraidon",
      "Necrozma-Dawn-Wings",
      "Necrozma-Dusk-Mane",
      "Ogerpon-Hearthflame",
      "Rayquaza",
      "Regieleki",
      "Reshiram",
      "Shaymin-Sky",
      "Spectrier",
      "Terapagos",
      "Zacian",
      "Zacian-Crowned",
      "Zamazenta-Crowned",
      "Zekrom",
      "Arena Trap",
      "Chlorophyll",
      "Magnet Pull",
      "Moody",
      "Neutralizing Gas",
      "Regenerator",
      "Shadow Tag",
      "Speed Boost",
      "Stench",
      "Swift Swim",
      "Unburden",
      "King's Rock",
      "Leppa Berry",
      "Razor Fang",
      "Starf Berry",
      "Baton Pass",
      "Extreme Speed",
      "Last Respects"
    ],
    unbanlist: ["Arceus-Bug", "Arceus-Dragon", "Arceus-Fire", "Arceus-Ice"],
    restricted: [
      "Armor Tail",
      "Comatose",
      "Contrary",
      "Dazzling",
      "Fur Coat",
      "Gale Wings",
      "Good as Gold",
      "Huge Power",
      "Ice Scales",
      "Illusion",
      "Imposter",
      "Magic Bounce",
      "Magic Guard",
      "Mold Breaker",
      "Multiscale",
      "Poison Heal",
      "Prankster",
      "Protosynthesis",
      "Pure Power",
      "Purifying Salt",
      "Queenly Majesty",
      "Quick Draw",
      "Quick Feet",
      "Sand Rush",
      "Simple",
      "Slush Rush",
      "Stakeout",
      "Stamina",
      "Sturdy",
      "Surge Surfer",
      "Tinted Lens",
      "Triage",
      "Unaware",
      "Water Bubble"
    ],
    onValidateRule() {
      if (this.format.gameType !== "singles") {
        throw new Error(`Shared Power currently does not support ${this.format.gameType} battles.`);
      }
    },
    getSharedPower(pokemon) {
      const sharedPower = /* @__PURE__ */ new Set();
      for (const ally of pokemon.side.pokemon) {
        if (pokemon.battle.ruleTable.isRestricted(`ability:${ally.baseAbility}`))
          continue;
        if (ally.previouslySwitchedIn > 0) {
          if (pokemon.battle.dex.currentMod !== "sharedpower" && ["trace", "mirrorarmor"].includes(ally.baseAbility)) {
            sharedPower.add("noability");
            continue;
          }
          sharedPower.add(ally.baseAbility);
        }
      }
      sharedPower.delete(pokemon.baseAbility);
      return sharedPower;
    },
    onBeforeSwitchIn(pokemon) {
      let format = this.format;
      if (!format.getSharedPower)
        format = this.dex.formats.get("gen9sharedpower");
      for (const ability of format.getSharedPower(pokemon)) {
        const effect = "ability:" + ability;
        pokemon.volatiles[effect] = { id: this.toID(effect), target: pokemon };
        if (!pokemon.m.abils)
          pokemon.m.abils = [];
        if (!pokemon.m.abils.includes(effect))
          pokemon.m.abils.push(effect);
      }
    },
    onSwitchInPriority: 2,
    onSwitchIn(pokemon) {
      let format = this.format;
      if (!format.getSharedPower)
        format = this.dex.formats.get("gen9sharedpower");
      for (const ability of format.getSharedPower(pokemon)) {
        if (ability === "noability") {
          this.hint(`Mirror Armor and Trace break in Shared Power formats that don't use Shared Power as a base, so they get removed from non-base users.`);
        }
        const effect = "ability:" + ability;
        delete pokemon.volatiles[effect];
        pokemon.addVolatile(effect);
      }
    }
  },
  {
    name: "[Gen 9] STABmons",
    desc: `Pok&eacute;mon can use any move of their typing, in addition to the moves they can normally learn.`,
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3710577/">STABmons</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3714664/">STABmons Resources</a>`
    ],
    mod: "gen9",
    ruleset: ["Standard OMs", "STABmons Move Legality", "Sleep Moves Clause", "Min Source Gen = 9"],
    banlist: [
      "Araquanid",
      "Arceus",
      "Azumarill",
      "Basculegion",
      "Basculegion-F",
      "Baxcalibur",
      "Calyrex-Ice",
      "Calyrex-Shadow",
      "Chi-Yu",
      "Chien-Pao",
      "Cloyster",
      "Deoxys-Base",
      "Deoxys-Attack",
      "Dialga",
      "Dialga-Origin",
      "Dragapult",
      "Dragonite",
      "Enamorus-Base",
      "Eternatus",
      "Flutter Mane",
      "Garchomp",
      "Giratina",
      "Giratina-Origin",
      "Groudon",
      "Ho-Oh",
      "Iron Bundle",
      "Kingambit",
      "Komala",
      "Koraidon",
      "Kyogre",
      "Kyurem-Black",
      "Kyurem-White",
      "Landorus-Base",
      "Lilligant-Hisui",
      "Lugia",
      "Lunala",
      "Magearna",
      "Manaphy",
      "Mewtwo",
      "Miraidon",
      "Necrozma-Dawn-Wings",
      "Necrozma-Dusk-Mane",
      "Ogerpon-Hearthflame",
      "Palkia",
      "Palkia-Origin",
      "Pecharunt",
      "Porygon-Z",
      "Rayquaza",
      "Regieleki",
      "Reshiram",
      "Roaring Moon",
      "Shaymin-Sky",
      "Solgaleo",
      "Spectrier",
      "Terapagos",
      "Ursaluna",
      "Ursaluna-Bloodmoon",
      "Urshifu-Base",
      "Walking Wake",
      "Weavile",
      "Zacian",
      "Zacian-Crowned",
      "Zamazenta",
      "Zamazenta-Crowned",
      "Zekrom",
      "Zoroark-Hisui",
      "Arena Trap",
      "Moody",
      "Shadow Tag",
      "Damp Rock",
      "King's Rock",
      "Razor Fang",
      "Baton Pass",
      "Shed Tail"
    ],
    restricted: [
      "Acupressure",
      "Belly Drum",
      "Clangorous Soul",
      "Dire Claw",
      "Extreme Speed",
      "Fillet Away",
      "Gigaton Hammer",
      "Last Respects",
      "No Retreat",
      "Revival Blessing",
      "Shell Smash",
      "Shift Gear",
      "Triple Arrows",
      "V-create",
      "Victory Dance"
    ]
  },
  {
    name: "[Gen 7] Pure Hackmons",
    desc: `Anything that can be hacked in-game and is usable in local battles is allowed.`,
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3734057/">USUM Pure Hackmons</a>`
    ],
    mod: "gen7",
    ruleset: ["-Nonexistent", "Team Preview", "HP Percentage Mod", "Cancel Mod", "Endless Battle Clause"]
  },
  // Challengeable OMs
  ///////////////////////////////////////////////////////////////////
  {
    section: "Challengeable OMs",
    column: 2
  },
  {
    name: "[Gen 9] Camomons",
    desc: `Pok&eacute;mon have their types set to match their first two moves.`,
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3711340/">Camomons</a>`
    ],
    mod: "gen9",
    searchShow: false,
    ruleset: ["Standard OMs", "Sleep Clause Mod", "Evasion Items Clause", "Evasion Abilities Clause", "Terastal Clause", "Camomons Mod", "Min Source Gen = 9"],
    banlist: [
      "Arceus",
      "Baxcalibur",
      "Calyrex-Ice",
      "Calyrex-Shadow",
      "Chi-Yu",
      "Chien-Pao",
      "Darkrai",
      "Deoxys-Base",
      "Deoxys-Attack",
      "Deoxys-Speed",
      "Dialga",
      "Dialga-Origin",
      "Dragonite",
      "Drednaw",
      "Enamorus-Base",
      "Espathra",
      "Eternatus",
      "Flutter Mane",
      "Giratina",
      "Giratina-Origin",
      "Groudon",
      "Ho-Oh",
      "Iron Bundle",
      "Kommo-o",
      "Koraidon",
      "Kyogre",
      "Kyurem",
      "Kyurem-Black",
      "Kyurem-White",
      "Landorus-Base",
      "Lugia",
      "Lunala",
      "Magearna",
      "Manaphy",
      "Mewtwo",
      "Miraidon",
      "Necrozma-Dawn-Wings",
      "Necrozma-Dusk-Mane",
      "Palkia",
      "Palkia-Origin",
      "Rayquaza",
      "Reshiram",
      "Roaring Moon",
      "Shaymin-Sky",
      "Sneasler",
      "Solgaleo",
      "Spectrier",
      "Tornadus-Therian",
      "Ursaluna-Bloodmoon",
      "Volcarona",
      "Zacian",
      "Zacian-Crowned",
      "Zamazenta-Crowned",
      "Zekrom",
      "Arena Trap",
      "Moody",
      "Shadow Tag",
      "Booster Energy",
      "King's Rock",
      "Light Clay",
      "Razor Fang",
      "Baton Pass",
      "Last Respects",
      "Shed Tail"
    ]
  },
  {
    name: "[Gen 9] Convergence",
    desc: `Allows all Pok&eacute;mon that have identical types to share moves and abilities.`,
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3714048/">Convergence</a>`
    ],
    mod: "gen9",
    searchShow: false,
    ruleset: ["Standard OMs", "Sleep Clause Mod", "Convergence Legality", "Terastal Clause", "!Obtainable Abilities", "Min Source Gen = 9"],
    banlist: [
      "Arceus",
      "Calyrex-Ice",
      "Calyrex-Shadow",
      "Chi-Yu",
      "Chien-Pao",
      "Darkrai",
      "Deoxys-Base",
      "Deoxys-Attack",
      "Deoxys-Speed",
      "Dialga",
      "Dialga-Origin",
      "Dondozo",
      "Eternatus",
      "Flutter Mane",
      "Giratina",
      "Giratina-Origin",
      "Groudon",
      "Ho-oh",
      "Inteleon",
      "Iron Bundle",
      "Iron Hands",
      "Koraidon",
      "Kyogre",
      "Kyurem-Black",
      "Kyurem-White",
      "Landorus-Base",
      "Lilligant-Hisui",
      "Lugia",
      "Lunala",
      "Magearna",
      "Manaphy",
      "Mewtwo",
      "Miraidon",
      "Necrozma-Dawn-Wings",
      "Necrozma-Dusk-Mane",
      "Ogerpon-Hearthflame",
      "Palafin",
      "Palkia",
      "Palkia-Origin",
      "Rayquaza",
      "Regieleki",
      "Regigigas",
      "Reshiram",
      "Shaymin-Sky",
      "Solgaleo",
      "Slaking",
      "Smeargle",
      "Spectrier",
      "Urshifu-Base",
      "Urshifu-Rapid-Strike",
      "Walking Wake",
      "Zacian",
      "Zacian-Crowned",
      "Zamazenta",
      "Zamazenta-Crowned",
      "Zekrom",
      "Arena Trap",
      "Comatose",
      "Contrary",
      "Drizzle",
      "Imposter",
      "Moody",
      "Pure Power",
      "Shadow Tag",
      "Speed Boost",
      "Heat Rock",
      "King's Rock",
      "Light Clay",
      "Razor Fang",
      "Baton Pass",
      "Extreme Speed",
      "Last Respects",
      "Population Bomb",
      "Quiver Dance",
      "Rage Fist",
      "Shed Tail",
      "Shell Smash",
      "Spore",
      "Transform"
    ]
  },
  {
    name: "[Gen 9] Cross Evolution",
    desc: `Give a Pok&eacute;mon a Pok&eacute;mon name of the next evolution stage as a nickname to inherit stat changes, typing, abilities, and moves from the next stage Pok&eacute;mon.`,
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3710953/">Cross Evolution</a>`
    ],
    mod: "gen9",
    searchShow: false,
    ruleset: ["Standard OMs", "Sleep Moves Clause", "Terastal Clause", "Min Source Gen = 9"],
    banlist: [
      "Basculin-White-Striped",
      "Duraludon",
      "Kyogre",
      "Miraidon",
      "Scyther",
      "Sneasel",
      "Sneasel-Hisui",
      "Ursaring",
      "Arena Trap",
      "Huge Power",
      "Pure Power",
      "Shadow Tag",
      "Speed Boost",
      "Moody",
      "King's Rock",
      "Razor Fang",
      "Baton Pass"
    ],
    restricted: ["Frosmoth", "Gallade", "Gholdengo", "Lilligant-Hisui", "Lunala", "Solgaleo"],
    onValidateTeam(team) {
      const nums = /* @__PURE__ */ new Set();
      for (const set of team) {
        const name = set.name;
        const species = this.dex.species.get(name);
        if (nums.has(species.num)) {
          return [
            `Your Pok\xE9mon must have different nicknames.`,
            `(You have more than one Pok\xE9mon named after a form of '${species.name}')`
          ];
        }
        if (species.exists && species.name !== set.species)
          nums.add(species.num);
      }
      if (!nums.size) {
        return [
          `${this.format.name} works using nicknames; your team has 0 nicknamed Pok\xE9mon.`,
          `(If this was intentional, add a nickname to one Pok\xE9mon that isn't the name of a Pok\xE9mon species.)`
        ];
      }
    },
    checkCanLearn(move, species, lsetData, set) {
      if (!set.sp?.exists || !set.crossSpecies?.exists) {
        return this.checkCanLearn(move, species, lsetData, set);
      }
      const problem = this.checkCanLearn(move, set.sp);
      if (!problem)
        return null;
      if (this.checkCanLearn(move, set.crossSpecies))
        return problem;
      return null;
    },
    validateSet(set, teamHas) {
      const crossSpecies = this.dex.species.get(set.name);
      let problems = this.dex.formats.get("Obtainable Misc").onChangeSet?.call(this, set, this.format) || null;
      if (Array.isArray(problems) && problems.length)
        return problems;
      const crossNonstandard = !this.ruleTable.has("standardnatdex") && crossSpecies.isNonstandard === "Past" || crossSpecies.isNonstandard === "Future";
      const crossIsCap = !this.ruleTable.has("+pokemontag:cap") && crossSpecies.isNonstandard === "CAP";
      if (!crossSpecies.exists || crossNonstandard || crossIsCap)
        return this.validateSet(set, teamHas);
      const species = this.dex.species.get(set.species);
      const check = this.checkSpecies(set, species, species, {});
      if (check)
        return [check];
      const nonstandard = !this.ruleTable.has("standardnatdex") && species.isNonstandard === "Past";
      const isCap = !this.ruleTable.has("+pokemontag:cap") && species.isNonstandard === "CAP";
      if (!species.exists || nonstandard || isCap || species === crossSpecies)
        return this.validateSet(set, teamHas);
      if (!species.nfe)
        return [`${species.name} cannot cross evolve because it doesn't evolve.`];
      const crossIsUnreleased = crossSpecies.tier === "Unreleased" && crossSpecies.isNonstandard === "Unobtainable" && !this.ruleTable.has("+unobtainable");
      if (crossSpecies.battleOnly || crossIsUnreleased || !crossSpecies.prevo) {
        return [`${species.name} cannot cross evolve into ${crossSpecies.name} because it isn't an evolution.`];
      }
      if (this.ruleTable.isRestrictedSpecies(crossSpecies)) {
        return [`${species.name} cannot cross evolve into ${crossSpecies.name} because it is banned.`];
      }
      const crossPrevoSpecies = this.dex.species.get(crossSpecies.prevo);
      if (!crossPrevoSpecies.prevo !== !species.prevo) {
        return [
          `${species.name} cannot cross evolve into ${crossSpecies.name} because they are not consecutive evolution stages.`
        ];
      }
      const item = this.dex.items.get(set.item);
      if (item.itemUser?.length) {
        if (!item.itemUser.includes(crossSpecies.name) || crossSpecies.name !== species.name) {
          return [`${species.name} cannot use ${item.name} because it is cross evolved into ${crossSpecies.name}.`];
        }
      }
      const ability = this.dex.abilities.get(set.ability);
      if (!this.ruleTable.isRestricted(`ability:${ability.id}`) || Object.values(species.abilities).includes(ability.name)) {
        set.species = crossSpecies.name;
      }
      set.sp = species;
      set.crossSpecies = crossSpecies;
      problems = this.validateSet(set, teamHas);
      set.name = crossSpecies.name;
      set.species = species.name;
      return problems;
    },
    onModifySpecies(species, target, source, effect) {
      if (!target)
        return;
      if (effect && ["imposter", "transform"].includes(effect.id))
        return;
      if (target.set.name === target.set.species)
        return;
      const crossSpecies = this.dex.species.get(target.set.name);
      if (!crossSpecies.exists)
        return;
      if (species.battleOnly || !species.nfe)
        return;
      const crossIsUnreleased = crossSpecies.tier === "Unreleased" && crossSpecies.isNonstandard === "Unobtainable" && !this.ruleTable.has("+unobtainable");
      if (crossSpecies.battleOnly || crossIsUnreleased || !crossSpecies.prevo)
        return;
      const crossPrevoSpecies = this.dex.species.get(crossSpecies.prevo);
      if (!crossPrevoSpecies.prevo !== !species.prevo)
        return;
      const mixedSpecies = this.dex.deepClone(species);
      mixedSpecies.weightkg = Math.max(0.1, +(species.weightkg + crossSpecies.weightkg - crossPrevoSpecies.weightkg)).toFixed(1);
      mixedSpecies.nfe = false;
      mixedSpecies.evos = [];
      mixedSpecies.eggGroups = crossSpecies.eggGroups;
      mixedSpecies.abilities = crossSpecies.abilities;
      mixedSpecies.bst = 0;
      let i;
      for (i in species.baseStats) {
        const statChange = crossSpecies.baseStats[i] - crossPrevoSpecies.baseStats[i];
        mixedSpecies.baseStats[i] = this.clampIntRange(species.baseStats[i] + statChange, 1, 255);
        mixedSpecies.bst += mixedSpecies.baseStats[i];
      }
      if (crossSpecies.types[0] !== crossPrevoSpecies.types[0])
        mixedSpecies.types[0] = crossSpecies.types[0];
      if (crossSpecies.types[1] !== crossPrevoSpecies.types[1]) {
        mixedSpecies.types[1] = crossSpecies.types[1] || crossSpecies.types[0];
      }
      if (mixedSpecies.types[0] === mixedSpecies.types[1])
        mixedSpecies.types = [mixedSpecies.types[0]];
      return mixedSpecies;
    },
    onBegin() {
      for (const pokemon of this.getAllPokemon()) {
        pokemon.baseSpecies = pokemon.species;
      }
    }
  },
  {
    name: "[Gen 9] Fortemons",
    desc: `Put an attacking move in the item slot to have all of a Pok&eacute;mon's attacks inherit its properties.`,
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3713983/">Fortemons</a>`
    ],
    mod: "gen9",
    searchShow: false,
    ruleset: ["Standard OMs", "Sleep Moves Clause", "Terastal Clause", "Min Source Gen = 9"],
    banlist: [
      "Annihilape",
      "Arceus",
      "Archaludon",
      "Azumarill",
      "Calyrex-Ice",
      "Calyrex-Shadow",
      "Chi-Yu",
      "Chien-Pao",
      "Cloyster",
      "Comfey",
      "Deoxys-Base",
      "Deoxys-Attack",
      "Dialga-Base",
      "Espathra",
      "Eternatus",
      "Flutter Mane",
      "Giratina-Base",
      "Great Tusk",
      "Groudon",
      "Ho-Oh",
      "Iron Bundle",
      "Iron Treads",
      "Koraidon",
      "Kyogre",
      "Kyurem-Black",
      "Kyurem-White",
      "Lugia",
      "Lunala",
      "Magearna",
      "Meowscarada",
      "Mewtwo",
      "Miraidon",
      "Necrozma-Dawn-Wings",
      "Necrozma-Dusk-Mane",
      "Palafin",
      "Palkia",
      "Palkia-Origin",
      "Rayquaza",
      "Reshiram",
      "Samurott-Hisui",
      "Shaymin-Sky",
      "Skeledirge",
      "Smeargle",
      "Solgaleo",
      "Spectrier",
      "Sneasler",
      "Terapagos",
      "Urshifu",
      "Urshifu-Rapid-Strike",
      "Zacian",
      "Zacian-Crowned",
      "Zamazenta",
      "Zamazenta-Crowned",
      "Zekrom",
      "Arena Trap",
      "Moody",
      "Serene Grace",
      "Shadow Tag",
      "Damp Rock",
      "Heat Rock",
      "Light Clay",
      "Baton Pass",
      "Beat Up",
      "Fake Out",
      "Last Respects",
      "Shed Tail"
    ],
    restricted: [
      "Doom Desire",
      "Dynamic Punch",
      "Electro Ball",
      "Explosion",
      "Gyro Ball",
      "Final Gambit",
      "Flail",
      "Flip Turn",
      "Fury Cutter",
      "Future Sight",
      "Grass Knot",
      "Grassy Glide",
      "Hard Press",
      "Heavy Slam",
      "Heat Crash",
      "Inferno",
      "Low Kick",
      "Misty Explosion",
      "Nuzzle",
      "Power Trip",
      "Reversal",
      "Self-Destruct",
      "Spit Up",
      "Stored Power",
      "Tera Blast",
      "U-turn",
      "Weather Ball",
      "Zap Cannon"
    ],
    onValidateTeam(team) {
      const itemTable = /* @__PURE__ */ new Set();
      for (const set of team) {
        const forte = this.toID(set.item);
        if (!forte)
          continue;
        const move = this.dex.moves.get(forte);
        if (move.exists && move.id !== "metronome") {
          if (itemTable.has(forte)) {
            return [
              `You are limited to one of each move in the item slot per team.`,
              `(You have more than one ${move.name}.)`
            ];
          }
          itemTable.add(forte);
        }
      }
    },
    validateSet(set, teamHas) {
      const item = set.item;
      const species = this.dex.species.get(set.species);
      const move = this.dex.moves.get(item);
      if (!move.exists || move.id === "metronome" || move.category === "Status") {
        return this.validateSet(set, teamHas);
      }
      set.item = "";
      const problems = this.validateSet(set, teamHas) || [];
      set.item = item;
      if (this.checkCanLearn(move, species, this.allSources(species), set)) {
        problems.push(`${species.name} can't learn ${move.name}.`);
      }
      if (set.moves.map(this.toID).includes(move.id)) {
        problems.push(`Moves in the item slot can't be in the moveslots as well.`);
      }
      if (this.ruleTable.has(`-move:${move.id}`)) {
        problems.push(`The move ${move.name} is fully banned.`);
      }
      const accuracyLoweringMove = move.secondaries?.some((secondary) => secondary.boosts?.accuracy && secondary.boosts?.accuracy < 0);
      const flinchMove = move.secondaries?.some((secondary) => secondary.volatileStatus === "flinch");
      const freezeMove = move.secondaries?.some((secondary) => secondary.status === "frz") || move.id === "triattack";
      if (this.ruleTable.isRestricted(`move:${move.id}`) || (accuracyLoweringMove || move.ohko || move.multihit || move.id === "beatup" || move.flags["charge"] || move.priority > 0 || move.damageCallback || flinchMove || freezeMove) && !this.ruleTable.has(`+move:${move.id}`)) {
        problems.push(`The move ${move.name} can't be used as an item.`);
      }
      return problems.length ? problems : null;
    },
    onBegin() {
      for (const pokemon of this.getAllPokemon()) {
        const move = this.dex.getActiveMove(pokemon.set.item);
        if (move.exists && move.category !== "Status") {
          pokemon.m.forte = move;
          pokemon.item = "mail";
        }
      }
    },
    onModifyMovePriority: 1,
    onModifyMove(move, pokemon, target) {
      const forte = pokemon.m.forte;
      if (move.category !== "Status" && forte) {
        move.flags = { ...move.flags, ...forte.flags };
        if (forte.self) {
          if (forte.self.onHit && move.self?.onHit) {
            for (const i in forte.self) {
              if (i.startsWith("onHit"))
                continue;
              move.self[i] = forte.self[i];
            }
          } else {
            move.self = { ...move.self || {}, ...forte.self };
          }
        }
        if (forte.selfBoost?.boosts) {
          if (!move.selfBoost?.boosts)
            move.selfBoost = { boosts: {} };
          let boostid;
          for (boostid in forte.selfBoost.boosts) {
            if (!move.selfBoost.boosts[boostid])
              move.selfBoost.boosts[boostid] = 0;
            move.selfBoost.boosts[boostid] += forte.selfBoost.boosts[boostid];
          }
        }
        if (forte.secondaries) {
          move.secondaries = [...move.secondaries || [], ...forte.secondaries];
        }
        move.critRatio = (move.critRatio || 1) + (forte.critRatio || 1) - 1;
        const VALID_PROPERTIES = [
          "alwaysHit",
          "basePowerCallback",
          "breaksProtect",
          "drain",
          "forceSTAB",
          "forceSwitch",
          "hasCrashDamage",
          "hasSheerForce",
          "ignoreAbility",
          "ignoreAccuracy",
          "ignoreDefensive",
          "ignoreEvasion",
          "ignoreImmunity",
          "mindBlownRecoil",
          "noDamageVariance",
          "ohko",
          "overrideDefensivePokemon",
          "overrideDefensiveStat",
          "overrideOffensivePokemon",
          "overrideOffensiveStat",
          "pseudoWeather",
          "recoil",
          "selfdestruct",
          "selfSwitch",
          "sleepUsable",
          "smartTarget",
          "stealsBoosts",
          "thawsTarget",
          "volatileStatus",
          "willCrit"
        ];
        for (const property of VALID_PROPERTIES) {
          if (forte[property]) {
            move[property] = forte[property];
          }
        }
        if (forte.onEffectiveness) {
          move.onEffectiveness = function(typeMod, t, type, m) {
            return forte.onEffectiveness.call(this, typeMod, t, type, m);
          };
        }
        forte.onModifyMove?.call(this, move, pokemon, target);
      }
    },
    onModifyPriority(priority, source, target, move) {
      const forte = source?.m.forte;
      if (move.category !== "Status" && forte) {
        if (source.hasAbility("Triage") && forte.flags["heal"]) {
          return priority + (move.flags["heal"] ? 0 : 3);
        }
        return priority + forte.priority;
      }
    },
    onModifyTypePriority: 1,
    onModifyType(move, pokemon, target) {
      const forte = pokemon.m.forte;
      if (move.category !== "Status" && forte) {
        this.singleEvent("ModifyType", forte, null, pokemon, target, move, move);
      }
    },
    onHitPriority: 1,
    onHit(target, source, move) {
      const forte = source.m.forte;
      if (move?.category !== "Status" && forte) {
        this.singleEvent("Hit", forte, {}, target, source, move);
        if (forte.self)
          this.singleEvent("Hit", forte.self, {}, source, source, move);
        this.singleEvent("AfterHit", forte, {}, target, source, move);
      }
    },
    onAfterSubDamage(damage, target, source, move) {
      const forte = source.m.forte;
      if (move?.category !== "Status" && forte) {
        this.singleEvent("AfterSubDamage", forte, null, target, source, move, damage);
      }
    },
    onModifySecondaries(secondaries, target, source, move) {
      if (secondaries.some((s) => !!s.self))
        move.selfDropped = false;
    },
    onAfterMoveSecondaryPriority: 1,
    onAfterMoveSecondarySelf(source, target, move) {
      const forte = source.m.forte;
      if (move?.category !== "Status" && forte) {
        this.singleEvent("AfterMoveSecondarySelf", forte, null, source, target, move);
      }
    },
    onBasePowerPriority: 1,
    onBasePower(basePower, source, target, move) {
      const forte = source.m.forte;
      if (move.category !== "Status" && forte?.onBasePower) {
        forte.onBasePower.call(this, basePower, source, target, move);
      }
    },
    pokemon: {
      getItem() {
        const move = this.battle.dex.moves.get(this.m.forte);
        if (!move.exists)
          return Object.getPrototypeOf(this).getItem.call(this);
        return {
          ...this.battle.dex.items.get("mail"),
          name: move.name,
          id: move.id,
          ignoreKlutz: true,
          onTakeItem: false
        };
      }
    }
  },
  {
    name: "[Gen 9] Full Potential",
    desc: `Pok&eacute;mon's moves hit off of their highest stat, except HP.`,
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3711127/">Full Potential</a>`
    ],
    mod: "fullpotential",
    searchShow: false,
    ruleset: ["Standard OMs", "Evasion Abilities Clause", "Evasion Items Clause", "Sleep Moves Clause", "Terastal Clause", "Min Source Gen = 9"],
    banlist: [
      "Arceus",
      "Calyrex-Ice",
      "Calyrex-Shadow",
      "Deoxys",
      "Deoxys-Attack",
      "Deoxys-Defense",
      "Deoxys-Speed",
      "Dialga",
      "Dialga-Origin",
      "Dragapult",
      "Eternatus",
      "Giratina",
      "Giratina-Origin",
      "Goodra-Hisui",
      "Groudon",
      "Ho-Oh",
      "Iron Bundle",
      "Koraidon",
      "Kyogre",
      "Kyurem-Black",
      "Kyurem-White",
      "Lugia",
      "Lunala",
      "Mewtwo",
      "Miraidon",
      "Necrozma-Dusk-Mane",
      "Necrozma-Dawn-Wings",
      "Palkia",
      "Palkia-Origin",
      "Rayquaza",
      "Regieleki",
      "Scream Tail",
      "Shaymin-Sky",
      "Spectrier",
      "Solgaleo",
      "Zacian",
      "Zacian-Crowned",
      "Zamazenta",
      "Zamazenta-Crowned",
      "Zekrom",
      "Arena Trap",
      "Chlorophyll",
      "Drought",
      "Moody",
      "Sand Rush",
      "Shadow Tag",
      "Slush Rush",
      "Swift Swim",
      "Unburden",
      "Booster Energy",
      "Choice Scarf",
      "Heat Rock",
      "King's Rock",
      "Razor Fang",
      "Baton Pass",
      "Shed Tail",
      "Tailwind"
    ]
  },
  {
    name: "[Gen 9] Pokebilities",
    desc: `Pok&eacute;mon have all of their released abilities simultaneously.`,
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3712725/">Pok&eacute;bilities</a>`
    ],
    mod: "pokebilities",
    searchShow: false,
    ruleset: ["Standard OMs", "Sleep Moves Clause", "Min Source Gen = 9"],
    banlist: [
      "Arceus",
      "Annihilape",
      "Baxcalibur",
      "Calyrex-Ice",
      "Calyrex-Shadow",
      "Chi-Yu",
      "Conkeldurr",
      "Deoxys-Base",
      "Deoxys-Attack",
      "Dialga",
      "Dialga-Origin",
      "Espathra",
      "Eternatus",
      "Excadrill",
      "Flutter Mane",
      "Giratina",
      "Giratina-Origin",
      "Groudon",
      "Ho-Oh",
      "Iron Bundle",
      "Koraidon",
      "Kyogre",
      "Kyurem-Black",
      "Kyurem-White",
      "Landorus-Base",
      "Lugia",
      "Lunala",
      "Miraidon",
      "Mewtwo",
      "Necrozma-Dusk-Mane",
      "Necrozma-Dawn-Wings",
      "Ogerpon-Hearthflame",
      "Palafin",
      "Palkia",
      "Palkia-Origin",
      "Porygon-Z",
      "Rayquaza",
      "Regieleki",
      "Reshiram",
      "Shaymin-Sky",
      "Smeargle",
      "Sneasler",
      "Solgaleo",
      "Spectrier",
      "Terapagos",
      "Ursaluna-Bloodmoon",
      "Urshifu-Base",
      "Zacian",
      "Zacian-Crowned",
      "Zamazenta-Crowned",
      "Zekrom",
      "Arena Trap",
      "Moody",
      "Shadow Tag",
      "King's Rock",
      "Razor Fang",
      "Baton Pass",
      "Shed Tail",
      "Last Respects"
    ],
    onValidateSet(set) {
      const species = this.dex.species.get(set.species);
      const unSeenAbilities = Object.keys(species.abilities).filter((key) => key !== "S" && (key !== "H" || !species.unreleasedHidden)).map((key) => species.abilities[key]).filter((ability) => ability !== set.ability);
      if (unSeenAbilities.length && this.toID(set.ability) !== this.toID(species.abilities["S"])) {
        for (const abilityName of unSeenAbilities) {
          const banReason = this.ruleTable.check("ability:" + this.toID(abilityName));
          if (banReason) {
            return [`${set.name}'s ability ${abilityName} is ${banReason}.`];
          }
        }
      }
    },
    onBegin() {
      for (const pokemon of this.getAllPokemon()) {
        if (pokemon.ability === this.toID(pokemon.species.abilities["S"])) {
          continue;
        }
        pokemon.m.innates = Object.keys(pokemon.species.abilities).filter((key) => key !== "S" && (key !== "H" || !pokemon.species.unreleasedHidden)).map((key) => this.toID(pokemon.species.abilities[key])).filter((ability) => ability !== pokemon.ability);
      }
    },
    onBeforeSwitchIn(pokemon) {
      const neededBeforeSwitchInIDs = [
        "clearbody",
        "competitive",
        "contrary",
        "defiant",
        "fullmetalbody",
        "hypercutter",
        "innerfocus",
        "mirrorarmor",
        "oblivious",
        "owntempo",
        "rattled",
        "scrappy",
        "simple",
        "whitesmoke"
      ];
      if (pokemon.m.innates) {
        for (const innate of pokemon.m.innates) {
          if (!neededBeforeSwitchInIDs.includes(innate))
            continue;
          if (pokemon.hasAbility(innate))
            continue;
          pokemon.addVolatile("ability:" + innate, pokemon);
        }
      }
    },
    onSwitchInPriority: 2,
    onSwitchIn(pokemon) {
      if (pokemon.m.innates) {
        for (const innate of pokemon.m.innates) {
          if (pokemon.hasAbility(innate))
            continue;
          pokemon.addVolatile("ability:" + innate, pokemon);
        }
      }
    },
    onSwitchOut(pokemon) {
      for (const innate of Object.keys(pokemon.volatiles).filter((i) => i.startsWith("ability:"))) {
        pokemon.removeVolatile(innate);
      }
    },
    onFaint(pokemon) {
      for (const innate of Object.keys(pokemon.volatiles).filter((i) => i.startsWith("ability:"))) {
        const innateEffect = this.dex.conditions.get(innate);
        this.singleEvent("End", innateEffect, null, pokemon);
      }
    },
    onAfterMega(pokemon) {
      for (const innate of Object.keys(pokemon.volatiles).filter((i) => i.startsWith("ability:"))) {
        pokemon.removeVolatile(innate);
      }
      pokemon.m.innates = void 0;
    }
  },
  {
    name: "[Gen 9] Pure Hackmons",
    desc: `Anything directly hackable onto a set (EVs, IVs, forme, ability, item, and move) and is usable in local battles is allowed.`,
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3712086/">Pure Hackmons</a>`
    ],
    mod: "gen9",
    searchShow: false,
    ruleset: ["Team Preview", "HP Percentage Mod", "Cancel Mod", "Hackmons Forme Legality", "Species Reveal Clause", "Endless Battle Clause"]
  },
  {
    name: "[Gen 9] Revelationmons",
    desc: `The moves in the first slot(s) of a Pok&eacute;mon's set have their types changed to match the Pok&eacute;mon's type(s).`,
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3711644/">Revelationmons</a>`
    ],
    mod: "gen9",
    searchShow: false,
    ruleset: ["Standard OMs", "Sleep Moves Clause", "Revelationmons Mod", "Terastal Clause", "Min Source Gen = 9"],
    banlist: [
      "Arceus",
      "Barraskewda",
      "Basculegion-Base",
      "Baxcalibur",
      "Calyrex-Ice",
      "Calyrex-Shadow",
      "Chi-Yu",
      "Chien-Pao",
      "Darkrai",
      "Deoxys-Base",
      "Deoxys-Attack",
      "Dialga",
      "Dialga-Origin",
      "Dragapult",
      "Dragonite",
      "Eternatus",
      "Flutter Mane",
      "Giratina",
      "Giratina-Origin",
      "Groudon",
      "Ho-Oh",
      "Iron Bundle",
      "Kommo-o",
      "Koraidon",
      "Kyogre",
      "Kyurem-Black",
      "Kyurem-White",
      "Landorus-Base",
      "Lugia",
      "Lunala",
      "Magearna",
      "Mewtwo",
      "Miraidon",
      "Necrozma-Dawn-Wings",
      "Necrozma-Dusk-Mane",
      "Noivern",
      "Ogerpon-Hearthflame",
      "Palafin",
      "Palkia",
      "Palkia-Origin",
      "Polteageist",
      "Rayquaza",
      "Reshiram",
      "Roaring Moon",
      "Shaymin-Sky",
      "Solgaleo",
      "Spectrier",
      "Urshifu-Base",
      "Zacian",
      "Zacian-Crowned",
      "Zekrom",
      "Arena Trap",
      "Moody",
      "Shadow Tag",
      "King's Rock",
      "Razor Fang",
      "Baton Pass",
      "Last Respects"
    ],
    restricted: ["U-turn", "Volt Switch"]
  },
  {
    name: "[Gen 9] Sharing is Caring",
    desc: `All Pok&eacute;mon on a team share their items.`,
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3727118/">Sharing is Caring</a>`
    ],
    mod: "sharingiscaring",
    searchShow: false,
    ruleset: ["Standard OMs", "Evasion Items Clause", "Sleep Moves Clause", "Terastal Clause", "Min Source Gen = 9"],
    banlist: [
      "Arceus",
      "Calyrex-Ice",
      "Calyrex-Shadow",
      "Chi-Yu",
      "Chien-Pao",
      "Darkrai",
      "Deoxys-Base",
      "Deoxys-Attack",
      "Dialga",
      "Dialga-Origin",
      "Espathra",
      "Eternatus",
      "Flutter Mane",
      "Giratina",
      "Giratina-Origin",
      "Groudon",
      "Ho-Oh",
      "Iron Bundle",
      "Koraidon",
      "Kyogre",
      "Kyurem-Black",
      "Kyurem-White",
      "Landorus-Base",
      "Lugia",
      "Lunala",
      "Magearna",
      "Mewtwo",
      "Miraidon",
      "Necrozma-Dawn-Wings",
      "Necrozma-Dusk-Mane",
      "Palafin",
      "Palkia",
      "Palkia-Origin",
      "Rayquaza",
      "Regieleki",
      "Reshiram",
      "Shaymin-Sky",
      "Solgaleo",
      "Spectrier",
      "Terapagos",
      "Urshifu-Base",
      "Zacian",
      "Zacian-Crowned",
      "Zamazenta",
      "Zamazenta-Crowned",
      "Zekrom",
      "Arena Trap",
      "Moody",
      "Scope Lens",
      "Shadow Tag",
      "Choice Band",
      "Choice Scarf",
      "Choice Specs",
      "Focus Band",
      "Focus Sash",
      "King's Rock",
      "Quick Claw",
      "Razor Fang",
      "Baton Pass",
      "Last Respects",
      "Revival Blessing",
      "Shed Tail"
    ],
    onValidateRule() {
      if (this.format.gameType !== "singles") {
        throw new Error(`Sharing is Caring currently does not support ${this.format.gameType} battles.`);
      }
    },
    getSharedItems(pokemon) {
      const items = /* @__PURE__ */ new Set();
      for (const ally of pokemon.side.pokemon) {
        if (!ally.item || ally.fainted)
          continue;
        items.add(ally.item);
      }
      items.delete(pokemon.item);
      return items;
    },
    onBeforeSwitchIn(pokemon) {
      let format = this.format;
      if (!format.getSharedItems)
        format = this.dex.formats.get("gen9sharingiscaring");
      if (!pokemon.m.sharedItemsUsed)
        pokemon.m.sharedItemsUsed = [];
      for (const item of format.getSharedItems(pokemon)) {
        if (pokemon.m.sharedItemsUsed.includes(item))
          continue;
        const effect = "item:" + item;
        pokemon.volatiles[effect] = { id: this.toID(effect), target: pokemon };
        if (!pokemon.m.items)
          pokemon.m.items = [];
        if (!pokemon.m.items.includes(effect))
          pokemon.m.items.push(effect);
      }
    },
    onSwitchInPriority: 2,
    onSwitchIn(pokemon) {
      let format = this.format;
      if (!format.getSharedItems)
        format = this.dex.formats.get("gen9sharingiscaring");
      for (const item of format.getSharedItems(pokemon)) {
        if (pokemon.m.sharedItemsUsed.includes(item))
          continue;
        const effect = "item:" + item;
        delete pokemon.volatiles[effect];
        pokemon.addVolatile(effect);
      }
    }
  },
  {
    name: "[Gen 9] Tera Donation",
    desc: `The first Pok&eacute;mon sent out immediately terastallizes. The other Pok&eacute;mon in the party inherit that Tera Type as an additional type.`,
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3715801/">Tera Donation</a>`
    ],
    mod: "gen9",
    searchShow: false,
    ruleset: ["Standard OMs", "Sleep Moves Clause", "Tera Type Preview", "Min Source Gen = 9"],
    banlist: [
      "Annihilape",
      "Arceus",
      "Calyrex-Ice",
      "Calyrex-Shadow",
      "Chi-Yu",
      "Chien-Pao",
      "Darkrai",
      "Deoxys-Base",
      "Deoxys-Attack",
      "Deoxys-Speed",
      "Dialga",
      "Dialga-Origin",
      "Espathra",
      "Eternatus",
      "Giratina",
      "Giratina-Origin",
      "Groudon",
      "Flutter Mane",
      "Ho-Oh",
      "Hoopa-Unbound",
      "Iron Bundle",
      "Koraidon",
      "Kyogre",
      "Kyurem",
      "Kyurem-Black",
      "Kyurem-White",
      "Landorus-Base",
      "Lugia",
      "Lunala",
      "Magearna",
      "Mewtwo",
      "Miraidon",
      "Necrozma-Dawn-Wings",
      "Necrozma-Dusk-Mane",
      "Palafin",
      "Palkia",
      "Palkia-Origin",
      "Rayquaza",
      "Regieleki",
      "Reshiram",
      "Shaymin-Sky",
      "Solgaleo",
      "Spectrier",
      "Terapagos",
      "Urshifu",
      "Urshifu-Rapid-Strike",
      "Volcarona",
      "Zacian",
      "Zacian-Crowned",
      "Zamazenta-Crowned",
      "Zekrom",
      "Arena Trap",
      "Moody",
      "Shadow Tag",
      "Booster Energy",
      "Heat Rock",
      "King's Rock",
      "Razor Fang",
      "Baton Pass",
      "Last Respects",
      "Shed Tail"
    ],
    onValidateRule() {
      if (this.dex.gen !== 9) {
        throw new Error(`Tera Donation is not supported in generations without terastallization.`);
      }
    },
    onSwitchIn(pokemon) {
      if (this.turn === 0) {
        this.actions.terastallize(pokemon);
        const teraType = pokemon.teraType;
        for (const poke of pokemon.side.pokemon) {
          poke.m.thirdType = teraType;
        }
      }
      if (!pokemon.terastallized) {
        this.add("-start", pokemon, "typechange", (pokemon.illusion || pokemon).getTypes(true).join("/"), "[silent]");
      }
    },
    onModifyMove(move, pokemon, target) {
      if (move.id === "terablast") {
        const teraType = pokemon.m.thirdType;
        move.basePowerCallback = function(p, t, m) {
          if ((p.terastallized || teraType) === "Stellar") {
            return 100;
          }
          return 80;
        };
        if (teraType) {
          if (pokemon.getStat("atk", false, true) > pokemon.getStat("spa", false, true)) {
            move.category = "Physical";
          }
          if (teraType === "Stellar") {
            move.self = { boosts: { atk: -1, spa: -1 } };
          }
        }
      }
    },
    onModifyType(move, pokemon, target) {
      if (move.id === "terablast") {
        const teraType = pokemon.m.thirdType;
        if (teraType) {
          move.type = teraType;
        }
      }
    },
    onPrepareHit(target, source, move) {
      if (move.id === "terablast" && source.m.thirdType) {
        this.attrLastMove("[anim] Tera Blast " + source.m.thirdType);
      }
    },
    actions: {
      modifyDamage(baseDamage, pokemon, target, move, suppressMessages) {
        const tr = this.battle.trunc;
        if (!move.type)
          move.type = "???";
        const type = move.type;
        baseDamage += 2;
        if (move.spreadHit) {
          const spreadModifier = move.spreadModifier || (this.battle.gameType === "freeforall" ? 0.5 : 0.75);
          this.battle.debug("Spread modifier: " + spreadModifier);
          baseDamage = this.battle.modify(baseDamage, spreadModifier);
        } else if (move.multihitType === "parentalbond" && move.hit > 1) {
          const bondModifier = this.battle.gen > 6 ? 0.25 : 0.5;
          this.battle.debug(`Parental Bond modifier: ${bondModifier}`);
          baseDamage = this.battle.modify(baseDamage, bondModifier);
        }
        baseDamage = this.battle.runEvent("WeatherModifyDamage", pokemon, target, move, baseDamage);
        const isCrit = target.getMoveHitData(move).crit;
        if (isCrit) {
          baseDamage = tr(baseDamage * (move.critModifier || (this.battle.gen >= 6 ? 1.5 : 2)));
        }
        baseDamage = this.battle.randomizer(baseDamage);
        if (type !== "???") {
          let stab = 1;
          const isSTAB = move.forceSTAB || pokemon.hasType(type) || pokemon.getTypes(false, true).includes(type);
          if (isSTAB) {
            stab = 1.5;
          }
          if ((pokemon.terastallized || pokemon.m.thirdType) === "Stellar") {
            if (!pokemon.stellarBoostedTypes.includes(type)) {
              stab = isSTAB ? 2 : [4915, 4096];
              if (pokemon.species.name !== "Terapagos-Stellar") {
                pokemon.stellarBoostedTypes.push(type);
              }
            }
          } else {
            if (pokemon.terastallized === type && pokemon.getTypes(false, true).includes(type)) {
              stab = 2;
            }
            stab = this.battle.runEvent("ModifySTAB", pokemon, target, move, stab);
          }
          baseDamage = this.battle.modify(baseDamage, stab);
        }
        let typeMod = target.runEffectiveness(move);
        typeMod = this.battle.clampIntRange(typeMod, -6, 6);
        target.getMoveHitData(move).typeMod = typeMod;
        if (typeMod > 0) {
          if (!suppressMessages)
            this.battle.add("-supereffective", target);
          for (let i = 0; i < typeMod; i++) {
            baseDamage *= 2;
          }
        }
        if (typeMod < 0) {
          if (!suppressMessages)
            this.battle.add("-resisted", target);
          for (let i = 0; i > typeMod; i--) {
            baseDamage = tr(baseDamage / 2);
          }
        }
        if (isCrit && !suppressMessages)
          this.battle.add("-crit", target);
        if (pokemon.status === "brn" && move.category === "Physical" && !pokemon.hasAbility("guts")) {
          if (this.battle.gen < 6 || move.id !== "facade") {
            baseDamage = this.battle.modify(baseDamage, 0.5);
          }
        }
        if (this.battle.gen === 5 && !baseDamage)
          baseDamage = 1;
        baseDamage = this.battle.runEvent("ModifyDamage", pokemon, target, move, baseDamage);
        if (move.isZOrMaxPowered && target.getMoveHitData(move).zBrokeProtect) {
          baseDamage = this.battle.modify(baseDamage, 0.25);
          this.battle.add("-zbroken", target);
        }
        if (this.battle.gen !== 5 && !baseDamage)
          return 1;
        return tr(baseDamage, 16);
      }
    },
    pokemon: {
      getTypes(excludeAdded, preterastallized) {
        if (!preterastallized && this.terastallized && this.terastallized !== "Stellar") {
          return [this.terastallized];
        }
        const types = this.battle.runEvent("Type", this, null, null, this.types);
        if (!excludeAdded && this.addedType)
          return types.concat(this.addedType);
        const addTeraType = this.m.thirdType;
        if (types.length) {
          if (addTeraType)
            return Array.from(/* @__PURE__ */ new Set([...types, addTeraType]));
          return types;
        }
        return [this.battle.gen >= 5 ? "Normal" : "???"];
      },
      runEffectiveness(move) {
        if ((this.terastallized || this.m.thirdType) && move.type === "Stellar")
          return 1;
        let totalTypeMod = 0;
        for (const type of this.getTypes()) {
          let typeMod = this.battle.dex.getEffectiveness(move, type);
          typeMod = this.battle.singleEvent("Effectiveness", move, null, this, type, move, typeMod);
          totalTypeMod += this.battle.runEvent("Effectiveness", this, type, move, typeMod);
        }
        return totalTypeMod;
      }
    }
  },
  {
    name: "[Gen 9] The Card Game",
    desc: `The type chart is simplified based off of the Pok&eacute;mon Trading Card Game.`,
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3716838/">The Card Game</a>`
    ],
    mod: "thecardgame",
    searchShow: false,
    ruleset: ["Standard OMs", "Sleep Moves Clause", "Evasion Abilities Clause", "Evasion Items Clause", "Terastal Clause", "Min Source Gen = 9"],
    banlist: [
      "Annihilape",
      "Arceus",
      "Baxcalibur",
      "Calyrex-Ice",
      "Calyrex-Shadow",
      "Chi-Yu",
      "Chien-Pao",
      "Deoxys-Base",
      "Deoxys-Attack",
      "Dialga",
      "Dialga-Origin",
      "Dragapult",
      "Dragonite",
      "Dudunsparce",
      "Eternatus",
      "Garchomp",
      "Giratina",
      "Giratina-Origin",
      "Gouging Fire",
      "Groudon",
      "Haxorus",
      "Ho-Oh",
      "Hydreigon",
      "Iron Valiant",
      "Kommo-o",
      "Koraidon",
      "Kyogre",
      "Kyurem",
      "Kyurem-Black",
      "Kyurem-White",
      "Landorus-Base",
      "Latias",
      "Latios",
      "Lugia",
      "Lunala",
      "Mewtwo",
      "Miraidon",
      "Necrozma-Dawn-Wings",
      "Necrozma-Dusk-Mane",
      "Noivern",
      "Palafin",
      "Palkia",
      "Palkia-Origin",
      "Rayquaza",
      "Regidrago",
      "Regieleki",
      "Reshiram",
      "Roaring Moon",
      "Salamence",
      "Shaymin-Sky",
      "Solgaleo",
      "Ursaluna",
      "Ursaluna-Bloodmoon",
      "Urshifu-Base",
      "Walking Wake",
      "Zacian",
      "Zacian-Crowned",
      "Zekrom",
      "Arena Trap",
      "Moody",
      "Shadow Tag",
      "Baton Pass",
      "Last Respects",
      "Shed Tail"
    ],
    onBegin() {
      for (const pokemon of this.getAllPokemon()) {
        pokemon.hpType = pokemon.hpType.replace(/(Ghost|Fairy)/g, "Psychic").replace(/Bug/g, "Grass").replace(/Ice/g, "Water").replace(/(Rock|Ground)/g, "Fighting").replace(/Flying/g, "Normal").replace(/Poison/g, "Dark");
        pokemon.teraType = pokemon.teraType.replace(/(Ghost|Fairy)/g, "Psychic").replace(/Bug/g, "Grass").replace(/Ice/g, "Water").replace(/(Rock|Ground)/g, "Fighting").replace(/Flying/g, "Normal").replace(/Poison/g, "Dark");
      }
    },
    onSwitchIn(pokemon) {
      this.add("-start", pokemon, "typechange", (pokemon.illusion || pokemon).getTypes(true).join("/"), "[silent]");
      pokemon.apparentType = pokemon.getTypes(true).join("/");
    },
    onAfterMega(pokemon) {
      this.add("-start", pokemon, "typechange", (pokemon.illusion || pokemon).getTypes(true).join("/"), "[silent]");
      pokemon.apparentType = pokemon.getTypes(true).join("/");
    }
  },
  {
    name: "[Gen 9] The Loser's Game",
    desc: `The first player to lose all of their Pok&eacute;mon wins.`,
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3714223/">The Loser's Game</a>`
    ],
    mod: "gen9",
    searchShow: false,
    ruleset: ["Standard OMs", "Sleep Clause Mod", "!OHKO Clause", "Picked Team Size = 6", "Adjust Level = 100", "Min Source Gen = 9"],
    banlist: ["Infiltrator", "Choice Scarf", "Explosion", "Final Gambit", "Healing Wish", "Lunar Dance", "Magic Room", "Memento", "Misty Explosion", "Self-Destruct"],
    onValidateTeam(team) {
      const familyTable = /* @__PURE__ */ new Set();
      for (const set of team) {
        let species = this.dex.species.get(set.species);
        while (species.prevo) {
          species = this.dex.species.get(species.prevo);
        }
        if (familyTable.has(species.id)) {
          return [
            `You are limited to one Pok&eacute;mon from each family by the Family Clause.`,
            `(You have more than one evolution of ${species.name}.)`
          ];
        }
        familyTable.add(species.id);
      }
    },
    battle: {
      tiebreak() {
        if (this.ended)
          return false;
        this.inputLog.push(`>tiebreak`);
        this.add("message", "Time's up! Going to tiebreaker...");
        const notFainted = this.sides.map((side) => side.pokemon.filter((pokemon) => !pokemon.fainted).length);
        this.add("-message", this.sides.map((side, i) => `${side.name}: ${notFainted[i]} Pokemon left`).join("; "));
        const maxNotFainted = Math.max(...notFainted);
        let tiedSides = this.sides.filter((side, i) => notFainted[i] === maxNotFainted);
        if (tiedSides.length <= 1) {
          return this.win(tiedSides[1]);
        }
        const hpPercentage = tiedSides.map((side) => side.pokemon.map((pokemon) => pokemon.hp / pokemon.maxhp).reduce((a, b) => a + b) * 100 / 6);
        this.add("-message", tiedSides.map((side, i) => `${side.name}: ${Math.round(hpPercentage[i])}% total HP left`).join("; "));
        const maxPercentage = Math.max(...hpPercentage);
        tiedSides = tiedSides.filter((side, i) => hpPercentage[i] === maxPercentage);
        if (tiedSides.length <= 1) {
          return this.win(tiedSides[1]);
        }
        const hpTotal = tiedSides.map((side) => side.pokemon.map((pokemon) => pokemon.hp).reduce((a, b) => a + b));
        this.add("-message", tiedSides.map((side, i) => `${side.name}: ${Math.round(hpTotal[i])} total HP left`).join("; "));
        const maxTotal = Math.max(...hpTotal);
        tiedSides = tiedSides.filter((side, i) => hpTotal[i] === maxTotal);
        if (tiedSides.length <= 1) {
          return this.win(tiedSides[1]);
        }
        return this.tie();
      },
      checkWin(faintData) {
        const team1PokemonLeft = this.sides[0].pokemonLeft;
        const team2PokemonLeft = this.sides[1].pokemonLeft;
        if (!team1PokemonLeft && !team2PokemonLeft) {
          this.win(faintData?.target.side || null);
          return true;
        }
        for (const side of this.sides) {
          if (!side.pokemonLeft) {
            this.win(side);
            return true;
          }
        }
      }
    }
  },
  {
    name: "[Gen 9] Trademarked",
    desc: `Sacrifice your Pok&eacute;mon's ability for a status move that activates on switch-in.`,
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3714688/">Trademarked</a>`
    ],
    mod: "trademarked",
    searchShow: false,
    ruleset: ["Standard OMs", "Sleep Moves Clause", "Min Source Gen = 9"],
    banlist: [
      "Arceus",
      "Calyrex-Ice",
      "Calyrex-Shadow",
      "Dialga",
      "Dialga-Origin",
      "Eternatus",
      "Flutter Mane",
      "Giratina",
      "Giratina-Origin",
      "Groudon",
      "Koraidon",
      "Kyogre",
      "Landorus-Base",
      "Magearna",
      "Mewtwo",
      "Miraidon",
      "Palkia",
      "Palkia-Origin",
      "Rayquaza",
      "Slaking",
      "Spectrier",
      "Urshifu-Base",
      "Zacian",
      "Zacian-Crowned",
      "Arena Trap",
      "Magnet Pull",
      "Moody",
      "Shadow Tag",
      "Baton Pass",
      "Last Respects",
      "Revival Blessing"
    ],
    restricted: [
      "Baneful Bunker",
      "Block",
      "Chilly Reception",
      "Copycat",
      "Detect",
      "Destiny Bond",
      "Encore",
      "Fairy Lock",
      "Ingrain",
      "Instruct",
      "Mean Look",
      "move:Metronome",
      "Nasty Plot",
      "Parting Shot",
      "Protect",
      "Roar",
      "Silk Trap",
      "Spiky Shield",
      "Sleep Talk",
      "Shed Tail",
      "Shell Smash",
      "Substitute",
      "Swords Dance",
      "Teleport",
      "Thunder Wave",
      "Trick Room",
      "Will-O-Wisp",
      "Whirlwind"
    ],
    onValidateTeam(team, format, teamHas) {
      const problems = [];
      for (const trademark in teamHas.trademarks) {
        if (teamHas.trademarks[trademark] > 1) {
          problems.push(`You are limited to 1 of each Trademark.`, `(You have ${teamHas.trademarks[trademark]} Pok\xE9mon with ${trademark} as a Trademark.)`);
        }
      }
      return problems;
    },
    validateSet(set, teamHas) {
      const dex = this.dex;
      const ability = dex.moves.get(set.ability);
      if (!ability.exists) {
        return this.validateSet(set, teamHas);
      }
      if (ability.category !== "Status") {
        return [`${ability.name} is not a status move and cannot be used as a trademark.`];
      }
      if (this.ruleTable.isRestricted(`move:${ability.id}`)) {
        return [`${ability.name} is restricted from being used as a trademark.`];
      }
      if (set.moves.map(this.toID).includes(ability.id)) {
        return [`${set.name} may not use ${ability.name} as both a trademark and one of its moves simultaneously.`];
      }
      const customRules = this.format.customRules || [];
      if (!customRules.includes("!obtainableabilities"))
        customRules.push("!obtainableabilities");
      if (!customRules.includes("+noability"))
        customRules.push("+noability");
      const TeamValidator = require("../sim/team-validator").TeamValidator;
      const validator = new TeamValidator(dex.formats.get(`${this.format.id}@@@${customRules.join(",")}`));
      const moves = set.moves;
      set.moves = [ability.id];
      set.ability = "No Ability";
      let problems = validator.validateSet(set, {}) || [];
      if (problems.length)
        return problems;
      set.moves = moves;
      set.ability = "No Ability";
      problems = problems.concat(validator.validateSet(set, teamHas) || []);
      set.ability = ability.id;
      if (!teamHas.trademarks)
        teamHas.trademarks = {};
      teamHas.trademarks[ability.name] = (teamHas.trademarks[ability.name] || 0) + 1;
      return problems.length ? problems : null;
    }
  },
  {
    name: "[Gen 6] Pure Hackmons",
    desc: `Anything that can be hacked in-game and is usable in local battles is allowed.`,
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/posts/9029427/">ORAS Pure Hackmons</a>`
    ],
    mod: "gen6",
    searchShow: false,
    ruleset: ["-Nonexistent", "Team Preview", "HP Percentage Mod", "Cancel Mod", "Endless Battle Clause", "EV limit = 510"]
  },
  // National Dex
  ///////////////////////////////////////////////////////////////////
  {
    section: "National Dex"
  },
  {
    name: "[Gen 9] National Dex",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3710848/">National Dex Metagame Discussion</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3714511/">National Dex Viability Rankings</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3714863/">National Dex Sample Teams</a>`
    ],
    mod: "gen9",
    ruleset: ["Standard NatDex", "OHKO Clause", "Evasion Clause", "Species Clause", "Sleep Clause Mod"],
    banlist: [
      "ND Uber",
      "ND AG",
      "Arena Trap",
      "Moody",
      "Power Construct",
      "Shadow Tag",
      "King's Rock",
      "Quick Claw",
      "Razor Fang",
      "Assist",
      "Baton Pass",
      "Last Respects",
      "Shed Tail"
    ]
  },
  {
    name: "[Gen 9] National Dex Ubers",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3712168/">National Dex Ubers Metagame Discussion</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3712170/">National Dex Ubers Sample Teams</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3712169/">National Dex Ubers Viability Rankings</a>`
    ],
    mod: "gen9",
    ruleset: ["Standard NatDex", "OHKO Clause", "Evasion Moves Clause", "Evasion Items Clause", "Species Clause", "Sleep Clause Mod", "Mega Rayquaza Clause"],
    banlist: ["ND AG", "Assist", "Baton Pass"]
  },
  {
    name: "[Gen 9] National Dex UU",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3711752/">National Dex UU Metagame Discussion</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3719079/">National Dex UU Viability Rankings</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3725988/">National Dex UU Sample Teams</a>`
    ],
    mod: "gen9",
    ruleset: ["[Gen 9] National Dex", "Terastal Clause"],
    banlist: ["ND OU", "ND UUBL", "Battle Bond", "Drizzle", "Drought", "Light Clay"]
  },
  {
    name: "[Gen 9] National Dex RU",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3713801/">National Dex RU Metagame Discussion</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3721776/">National Dex RU Resources</a>`
    ],
    mod: "gen9",
    // searchShow: false,
    ruleset: ["[Gen 9] National Dex UU"],
    banlist: ["ND UU", "ND RUBL", "Slowbro-Base + Slowbronite", "Heat Rock"]
  },
  {
    name: "[Gen 9] National Dex Monotype",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3710738/">National Dex Monotype Metagame Discussion</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3716842/">National Dex Monotype Sample Teams</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3715785/">National Dex Monotype Viability Rankings</a>`
    ],
    mod: "gen9",
    ruleset: ["Standard NatDex", "Same Type Clause", "Terastal Clause", "Species Clause", "OHKO Clause", "Evasion Clause", "Sleep Clause Mod"],
    banlist: [
      "Annihilape",
      "Arceus",
      "Baxcalibur",
      "Blastoise-Mega",
      "Blaziken",
      "Blaziken-Mega",
      "Calyrex-Ice",
      "Calyrex-Shadow",
      "Chi-Yu",
      "Chien-Pao",
      "Darkrai",
      "Deoxys-Base",
      "Deoxys-Attack",
      "Dialga",
      "Dracovish",
      "Dragapult",
      "Espathra",
      "Eternatus",
      "Flutter Mane",
      "Genesect",
      "Gengar-Mega",
      "Giratina",
      "Giratina-Origin",
      "Gouging Fire",
      "Groudon",
      "Ho-Oh",
      "Hoopa-Unbound",
      "Iron Bundle",
      "Kangaskhan-Mega",
      "Kartana",
      "Kingambit",
      "Koraidon",
      "Kyogre",
      "Kyurem-Black",
      "Kyurem-White",
      "Lucario-Mega",
      "Lugia",
      "Lunala",
      "Magearna",
      "Marshadow",
      "Mawile-Mega",
      "Medicham-Mega",
      "Metagross-Mega",
      "Mewtwo",
      "Miraidon",
      "Naganadel",
      "Necrozma-Dawn-Wings",
      "Necrozma-Dusk-Mane",
      "Ogerpon-Hearthflame",
      "Palafin",
      "Palkia",
      "Pheromosa",
      "Rayquaza",
      "Reshiram",
      "Salamence-Mega",
      "Shaymin-Sky",
      "Solgaleo",
      "Spectrier",
      "Ursaluna-Bloodmoon",
      "Urshifu-Base",
      "Xerneas",
      "Yveltal",
      "Zacian",
      "Zacian-Crowned",
      "Zamazenta",
      "Zamazenta-Crowned",
      "Zekrom",
      "Zygarde-Base",
      "Zygarde-Complete",
      "Moody",
      "Shadow Tag",
      "Power Construct",
      "Booster Energy",
      "Damp Rock",
      "Focus Band",
      "Icy Rock",
      "King's Rock",
      "Leppa Berry",
      "Quick Claw",
      "Razor Fang",
      "Smooth Rock",
      "Terrain Extender",
      "Acupressure",
      "Baton Pass",
      "Last Respects",
      "Shed Tail"
    ]
  },
  {
    name: "[Gen 9] National Dex Doubles",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3720802/">National Dex Doubles Metagame Discussion</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3726341/">National Dex Doubles Resources</a>`
    ],
    mod: "gen9",
    gameType: "doubles",
    ruleset: ["Standard NatDex", "OHKO Clause", "Evasion Moves Clause", "Evasion Abilities Clause", "Species Clause", "Gravity Sleep Clause"],
    banlist: [
      "Annihilape",
      "Arceus",
      "Calyrex-Ice",
      "Calyrex-Shadow",
      "Dialga",
      "Dialga-Origin",
      "Eternatus",
      "Genesect",
      "Gengar-Mega",
      "Giratina",
      "Giratina-Origin",
      "Groudon",
      "Ho-Oh",
      "Koraidon",
      "Kyogre",
      "Kyurem-White",
      "Lugia",
      "Lunala",
      "Magearna",
      "Melmetal",
      "Mewtwo",
      "Miraidon",
      "Necrozma-Dawn-Wings",
      "Necrozma-Dusk-Mane",
      "Palkia",
      "Palkia-Origin",
      "Rayquaza",
      "Reshiram",
      "Shedinja",
      "Solgaleo",
      "Terapagos",
      "Urshifu",
      "Urshifu-Rapid-Strike",
      "Xerneas",
      "Yveltal",
      "Zacian",
      "Zacian-Crowned",
      "Zamazenta-Crowned",
      "Zekrom",
      "Commander",
      "Power Construct",
      "Assist",
      "Coaching",
      "Dark Void",
      "Swagger"
    ]
  },
  {
    name: "[Gen 9] National Dex AG",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3672423/">National Dex AG</a>`
    ],
    mod: "gen9",
    searchShow: false,
    ruleset: ["Standard NatDex"]
  },
  {
    name: "[Gen 9] National Dex BH",
    desc: `Balanced Hackmons with National Dex elements mixed in.`,
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3711099/">National Dex BH</a>`
    ],
    mod: "gen9",
    searchShow: false,
    ruleset: ["-Nonexistent", "Standard NatDex", "Forme Clause", "Sleep Moves Clause", "Ability Clause = 2", "OHKO Clause", "Evasion Moves Clause", "Dynamax Clause", "CFZ Clause", "Terastal Clause", "!Obtainable"],
    banlist: [
      "Cramorant-Gorging",
      "Calyrex-Shadow",
      "Darmanitan-Galar-Zen",
      "Eternatus-Eternamax",
      "Groudon-Primal",
      "Rayquaza-Mega",
      "Shedinja",
      "Arena Trap",
      "Contrary",
      "Gorilla Tactics",
      "Huge Power",
      "Illusion",
      "Innards Out",
      "Magnet Pull",
      "Moody",
      "Neutralizing Gas",
      "Parental Bond",
      "Pure Power",
      "Shadow Tag",
      "Stakeout",
      "Water Bubble",
      "Wonder Guard",
      "Gengarite",
      "Berserk Gene",
      "Belly Drum",
      "Bolt Beak",
      "Chatter",
      "Double Iron Bash",
      "Electrify",
      "Last Respects",
      "Octolock",
      "Rage Fist",
      "Revival Blessing",
      "Shed Tail",
      "Shell Smash",
      "Comatose + Sleep Talk",
      "Imprison + Transform"
    ],
    restricted: ["Arceus"],
    onValidateTeam(team, format) {
      const restrictedPokemonCount = /* @__PURE__ */ new Map();
      for (const set of team) {
        const species = this.dex.species.get(set.species);
        if (!this.ruleTable.isRestrictedSpecies(species))
          continue;
        restrictedPokemonCount.set(species.baseSpecies, (restrictedPokemonCount.get(species.baseSpecies) || 0) + 1);
      }
      for (const [baseSpecies, count] of restrictedPokemonCount) {
        if (count > 1) {
          return [
            `You are limited to one ${baseSpecies} forme.`,
            `(You have ${count} ${baseSpecies} forme${count === 1 ? "" : "s"}.)`
          ];
        }
      }
    }
  },
  {
    name: "[Gen 8] National Dex",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3666135/">SS National Dex Metagame Discussion</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3667921/">SS National Dex Sample Teams</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3666572/">SS National Dex Viability Rankings</a>`
    ],
    mod: "gen8",
    ruleset: ["Standard NatDex", "OHKO Clause", "Evasion Clause", "Species Clause", "Dynamax Clause", "Sleep Clause Mod"],
    banlist: ["ND Uber", "Arena Trap", "Moody", "Power Construct", "Shadow Tag", "King's Rock", "Razor Fang", "Quick Claw", "Baton Pass"]
  },
  {
    name: "[Gen 8] National Dex UU",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3660920/">SS National Dex UU Metagame Discussion</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3672486/">SS National Dex UU Sample Teams</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3672482/">SS National Dex UU Viability Rankings</a>`
    ],
    mod: "gen8",
    searchShow: false,
    ruleset: ["[Gen 8] National Dex"],
    banlist: ["ND OU", "ND UUBL", "Drizzle", "Drought", "Light Clay", "Slowbronite"]
  },
  {
    name: "[Gen 8] National Dex Monotype",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3715484/">SS National Dex Monotype</a>`
    ],
    mod: "gen8",
    searchShow: false,
    ruleset: ["Standard NatDex", "Same Type Clause", "Species Clause", "OHKO Clause", "Evasion Moves Clause", "Evasion Items Clause", "Dynamax Clause", "Sleep Clause Mod"],
    banlist: [
      "Arceus",
      "Blastoise-Mega",
      "Blaziken",
      "Blaziken-Mega",
      "Calyrex-Ice",
      "Calyrex-Shadow",
      "Darkrai",
      "Deoxys-Base",
      "Deoxys-Attack",
      "Dialga",
      "Dracovish",
      "Dragapult",
      "Eternatus",
      "Genesect",
      "Gengar-Mega",
      "Giratina",
      "Giratina-Origin",
      "Greninja-Bond",
      "Greninja-Ash",
      "Groudon",
      "Ho-Oh",
      "Hoopa-Unbound",
      "Kangaskhan-Mega",
      "Kartana",
      "Kyogre",
      "Kyurem-Black",
      "Kyurem-White",
      "Lucario-Mega",
      "Lugia",
      "Lunala",
      "Magearna",
      "Marshadow",
      "Mawile-Mega",
      "Medicham-Mega",
      "Metagross-Mega",
      "Mewtwo",
      "Moltres-Galar",
      "Naganadel",
      "Necrozma-Dawn-Wings",
      "Necrozma-Dusk-Mane",
      "Palkia",
      "Pheromosa",
      "Rayquaza",
      "Reshiram",
      "Salamence-Mega",
      "Shaymin-Sky",
      "Solgaleo",
      "Spectrier",
      "Urshifu-Base",
      "Xerneas",
      "Yveltal",
      "Zacian",
      "Zacian-Crowned",
      "Zamazenta",
      "Zamazenta-Crowned",
      "Zekrom",
      "Zygarde-Base",
      "Zygarde-Complete",
      "Battle Bond",
      "Power Construct",
      "Moody",
      "Shadow Tag",
      "Damp Rock",
      "Focus Band",
      "King's Rock",
      "Quick Claw",
      "Razor Fang",
      "Smooth Rock",
      "Terrain Extender",
      "Baton Pass"
    ]
  },
  // S/V DLC 1
  ///////////////////////////////////////////////////////////////////
  {
    section: "S/V DLC 1"
  },
  {
    name: "[Gen 9 DLC 1] OU",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3727806/">SV OU Metagame Discussion</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3712513/">SV OU Sample Teams</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3729909/">SV OU Viability Rankings</a>`
    ],
    mod: "gen9dlc1",
    searchShow: false,
    ruleset: ["Standard"],
    banlist: ["Uber", "AG", "Arena Trap", "Moody", "Sand Veil", "Shadow Tag", "Snow Cloak", "King's Rock", "Razor Fang", "Baton Pass", "Last Respects", "Shed Tail"]
  },
  {
    name: "[Gen 9 DLC 1] Ubers",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3727902/">Ubers Metagame Discussion</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3724082/">Ubers Viability Rankings</a>`
    ],
    mod: "gen9dlc1",
    searchShow: false,
    ruleset: ["Standard"],
    banlist: ["AG", "Moody", "King's Rock", "Razor Fang", "Baton Pass"]
  },
  {
    name: "[Gen 9 DLC 1] UU",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3728797/">UU Metagame Discussion</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3729854/">UU Viability Rankings</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3720278/">UU Sample Teams</a>`
    ],
    mod: "gen9dlc1",
    searchShow: false,
    ruleset: ["[Gen 9 DLC 1] OU"],
    banlist: ["OU", "UUBL"]
  },
  {
    name: "[Gen 9 DLC 1] RU",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3725482/">RU Metagame Discussion</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3729823/">RU Viability Rankings</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3717072/">RU Sample Teams</a>`
    ],
    mod: "gen9dlc1",
    searchShow: false,
    ruleset: ["[Gen 9 DLC 1] UU"],
    banlist: ["UU", "RUBL", "Light Clay"]
  },
  {
    name: "[Gen 9 DLC 1] NU",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3715408/">NU Metagame Discussion</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3729943/">NU Viability Rankings</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3730216/">NU Sample Teams</a>`
    ],
    mod: "gen9dlc1",
    searchShow: false,
    ruleset: ["[Gen 9 DLC 1] RU"],
    banlist: ["RU", "NUBL"]
  },
  {
    name: "[Gen 9 DLC 1] PU",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3729623/">PU Viability Rankings</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3719989/">PU Sample Teams</a>`
    ],
    mod: "gen9dlc1",
    searchShow: false,
    ruleset: ["[Gen 9 DLC 1] NU"],
    banlist: ["NU", "PUBL", "Damp Rock", "Heat Rock"]
  },
  {
    name: "[Gen 9 DLC 1] LC",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3710868/">Little Cup Metagame Discussion</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3712989/">Little Cup Sample Teams</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3712664/">Little Cup Viability Rankings</a>`
    ],
    mod: "gen9dlc1",
    searchShow: false,
    ruleset: ["Little Cup", "Standard"],
    banlist: [
      "Aipom",
      "Basculin-White-Striped",
      "Cutiefly",
      "Diglett-Base",
      "Dunsparce",
      "Flittle",
      "Gastly",
      "Girafarig",
      "Gligar",
      "Growlithe-Hisui",
      "Meditite",
      "Misdreavus",
      "Murkrow",
      "Qwilfish-Hisui",
      "Rufflet",
      "Scyther",
      "Sneasel",
      "Sneasel-Hisui",
      "Stantler",
      "Vulpix",
      "Vulpix-Alola",
      "Yanma",
      "Moody",
      "Baton Pass",
      "Sticky Web"
    ]
  },
  {
    name: "[Gen 9 DLC 1] Monotype",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3727849/">Monotype Metagame Discussion</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3727976/">Monotype Sample Teams</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3729937/">Monotype Viability Rankings</a>`
    ],
    mod: "gen9dlc1",
    searchShow: false,
    ruleset: ["Standard", "Evasion Abilities Clause", "Same Type Clause", "Terastal Clause"],
    banlist: [
      "Annihilape",
      "Arceus",
      "Calyrex-Ice",
      "Calyrex-Shadow",
      "Chi-Yu",
      "Dialga",
      "Dialga-Origin",
      "Eternatus",
      "Giratina",
      "Giratina-Origin",
      "Groudon",
      "Iron Bundle",
      "Koraidon",
      "Kyogre",
      "Magearna",
      "Mewtwo",
      "Miraidon",
      "Palafin",
      "Palkia",
      "Palkia-Origin",
      "Rayquaza",
      "Shaymin-Sky",
      "Urshifu-Base",
      "Zacian",
      "Zacian-Crowned",
      "Zamazenta-Crowned",
      "Moody",
      "Shadow Tag",
      "Booster Energy",
      "Damp Rock",
      "Focus Band",
      "King's Rock",
      "Razor Fang",
      "Quick Claw",
      "Acupressure",
      "Baton Pass",
      "Last Respects"
    ]
  },
  {
    name: "[Gen 9 DLC 1] Doubles OU",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3710876/">Doubles OU Sample Teams</a>`
    ],
    mod: "gen9dlc1",
    searchShow: false,
    gameType: "doubles",
    ruleset: ["Standard Doubles"],
    banlist: ["DUber", "Shadow Tag"]
  },
  {
    name: "[Gen 9 DLC 1] Doubles UU",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3712825/">Doubles UU</a>`
    ],
    mod: "gen9dlc1",
    searchShow: false,
    gameType: "doubles",
    ruleset: ["[Gen 9 DLC 1] Doubles OU", "Evasion Abilities Clause"],
    banlist: ["DOU", "DBL"]
  },
  {
    name: "[Gen 9 DLC 1] Doubles LC",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3710957/">Doubles LC</a>`
    ],
    mod: "gen9dlc1",
    gameType: "doubles",
    searchShow: false,
    ruleset: ["Standard Doubles", "Little Cup", "Sleep Clause Mod"],
    banlist: ["Basculin-White-Striped", "Dunsparce", "Gligar", "Murkrow", "Qwilfish-Hisui", "Scyther", "Sneasel", "Sneasel-Hisui", "Vulpix", "Vulpix-Alola", "Yanma"]
  },
  {
    name: "[Gen 9 DLC 1] 1v1",
    desc: `Bring three Pok&eacute;mon to Team Preview and choose one to battle.`,
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3710864/">1v1 Metagame Discussion</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3712375/">1v1 Viability Rankings</a>`
    ],
    mod: "gen9dlc1",
    searchShow: false,
    ruleset: [
      "Picked Team Size = 1",
      "Max Team Size = 3",
      "Standard",
      "Terastal Clause",
      "Sleep Moves Clause",
      "Accuracy Moves Clause",
      "!Sleep Clause Mod"
    ],
    banlist: [
      "Arceus",
      "Calyrex-Ice",
      "Calyrex-Shadow",
      "Chi-Yu",
      "Cinderace",
      "Dialga",
      "Dialga-Origin",
      "Dragonite",
      "Eternatus",
      "Flutter Mane",
      "Gholdengo",
      "Giratina",
      "Giratina-Origin",
      "Groudon",
      "Hoopa-Unbound",
      "Jirachi",
      "Koraidon",
      "Kyogre",
      "Magearna",
      "Meloetta",
      "Mew",
      "Mewtwo",
      "Mimikyu",
      "Miraidon",
      "Ogerpon-Cornerstone",
      "Palkia",
      "Palkia-Origin",
      "Rayquaza",
      "Scream Tail",
      "Shaymin-Sky",
      "Snorlax",
      "Zacian",
      "Zacian-Crowned",
      "Zamazenta",
      "Zamazenta-Crowned",
      "Moody",
      "Focus Band",
      "Focus Sash",
      "King's Rock",
      "Razor Fang",
      "Quick Claw",
      "Acupressure",
      "Perish Song"
    ]
  },
  {
    name: "[Gen 9 DLC 1] Anything Goes",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3722196/">AG Metagame Discussion</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3724219/">AG Viability Rankings</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3727176/">AG Sample Teams</a>`
    ],
    mod: "gen9dlc1",
    searchShow: false,
    ruleset: ["Min Source Gen = 9", "Obtainable", "Team Preview", "HP Percentage Mod", "Cancel Mod", "Endless Battle Clause"]
  },
  {
    name: "[Gen 9 DLC 1] ZU",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3719022/">ZU Metagame Discussion</a>`
    ],
    mod: "gen9dlc1",
    searchShow: false,
    ruleset: ["[Gen 9 DLC 1] PU"],
    banlist: ["PU", "ZUBL"]
  },
  {
    name: "[Gen 9 DLC 1] National Dex",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3710848/">National Dex Metagame Discussion</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3714511/">National Dex Viability Rankings</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3714863/">National Dex Sample Teams</a>`
    ],
    mod: "gen9dlc1",
    searchShow: false,
    ruleset: ["Standard NatDex", "OHKO Clause", "Evasion Clause", "Species Clause", "Sleep Clause Mod"],
    banlist: [
      "ND Uber",
      "ND AG",
      "Arena Trap",
      "Moody",
      "Power Construct",
      "Shadow Tag",
      "King's Rock",
      "Quick Claw",
      "Razor Fang",
      "Assist",
      "Baton Pass",
      "Last Respects",
      "Shed Tail"
    ]
  },
  {
    name: "[Gen 9 DLC 1] National Dex Monotype",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3710738/">National Dex Monotype Metagame Discussion</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3716842/">National Dex Monotype Sample Teams</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3715785/">National Dex Monotype Viability Rankings</a>`
    ],
    mod: "gen9dlc1",
    searchShow: false,
    ruleset: ["Standard NatDex", "Same Type Clause", "Terastal Clause", "Species Clause", "OHKO Clause", "Evasion Clause", "Sleep Clause Mod"],
    banlist: [
      "Annihilape",
      "Arceus",
      "Baxcalibur",
      "Blastoise-Mega",
      "Blaziken",
      "Blaziken-Mega",
      "Calyrex-Ice",
      "Calyrex-Shadow",
      "Chi-Yu",
      "Chien-Pao",
      "Darkrai",
      "Deoxys-Base",
      "Deoxys-Attack",
      "Dialga",
      "Dracovish",
      "Dragapult",
      "Espathra",
      "Eternatus",
      "Flutter Mane",
      "Genesect",
      "Gengar-Mega",
      "Giratina",
      "Giratina-Origin",
      "Groudon",
      "Ho-Oh",
      "Hoopa-Unbound",
      "Iron Bundle",
      "Kangaskhan-Mega",
      "Kartana",
      "Kingambit",
      "Koraidon",
      "Kyogre",
      "Kyurem-Black",
      "Kyurem-White",
      "Lucario-Mega",
      "Lugia",
      "Lunala",
      "Magearna",
      "Marshadow",
      "Mawile-Mega",
      "Medicham-Mega",
      "Metagross-Mega",
      "Mewtwo",
      "Miraidon",
      "Naganadel",
      "Necrozma-Dawn-Wings",
      "Necrozma-Dusk-Mane",
      "Ogerpon-Hearthflame",
      "Palafin",
      "Palkia",
      "Pheromosa",
      "Rayquaza",
      "Reshiram",
      "Salamence-Mega",
      "Shaymin-Sky",
      "Solgaleo",
      "Spectrier",
      "Urshifu-Base",
      "Xerneas",
      "Yveltal",
      "Zacian",
      "Zacian-Crowned",
      "Zamazenta",
      "Zamazenta-Crowned",
      "Zekrom",
      "Zygarde-Base",
      "Zygarde-Complete",
      "Moody",
      "Shadow Tag",
      "Power Construct",
      "Booster Energy",
      "Damp Rock",
      "Focus Band",
      "Icy Rock",
      "King's Rock",
      "Leppa Berry",
      "Quick Claw",
      "Razor Fang",
      "Smooth Rock",
      "Terrain Extender",
      "Acupressure",
      "Baton Pass",
      "Last Respects"
    ]
  },
  {
    name: "[Gen 9 DLC 1] National Dex Doubles",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3720802/">National Dex Doubles Metagame Discussion</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3726341/">National Dex Doubles Resources</a>`
    ],
    mod: "gen9dlc1",
    searchShow: false,
    gameType: "doubles",
    ruleset: ["Standard NatDex", "OHKO Clause", "Evasion Moves Clause", "Evasion Abilities Clause", "Species Clause", "Gravity Sleep Clause"],
    banlist: [
      "Annihilape",
      "Arceus",
      "Calyrex-Ice",
      "Calyrex-Shadow",
      "Dialga",
      "Dialga-Origin",
      "Eternatus",
      "Genesect",
      "Gengar-Mega",
      "Giratina",
      "Giratina-Origin",
      "Groudon",
      "Ho-Oh",
      "Koraidon",
      "Kyogre",
      "Kyurem-White",
      "Lugia",
      "Lunala",
      "Magearna",
      "Melmetal",
      "Mewtwo",
      "Miraidon",
      "Necrozma-Dawn-Wings",
      "Necrozma-Dusk-Mane",
      "Palkia",
      "Palkia-Origin",
      "Rayquaza",
      "Reshiram",
      "Shedinja",
      "Solgaleo",
      "Urshifu-Base",
      "Xerneas",
      "Yveltal",
      "Zacian",
      "Zacian-Crowned",
      "Zamazenta-Crowned",
      "Zekrom",
      "Commander",
      "Power Construct",
      "Assist",
      "Dark Void",
      "Swagger"
    ]
  },
  {
    name: "[Gen 9 DLC 1] Draft",
    mod: "gen9dlc1",
    searchShow: false,
    ruleset: ["Standard Draft", "Min Source Gen = 9"]
  },
  {
    name: "[Gen 9 DLC 1] Tera Preview Draft",
    mod: "gen9dlc1",
    searchShow: false,
    ruleset: ["[Gen 9 DLC 1] Draft", "Tera Type Preview"]
  },
  // Randomized Format Spotlight
  ///////////////////////////////////////////////////////////////////
  {
    section: "Randomized Format Spotlight",
    column: 3
  },
  {
    name: "[Gen 6] First Blood Random Battle",
    desc: `The first team to have a Pok&eacute;mon faint loses.`,
    mod: "gen6",
    team: "random",
    ruleset: ["[Gen 6] Random Battle", "First Blood Rule"]
  },
  {
    name: "[Gen 9] Random Roulette",
    desc: `Random Battles in a random generation! [Gen 1] Random Battle - [Gen 9] Random Battle.`,
    mod: "randomroulette",
    team: "random",
    searchShow: false
  },
  // Randomized Metas
  ///////////////////////////////////////////////////////////////////
  {
    section: "Randomized Metas",
    column: 3
  },
  {
    name: "[Gen 9] Monotype Random Battle",
    mod: "gen9",
    team: "random",
    ruleset: ["Obtainable", "Same Type Clause", "HP Percentage Mod", "Cancel Mod", "Sleep Clause Mod", "Illusion Level Mod"]
  },
  {
    name: "[Gen 9] Random Battle Mayhem",
    desc: `[Gen 9] Random Battle with Team Preview and elements of Camomons, Inverse, Scalemons, and Shared Power.`,
    mod: "sharedpower",
    team: "random",
    ruleset: ["[Gen 9] Random Battle", "Team Preview", "Camomons Mod", "Inverse Mod", "Scalemons Mod"],
    onValidateRule() {
      if (this.format.gameType !== "singles") {
        throw new Error(`Shared Power currently does not support ${this.format.gameType} battles.`);
      }
    },
    onBeforeSwitchIn(pokemon) {
      let format = this.format;
      if (!format.getSharedPower)
        format = this.dex.formats.get("gen9sharedpower");
      for (const ability of format.getSharedPower(pokemon)) {
        const effect = "ability:" + ability;
        pokemon.volatiles[effect] = { id: this.toID(effect), target: pokemon };
        if (!pokemon.m.abils)
          pokemon.m.abils = [];
        if (!pokemon.m.abils.includes(effect))
          pokemon.m.abils.push(effect);
      }
    },
    onSwitchInPriority: 2,
    onSwitchIn(pokemon) {
      let format = this.format;
      if (!format.getSharedPower)
        format = this.dex.formats.get("gen9sharedpower");
      for (const ability of format.getSharedPower(pokemon)) {
        if (ability === "noability") {
          this.hint(`Mirror Armor and Trace break in Shared Power formats that don't use Shared Power as a base, so they get removed from non-base users.`);
        }
        const effect = "ability:" + ability;
        delete pokemon.volatiles[effect];
        pokemon.addVolatile(effect);
      }
    }
  },
  {
    name: "[Gen 9] Computer-Generated Teams",
    desc: `Teams generated automatically based on heuristics (rules), with levels based on previous success/failure in battle. Not affiliated with Random Battles formats. Some sets will by nature be worse than others, but you can report egregiously bad sets with <a href="https://forms.gle/DYwQN5qGVegz3YU38">this form</a>.`,
    mod: "gen9",
    team: "computerGenerated",
    ruleset: ["Obtainable", "Species Clause", "HP Percentage Mod", "Cancel Mod", "Sleep Clause Mod", "Illusion Level Mod"]
  },
  {
    name: "[Gen 9] Hackmons Cup",
    desc: `Randomized teams of level-balanced Pok&eacute;mon with absolutely any ability, moves, and item.`,
    mod: "gen9",
    team: "randomHC",
    ruleset: ["HP Percentage Mod", "Cancel Mod"],
    banlist: ["CAP", "LGPE", "MissingNo.", "Pikachu-Cosplay", "Pichu-Spiky-eared", "Pokestar Smeargle", "Pokestar UFO", "Pokestar UFO-2", "Pokestar Brycen-Man", "Pokestar MT", "Pokestar MT2", "Pokestar Transport", "Pokestar Giant", "Pokestar Humanoid", "Pokestar Monster", "Pokestar F-00", "Pokestar F-002", "Pokestar Spirit", "Pokestar Black Door", "Pokestar White Door", "Pokestar Black Belt", "Pokestar UFO-PropU2", "Xerneas-Base"],
    unbanlist: ["All Pokemon"]
  },
  {
    name: "[Gen 9] Doubles Hackmons Cup",
    desc: `Randomized teams of level-balanced Pok&eacute;mon with absolutely any ability, moves, and item. Now with TWICE the Pok&eacute;mon per side!`,
    mod: "gen9",
    team: "randomHC",
    searchShow: false,
    gameType: "doubles",
    ruleset: ["[Gen 9] Hackmons Cup"]
  },
  {
    name: "[Gen 9] Broken Cup",
    desc: `[Gen 9] Hackmons Cup but with only the most powerful Pok&eacute;mon, moves, abilities, and items.`,
    team: "randomHC",
    searchShow: false,
    ruleset: ["HP Percentage Mod", "Cancel Mod"],
    banlist: ["All Pokemon", "All Abilities", "All Items", "All Moves"],
    unbanlist: [
      "10,000,000 Volt Thunderbolt",
      "Abomasnow-Mega",
      "Absol-Mega",
      "Accelerock",
      "Acid Spray",
      "Adaptability",
      "Aeroblast",
      "Aerodactyl-Mega",
      "Aggron",
      "Aggron-Mega",
      "Aguav Berry",
      "Air Balloon",
      "Air Slash",
      "Alakazam-Mega",
      "Altaria-Mega",
      "Ampharos-Mega",
      "Analytic",
      "Anchor Shot",
      "Anger Shell",
      "Annihilape",
      "Anticipation",
      "Apple Acid",
      "Aqua Step",
      "Arcanine",
      "Arcanine-Hisui",
      "Archeops",
      "Arena Trap",
      "Armarouge",
      "Armor Cannon",
      "Aromatherapy",
      "Articuno",
      "Articuno-Galar",
      "Assault Vest",
      "Astral Barrage",
      "Attack Order",
      "Audino-Mega",
      "Aura Sphere",
      "Axe Kick",
      "Azelf",
      "Baddy Bad",
      "Baneful Bunker",
      "Banette-Mega",
      "Barb Barrage",
      "Basculegion",
      "Basculegion-F",
      "Baton Pass",
      "Baxcalibur",
      "Beads of Ruin",
      "Beak Blast",
      "Beast Boost",
      "Behemoth Bash",
      "Behemoth Blade",
      "Belly Drum",
      "Berserk",
      "Bitter Blade",
      "Bitter Malice",
      "Blacephalon",
      "Blastoise",
      "Blastoise-Mega",
      "Blaziken",
      "Blaziken-Mega",
      "Blazing Torque",
      "Bleakwind Storm",
      "Blissey",
      "Blizzard",
      "Blood Moon",
      "Blue Flare",
      "Blunder Policy",
      "Body Press",
      "Body Slam",
      "Bolt Beak",
      "Bolt Strike",
      "Boomburst",
      "Bouncy Bubble",
      "Brave Bird",
      "Bright Powder",
      "Brute Bonnet",
      "Bug Buzz",
      "Buginium Z",
      "Bullet Punch",
      "Buzzwole",
      "Buzzy Buzz",
      "Calm Mind",
      "Calyrex-Ice",
      "Calyrex-Shadow",
      "Camerupt-Mega",
      "Catastropika",
      "Ceaseless Edge",
      "Celebi",
      "Celesteela",
      "Centiskorch",
      "Ceruledge",
      "Charizard",
      "Charizard-Mega-X",
      "Charizard-Mega-Y",
      "Chatter",
      "Chesnaught",
      "Chesto Berry",
      "Chi-Yu",
      "Chien-Pao",
      "Chilan Berry",
      "Chilly Reception",
      "Choice Band",
      "Choice Scarf",
      "Choice Specs",
      "Cinderace",
      "Circle Throw",
      "Clanging Scales",
      "Clangorous Soul",
      "Clangorous Soulblaze",
      "Clear Amulet",
      "Close Combat",
      "Cloyster",
      "Cobalion",
      "Coil",
      "Collision Course",
      "Comatose",
      "Combat Torque",
      "Competitive",
      "Compound Eyes",
      "Contrary",
      "Core Enforcer",
      "Cosmic Power",
      "Cotton Guard",
      "Court Change",
      "Covert Cloak",
      "Crabhammer",
      "Cresselia",
      "Crobat",
      "Custap Berry",
      "Dark Pulse",
      "Darkest Lariat",
      "Darkinium Z",
      "Darkrai",
      "Darmanitan-Galar-Zen",
      "Darmanitan-Zen",
      "Decidueye",
      "Decidueye-Hisui",
      "Defend Order",
      "Defiant",
      "Defog",
      "Delphox",
      "Deoxys",
      "Deoxys-Attack",
      "Deoxys-Defense",
      "Deoxys-Speed",
      "Desolate Land",
      "Dialga",
      "Dialga-Origin",
      "Diamond Storm",
      "Diancie",
      "Diancie-Mega",
      "Dire Claw",
      "Disable",
      "Discharge",
      "Dondozo",
      "Doom Desire",
      "Double Iron Bash",
      "Download",
      "Draco Meteor",
      "Draco Plate",
      "Dragapult",
      "Dragon Ascent",
      "Dragon Dance",
      "Dragon Darts",
      "Dragon Energy",
      "Dragon Hammer",
      "Dragon Pulse",
      "Dragon Tail",
      "Dragonite",
      "Dragonium Z",
      "Drain Punch",
      "Dread Plate",
      "Drill Peck",
      "Drizzle",
      "Drought",
      "Drum Beating",
      "Dry Skin",
      "Duraludon",
      "Dusknoir",
      "Dynamax Cannon",
      "Earth Eater",
      "Earth Plate",
      "Earth Power",
      "Earthquake",
      "Eerie Spell",
      "Effect Spore",
      "Eject Pack",
      "Electivire",
      "Electric Surge",
      "Electrium Z",
      "Electro Drift",
      "Emboar",
      "Empoleon",
      "Enamorus",
      "Enamorus-Therian",
      "Encore",
      "Energy Ball",
      "Entei",
      "Eruption",
      "Espeon",
      "Esper Wing",
      "Eternatus",
      "Eternatus-Eternamax",
      "Exeggutor",
      "Exeggutor-Alola",
      "Expanding Force",
      "Expert Belt",
      "Explosion",
      "Extreme Evoboost",
      "Extreme Speed",
      "Fairium Z",
      "Fake Out",
      "Feraligatr",
      "Fezandipiti",
      "Fiery Wrath",
      "Fightinium Z",
      "Figy Berry",
      "Filter",
      "Fire Blast",
      "Fire Lash",
      "Firium Z",
      "First Impression",
      "Fishious Rend",
      "Fist Plate",
      "Flame Body",
      "Flame Charge",
      "Flame Plate",
      "Flamethrower",
      "Flare Blitz",
      "Flareon",
      "Flash Cannon",
      "Fleur Cannon",
      "Flip Turn",
      "Floaty Fall",
      "Florges",
      "Flower Trick",
      "Fluffy",
      "Flutter Mane",
      "Flyinium Z",
      "Focus Blast",
      "Focus Sash",
      "Forewarn",
      "Foul Play",
      "Freeze-Dry",
      "Freezing Glare",
      "Freezy Frost",
      "Frost Breath",
      "Fur Coat",
      "Fusion Bolt",
      "Fusion Flare",
      "Future Sight",
      "G-Max Cannonade",
      "G-Max Centiferno",
      "G-Max Resonance",
      "G-Max Steelsurge",
      "G-Max Stonesurge",
      "G-Max Sweetness",
      "G-Max Vine Lash",
      "G-Max Volcalith",
      "G-Max Wildfire",
      "G-Max Wind Rage",
      "Gallade-Mega",
      "Garchomp",
      "Garchomp-Mega",
      "Gardevoir-Mega",
      "Gear Grind",
      "Genesect",
      "Genesis Supernova",
      "Gengar-Mega",
      "Gholdengo",
      "Ghostium Z",
      "Giga Drain",
      "Gigaton Hammer",
      "Giratina",
      "Giratina-Origin",
      "Glaceon",
      "Glacial Lance",
      "Glaive Rush",
      "Glalie-Mega",
      "Glare",
      "Glastrier",
      "Glimmora",
      "Glitzy Glow",
      "Gogoat",
      "Golisopod",
      "Good as Gold",
      "Goodra",
      "Goodra-Hisui",
      "Gooey",
      "Gorilla Tactics",
      "Grassium Z",
      "Grassy Surge",
      "Grav Apple",
      "Great Tusk",
      "Greninja",
      "Greninja-Ash",
      "Groudon",
      "Groudon-Primal",
      "Groundium Z",
      "Guardian of Alola",
      "Gunk Shot",
      "Guzzlord",
      "Gyarados",
      "Gyarados-Mega",
      "Hadron Engine",
      "Hammer Arm",
      "Haxorus",
      "Haze",
      "Head Charge",
      "Head Smash",
      "Headlong Rush",
      "Heal Bell",
      "Heal Order",
      "Healing Wish",
      "Heart Swap",
      "Heat Crash",
      "Heat Wave",
      "Heatran",
      "Heavy-Duty Boots",
      "Heracross-Mega",
      "High Horsepower",
      "High Jump Kick",
      "Hippowdon",
      "Ho-Oh",
      "Hoopa",
      "Hoopa-Unbound",
      "Horn Leech",
      "Houndoom-Mega",
      "Huge Power",
      "Hurricane",
      "Hydreigon",
      "Hydro Steam",
      "Hyper Drill",
      "Iapapa Berry",
      "Ice Beam",
      "Ice Hammer",
      "Ice Scales",
      "Ice Shard",
      "Ice Spinner",
      "Icicle Plate",
      "Icium Z",
      "Illusion",
      "Imposter",
      "Incineroar",
      "Infernape",
      "Innards Out",
      "Insect Plate",
      "Inteleon",
      "Intimidate",
      "Intrepid Sword",
      "Iron Barbs",
      "Iron Bundle",
      "Iron Hands",
      "Iron Head",
      "Iron Jugulis",
      "Iron Leaves",
      "Iron Moth",
      "Iron Plate",
      "Iron Thorns",
      "Iron Treads",
      "Iron Valiant",
      "Ivy Cudgel",
      "Jet Punch",
      "Jirachi",
      "Jolteon",
      "Judgment",
      "Kangaskhan-Mega",
      "Kartana",
      "Keldeo",
      "Keldeo-Resolute",
      "King's Rock",
      "King's Shield",
      "Kingambit",
      "Kingdra",
      "Knock Off",
      "Kommo-o",
      "Koraidon",
      "Kyogre",
      "Kyogre-Primal",
      "Kyurem",
      "Kyurem-Black",
      "Kyurem-White",
      "Landorus",
      "Landorus-Therian",
      "Lapras",
      "Last Respects",
      "Latias",
      "Latias-Mega",
      "Latios",
      "Latios-Mega",
      "Lava Plume",
      "Leaf Blade",
      "Leaf Storm",
      "Leafeon",
      "Leech Life",
      "Leech Seed",
      "Leftovers",
      "Leppa Berry",
      "Let's Snuggle Forever",
      "Levitate",
      "Libero",
      "Liechi Berry",
      "Life Orb",
      "Light Screen",
      "Light That Burns the Sky",
      "Light of Ruin",
      "Lightning Rod",
      "Liquidation",
      "Lopunny-Mega",
      "Lovely Kiss",
      "Low Kick",
      "Lucario",
      "Lucario-Mega",
      "Lugia",
      "Lum Berry",
      "Lumina Crash",
      "Lunala",
      "Lunar Blessing",
      "Lunar Dance",
      "Lunge",
      "Mach Punch",
      "Magearna",
      "Magic Bounce",
      "Magic Guard",
      "Magical Torque",
      "Magma Storm",
      "Magmortar",
      "Magnezone",
      "Mago Berry",
      "Make It Rain",
      "Malicious Moonsault",
      "Mamoswine",
      "Manaphy",
      "Manectric-Mega",
      "Marshadow",
      "Matcha Gotcha",
      "Max Guard",
      "Meadow Plate",
      "Megahorn",
      "Meganium",
      "Melmetal",
      "Meloetta",
      "Meloetta-Pirouette",
      "Memento",
      "Menacing Moonraze Maelstrom",
      "Mental Herb",
      "Meowscarada",
      "Mesprit",
      "Metagross",
      "Metagross-Mega",
      "Meteor Beam",
      "Meteor Mash",
      "item: Metronome",
      "Mew",
      "Mewtwo",
      "Mewtwo-Mega-X",
      "Mewtwo-Mega-Y",
      "Milk Drink",
      "Milotic",
      "Mind Plate",
      "Mind's Eye",
      "Minimize",
      "Miraidon",
      "Mirror Herb",
      "Misty Explosion",
      "Misty Surge",
      "Mold Breaker",
      "Moltres",
      "Moltres-Galar",
      "Moody",
      "Moonblast",
      "Moongeist Beam",
      "Moonlight",
      "Morning Sun",
      "Mortal Spin",
      "Mountain Gale",
      "Moxie",
      "Multiscale",
      "Munkidori",
      "Muscle Band",
      "Mystical Fire",
      "Mystical Power",
      "Naganadel",
      "Nasty Plot",
      "Nature's Madness",
      "Necrozma",
      "Necrozma-Dawn-Wings",
      "Necrozma-Dusk-Mane",
      "Necrozma-Ultra",
      "Neutralizing Gas",
      "Night Daze",
      "Night Shade",
      "Nihilego",
      "No Retreat",
      "Noivern",
      "Normalium Z",
      "Noxious Torque",
      "Nuzzle",
      "Oblivion Wing",
      "Obstruct",
      "Oceanic Operetta",
      "Octolock",
      "Ogerpon",
      "Ogerpon-Cornerstone",
      "Ogerpon-Hearthflame",
      "Ogerpon-Wellspring",
      "Okidogi",
      "Opportunist",
      "Orichalcum Pulse",
      "Origin Pulse",
      "Outrage",
      "Overdrive",
      "Overheat",
      "Palafin-Hero",
      "Palkia",
      "Palkia-Origin",
      "Parental Bond",
      "Parting Shot",
      "Perish Body",
      "Petaya Berry",
      "Pheromosa",
      "Photon Geyser",
      "Pidgeot-Mega",
      "Pinsir-Mega",
      "Pixie Plate",
      "Plasma Fists",
      "Play Rough",
      "Poison Heal",
      "Poisonium Z",
      "Pollen Puff",
      "Poltergeist",
      "Population Bomb",
      "Porygon-Z",
      "Power Gem",
      "Power Trip",
      "Power Whip",
      "Prankster",
      "Precipice Blades",
      "Primarina",
      "Primordial Sea",
      "Probopass",
      "Protean",
      "Protect",
      "Psyblade",
      "Psychic Fangs",
      "Psychic Surge",
      "Psychic",
      "Psychium Z",
      "Psycho Boost",
      "Psyshield Bash",
      "Psystrike",
      "Pulverizing Pancake",
      "Pure Power",
      "Purifying Salt",
      "Pursuit",
      "Pyro Ball",
      "Quaquaval",
      "Quick Claw",
      "Quiver Dance",
      "Rage Fist",
      "Raging Bull",
      "Raging Fury",
      "Raikou",
      "Rapid Spin",
      "Rayquaza",
      "Rayquaza-Mega",
      "Razor Claw",
      "Recover",
      "Red Card",
      "Reflect",
      "Regenerator",
      "Regice",
      "Regidrago",
      "Regieleki",
      "Regigigas",
      "Regirock",
      "Registeel",
      "Reshiram",
      "Rest",
      "Revelation Dance",
      "Revival Blessing",
      "Rhyperior",
      "Rillaboom",
      "Roaring Moon",
      "Rockium Z",
      "Rocky Helmet",
      "Roost",
      "Rough Skin",
      "Ruination",
      "Sacred Fire",
      "Sacred Sword",
      "Salac Berry",
      "Salamence",
      "Salamence-Mega",
      "Salt Cure",
      "Samurott",
      "Samurott-Hisui",
      "Sandsear Storm",
      "Sandy Shocks",
      "Sap Sipper",
      "Sappy Seed",
      "Scald",
      "Sceptile",
      "Sceptile-Mega",
      "Scizor-Mega",
      "Scope Lens",
      "Scream Tail",
      "Searing Shot",
      "Searing Sunraze Smash",
      "Secret Sword",
      "Seed Flare",
      "Seismic Toss",
      "Serene Grace",
      "Serperior",
      "Shadow Ball",
      "Shadow Bone",
      "Shadow Shield",
      "Shadow Sneak",
      "Shadow Tag",
      "Sharpedo-Mega",
      "Shaymin",
      "Shaymin-Sky",
      "Shed Tail",
      "Sheer Force",
      "Shell Side Arm",
      "Shell Smash",
      "Shield Dust",
      "Shift Gear",
      "Silk Scarf",
      "Silk Trap",
      "Silvally",
      "Simple",
      "Sinister Arrow Raid",
      "Sitrus Berry",
      "Sizzly Slide",
      "Skeledirge",
      "Sky Plate",
      "Slack Off",
      "Slaking",
      "Sleep Powder",
      "Slither Wing",
      "Slowbro-Mega",
      "Sludge Bomb",
      "Sludge Wave",
      "Snarl",
      "Snipe Shot",
      "Snorlax",
      "Soft-Boiled",
      "Solgaleo",
      "Solid Rock",
      "Soul-Heart",
      "Soul-Stealing 7-Star Strike",
      "Spacial Rend",
      "Sparkly Swirl",
      "Spectral Thief",
      "Spectrier",
      "Speed Boost",
      "Spikes",
      "Spiky Shield",
      "Spin Out",
      "Spirit Break",
      "Spirit Shackle",
      "Splash Plate",
      "Splintered Stormshards",
      "Splishy Splash",
      "Spooky Plate",
      "Spore",
      "Springtide Storm",
      "Stakataka",
      "Stakeout",
      "Stamina",
      "Stealth Rock",
      "Steam Eruption",
      "Steelium Z",
      "Steelix-Mega",
      "Sticky Web",
      "Stoked Sparksurfer",
      "Stone Axe",
      "Stone Edge",
      "Stone Plate",
      "Stored Power",
      "Storm Drain",
      "Storm Throw",
      "Strange Steam",
      "Strength Sap",
      "Sucker Punch",
      "Suicune",
      "Sunsteel Strike",
      "Super Fang",
      "Superpower",
      "Supersweet Syrup",
      "Supreme Overlord",
      "Surf",
      "Surging Strikes",
      "Swampert",
      "Swampert-Mega",
      "Sword of Ruin",
      "Swords Dance",
      "Sylveon",
      "Synthesis",
      "Tablets of Ruin",
      "Tail Glow",
      "Tangrowth",
      "Tapu Bulu",
      "Tapu Fini",
      "Tapu Koko",
      "Tapu Lele",
      "Taunt",
      "Techno Blast",
      "Teleport",
      "Tera Blast",
      "Teravolt",
      "Terrakion",
      "Thick Fat",
      "Thousand Arrows",
      "Thousand Waves",
      "Throat Spray",
      "Thunder Cage",
      "Thunder Wave",
      "Thunder",
      "Thunderbolt",
      "Thunderous Kick",
      "Thundurus",
      "Thundurus-Therian",
      "Tidy Up",
      "Ting-Lu",
      "Tinted Lens",
      "Togekiss",
      "Topsy-Turvy",
      "Torch Song",
      "Tornadus",
      "Tornadus-Therian",
      "Torterra",
      "Tough Claws",
      "Toxic Chain",
      "Toxic Debris",
      "Toxic Plate",
      "Toxic Spikes",
      "Toxic",
      "Tri Attack",
      "Triage",
      "Triple Arrows",
      "Triple Axel",
      "Turboblaze",
      "Type: Null",
      "Typhlosion",
      "Typhlosion-Hisui",
      "Tyranitar",
      "Tyranitar-Mega",
      "U-turn",
      "Umbreon",
      "Unaware",
      "Unburden",
      "Ursaluna",
      "Ursaluna-Bloodmoon",
      "Urshifu",
      "Urshifu-Rapid-Strike",
      "Uxie",
      "V-create",
      "Vanilluxe",
      "Vaporeon",
      "Venusaur",
      "Venusaur-Mega",
      "Vessel of Ruin",
      "Victini",
      "Victory Dance",
      "Virizion",
      "Volcanion",
      "Volcarona",
      "Volt Absorb",
      "Volt Switch",
      "Volt Tackle",
      "Walking Wake",
      "Walrein",
      "Water Absorb",
      "Water Bubble",
      "Water Shuriken",
      "Water Spout",
      "Waterfall",
      "Waterium Z",
      "Wave Crash",
      "Weakness Policy",
      "Well-Baked Body",
      "White Herb",
      "Wicked Blow",
      "Wicked Torque",
      "Wide Lens",
      "Wiki Berry",
      "Wild Charge",
      "Wildbolt Storm",
      "Will-O-Wisp",
      "Wise Glasses",
      "Wish",
      "Wishiwashi-School",
      "Wo-Chien",
      "Wonder Guard",
      "Wood Hammer",
      "Wyrdeer",
      "Xerneas",
      "Xurkitree",
      "Yawn",
      "Yveltal",
      "Zacian",
      "Zacian-Crowned",
      "Zamazenta",
      "Zamazenta-Crowned",
      "Zap Plate",
      "Zapdos",
      "Zapdos-Galar",
      "Zarude",
      "Zekrom",
      "Zeraora",
      "Zing Zap",
      "Zippy Zap",
      "Zygarde",
      "Zygarde-Complete"
    ]
  },
  {
    name: "[Gen 9] Challenge Cup 1v1",
    desc: `Get a randomized team of level-balanced Pok&eacute;mon with absolutely any legal ability, moves, and item, and choose one to battle.`,
    mod: "gen9",
    team: "randomCC",
    ruleset: ["Obtainable", "HP Percentage Mod", "Cancel Mod", "Team Preview", "Terastal Clause", "Picked Team Size = 1"]
  },
  {
    name: "[Gen 9] Challenge Cup 2v2",
    desc: `Get a randomized team of level-balanced Pok&eacute;mon with absolutely any legal ability, moves, and item, and choose two to battle in a doubles format.`,
    mod: "gen9",
    team: "randomCC",
    gameType: "doubles",
    ruleset: ["Obtainable", "HP Percentage Mod", "Cancel Mod", "Team Preview", "Picked Team Size = 2"]
  },
  {
    name: "[Gen 9] Challenge Cup 6v6",
    desc: `Randomized teams of level-balanced Pok&eacute;mon with absolutely any legal ability, moves, and item.`,
    mod: "gen9",
    team: "randomCC",
    searchShow: false,
    ruleset: ["Obtainable", "HP Percentage Mod", "Cancel Mod"]
  },
  {
    name: "[Gen 9] Metronome Battle",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3632075/">Metronome Battle</a>`
    ],
    mod: "gen9",
    gameType: "doubles",
    ruleset: ["Max Team Size = 2", "HP Percentage Mod", "Cancel Mod"],
    banlist: [
      "Pokestar Spirit",
      "Terapagos",
      "Shedinja + Sturdy",
      "Cheek Pouch",
      "Commander",
      "Cursed Body",
      "Dry Skin",
      "Earth Eater",
      "Fur Coat",
      "Gorilla Tactics",
      "Grassy Surge",
      "Huge Power",
      "Ice Body",
      "Iron Barbs",
      "Moody",
      "Neutralizing Gas",
      "Opportunist",
      "Parental Bond",
      "Perish Body",
      "Poison Heal",
      "Power Construct",
      "Pressure",
      "Pure Power",
      "Rain Dish",
      "Rough Skin",
      "Sand Spit",
      "Sand Stream",
      "Seed Sower",
      "Stamina",
      "Volt Absorb",
      "Water Absorb",
      "Wonder Guard",
      "Harvest + Jaboca Berry",
      "Harvest + Rowap Berry",
      "Aguav Berry",
      "Assault Vest",
      "Berry",
      "Berry Juice",
      "Berserk Gene",
      "Black Sludge",
      "Enigma Berry",
      "Figy Berry",
      "Gold Berry",
      "Iapapa Berry",
      "Kangaskhanite",
      "Leftovers",
      "Mago Berry",
      "Medichamite",
      "Steel Memory",
      "Oran Berry",
      "Rocky Helmet",
      "Shell Bell",
      "Sitrus Berry",
      "Wiki Berry"
    ],
    onValidateSet(set) {
      const species = this.dex.species.get(set.species);
      if (species.types.includes("Steel")) {
        return [`${species.name} is a Steel-type, which is banned from Metronome Battle.`];
      }
      if (set.teraType === "Steel") {
        return [`${species.name} has Steel as its Tera type, which is banned from Metronome Battle.`];
      }
      if (species.bst > 625) {
        return [`${species.name} is banned.`, `(Pok\xE9mon with a BST higher than 625 are banned)`];
      }
      const item = this.dex.items.get(set.item);
      if (set.item && item.megaStone) {
        const megaSpecies = this.dex.species.get(item.megaStone);
        if (species.baseSpecies === item.megaEvolves && megaSpecies.bst > 625) {
          return [
            `${set.name || set.species}'s item ${item.name} is banned.`,
            `(Pok\xE9mon with a BST higher than 625 are banned)`
          ];
        }
      }
      if (set.moves.length !== 1 || this.dex.moves.get(set.moves[0]).id !== "metronome") {
        return [`${set.name || set.species} has illegal moves.`, `(Pok\xE9mon can only have one Metronome in their moveset)`];
      }
    }
  },
  {
    name: "[Gen 8] Random Battle",
    desc: `Randomized teams of level-balanced Pok&eacute;mon with sets that are generated to be competitively viable.`,
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3656537/">Random Battle Suggestions</a>`
    ],
    mod: "gen8",
    team: "random",
    ruleset: ["PotD", "Obtainable", "Species Clause", "HP Percentage Mod", "Cancel Mod", "Sleep Clause Mod", "Illusion Level Mod"]
  },
  {
    name: "[Gen 8] Random Doubles Battle",
    mod: "gen8",
    gameType: "doubles",
    team: "random",
    ruleset: ["PotD", "Obtainable", "Species Clause", "HP Percentage Mod", "Cancel Mod", "Illusion Level Mod"]
  },
  {
    name: "[Gen 8] Free-For-All Random Battle",
    mod: "gen8",
    team: "random",
    gameType: "freeforall",
    // searchShow: false,
    tournamentShow: false,
    rated: false,
    ruleset: ["Obtainable", "Species Clause", "HP Percentage Mod", "Cancel Mod", "Sleep Clause Mod", "Illusion Level Mod"]
  },
  {
    name: "[Gen 8] Multi Random Battle",
    mod: "gen8",
    team: "random",
    gameType: "multi",
    searchShow: false,
    tournamentShow: false,
    rated: false,
    ruleset: [
      "Max Team Size = 3",
      "Obtainable",
      "Species Clause",
      "HP Percentage Mod",
      "Cancel Mod",
      "Sleep Clause Mod",
      "Illusion Level Mod"
    ]
  },
  {
    name: "[Gen 8] Battle Factory",
    desc: `Randomized teams of Pok&eacute;mon for a generated Smogon tier with sets that are competitively viable.`,
    mod: "gen8",
    team: "randomFactory",
    ruleset: ["Standard", "Dynamax Clause"],
    onBegin() {
      this.add(`raw|<div class="broadcast-blue"><b>Battle Factory Tier: ${this.teamGenerator.factoryTier}</b></div>`);
    }
  },
  {
    name: "[Gen 8] BSS Factory",
    desc: `Randomized 3v3 Singles featuring Pok&eacute;mon and movesets popular in Battle Stadium Singles.`,
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3675374/">Information and Suggestions Thread</a>`
    ],
    mod: "gen8",
    team: "randomBSSFactory",
    searchShow: false,
    ruleset: ["Flat Rules"]
  },
  {
    name: "[Gen 8] Super Staff Bros 4",
    desc: `The fourth iteration of Super Staff Bros is here! Battle with a random team of Pok&eacute;mon created by the sim staff.`,
    threads: [
      `&bullet; <a href="https://www.smogon.com/articles/super-staff-bros-4">Introduction &amp; Roster</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/super-staff-bros-4-discussion-thread.3675237/">Discussion Thread</a>`
    ],
    mod: "ssb",
    team: "randomStaffBros",
    ruleset: ["Dynamax Clause", "HP Percentage Mod", "Cancel Mod", "Sleep Clause Mod"],
    onBegin() {
      if (!this.ruleTable.has("dynamaxclause")) {
        for (const side of this.sides) {
          side.dynamaxUsed = true;
        }
        this.add("message", "Delphox only");
        this.add("message", "No items");
        this.add("message", "Final Destination");
        return;
      }
      this.add(`raw|<div class='broadcast-green'><b>Wondering what all these custom moves, abilities, and items do?<br />Check out the <a href="https://www.smogon.com/articles/super-staff-bros-4" target="_blank">Super Staff Bros 4 Guide</a> or use /ssb to find out!</b></div>`);
      this.add("message", [
        "THE BATTLE FOR SURVIVAL BEGINS!",
        "WHO WILL SURVIVE?",
        "GET READY TO KEEP UP!",
        "GET READY!",
        "DARE TO BELIEVE YOU CAN SURVIVE!",
        "THERE CAN BE ONLY ONE WINNER!",
        "GET READY FOR THE FIGHT OF YOUR LIFE!",
        "WHO WILL PREVAIL?",
        "ONLY ONE TEAM WILL BE LEFT STANDING!",
        "BATTLE WITHOUT LIMITS!"
      ][this.random(10)]);
      this.add("message", "FIGHT!");
    },
    onSwitchInPriority: 100,
    onSwitchIn(pokemon) {
      let name = this.toID(pokemon.illusion ? pokemon.illusion.name : pokemon.name);
      if (this.dex.species.get(name).exists || this.dex.moves.get(name).exists || this.dex.abilities.get(name).exists) {
        name = name + "user";
      }
      const status = this.dex.conditions.get(name);
      if (status?.exists) {
        pokemon.addVolatile(name, pokemon);
      }
      if (pokemon.m.hasBounty)
        this.add("-start", pokemon, "bounty", "[silent]");
      const details = pokemon.species.name + (pokemon.level === 100 ? "" : ", L" + pokemon.level) + (pokemon.gender === "" ? "" : ", " + pokemon.gender) + (pokemon.set.shiny ? ", shiny" : "");
      if (pokemon.m.nowShiny)
        this.add("replace", pokemon, details);
    },
    onFaint(target, source, effect) {
      if (effect?.effectType !== "Move")
        return;
      if (!target.m.hasBounty)
        return;
      if (source) {
        this.add("-message", `${source.name} received the bounty!`);
        this.boost({ atk: 1, def: 1, spa: 1, spd: 1, spe: 1 }, source, target, effect);
      }
    }
  },
  {
    name: "[Gen 8] Hackmons Cup",
    desc: `Randomized teams of level-balanced Pok&eacute;mon with absolutely any ability, moves, and item.`,
    mod: "gen8",
    team: "randomHC",
    ruleset: ["HP Percentage Mod", "Cancel Mod"],
    banlist: ["Nonexistent"]
  },
  {
    name: "[Gen 8] Metronome Battle",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3632075/">Metronome Battle</a>`
    ],
    mod: "gen8",
    gameType: "doubles",
    searchShow: false,
    ruleset: ["Max Team Size = 2", "HP Percentage Mod", "Cancel Mod"],
    banlist: [
      "Pokestar Spirit",
      "Shedinja + Sturdy",
      "Battle Bond",
      "Cheek Pouch",
      "Cursed Body",
      "Dry Skin",
      "Fur Coat",
      "Gorilla Tactics",
      "Grassy Surge",
      "Huge Power",
      "Ice Body",
      "Iron Barbs",
      "Libero",
      "Moody",
      "Neutralizing Gas",
      "Parental Bond",
      "Perish Body",
      "Poison Heal",
      "Power Construct",
      "Pressure",
      "Protean",
      "Pure Power",
      "Rain Dish",
      "Rough Skin",
      "Sand Spit",
      "Sand Stream",
      "Snow Warning",
      "Stamina",
      "Volt Absorb",
      "Water Absorb",
      "Wonder Guard",
      "Abomasite",
      "Aguav Berry",
      "Assault Vest",
      "Berry",
      "Berry Juice",
      "Berserk Gene",
      "Black Sludge",
      "Enigma Berry",
      "Figy Berry",
      "Gold Berry",
      "Iapapa Berry",
      "Kangaskhanite",
      "Leftovers",
      "Mago Berry",
      "Medichamite",
      "Steel Memory",
      "Oran Berry",
      "Rocky Helmet",
      "Shell Bell",
      "Sitrus Berry",
      "Wiki Berry",
      "Harvest + Jaboca Berry",
      "Harvest + Rowap Berry"
    ],
    onValidateSet(set) {
      const species = this.dex.species.get(set.species);
      if (species.gen > 8) {
        return [`${species.name} is from gen 9, which is banned from [Gen 8] Metronome Battle.`];
      }
      if (species.types.includes("Steel")) {
        return [`${species.name} is a Steel-type, which is banned from Metronome Battle.`];
      }
      if (species.bst > 625) {
        return [`${species.name} is banned.`, `(Pok\xE9mon with a BST higher than 625 are banned)`];
      }
      const item = this.dex.items.get(set.item);
      if (item.gen > 8) {
        return [`${species.name} is from gen 9, which is banned from [Gen 8] Metronome Battle.`];
      }
      if (set.item && item.megaStone) {
        const megaSpecies = this.dex.species.get(item.megaStone);
        if (species.baseSpecies === item.megaEvolves && megaSpecies.bst > 625) {
          return [
            `${set.name || set.species}'s item ${item.name} is banned.`,
            `(Pok\xE9mon with a BST higher than 625 are banned)`
          ];
        }
      }
      const ability = this.dex.abilities.get(set.ability);
      if (ability.gen > 8) {
        return [`${species.name} is from gen 9, which is banned from [Gen 8] Metronome Battle.`];
      }
      if (set.moves.length !== 1 || this.dex.moves.get(set.moves[0]).id !== "metronome") {
        return [`${set.name || set.species} has illegal moves.`, `(Pok\xE9mon can only have one Metronome in their moveset)`];
      }
    }
  },
  {
    name: "[Gen 8] CAP 1v1",
    desc: `Randomly generated 1v1-style teams only including Pok&eacute;mon made by the Create-A-Pok&eacute;mon Project.`,
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3663533/">CAP 1v1</a>`
    ],
    mod: "gen8",
    searchShow: false,
    team: "randomCAP1v1",
    ruleset: [
      "Picked Team Size = 1",
      "Max Team Size = 3",
      "Species Clause",
      "Team Preview",
      "HP Percentage Mod",
      "Cancel Mod",
      "Sleep Clause Mod",
      "Dynamax Clause"
    ]
  },
  {
    name: "[Gen 8 BDSP] Random Battle",
    desc: `Randomized teams of level-balanced Pok&eacute;mon with sets that are generated to be competitively viable.`,
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3693955/">BDSP Random Battle Set Discussion</a>`
    ],
    mod: "gen8bdsp",
    team: "random",
    searchShow: false,
    ruleset: ["[Gen 8] Random Battle", "!PotD"]
  },
  {
    name: "[Gen 7] Random Battle",
    desc: `Randomized teams of level-balanced Pok&eacute;mon with sets that are generated to be competitively viable.`,
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3591157/">Sets and Suggestions</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3616946/">Role Compendium</a>`
    ],
    mod: "gen7",
    team: "random",
    ruleset: ["Obtainable", "Sleep Clause Mod", "HP Percentage Mod", "Cancel Mod", "Illusion Level Mod"]
  },
  {
    name: "[Gen 7] Random Doubles Battle",
    threads: [`&bullet; <a href="https://www.smogon.com/forums/threads/3601525/">Sets and Suggestions</a>`],
    mod: "gen7",
    gameType: "doubles",
    team: "random",
    searchShow: false,
    challengeShow: false,
    ruleset: ["Obtainable", "HP Percentage Mod", "Cancel Mod", "Illusion Level Mod"]
  },
  {
    name: "[Gen 7] Battle Factory",
    desc: `Randomized teams of Pok&eacute;mon for a generated Smogon tier with sets that are competitively viable.`,
    mod: "gen7",
    team: "randomFactory",
    ruleset: ["Obtainable", "Sleep Clause Mod", "Team Preview", "HP Percentage Mod", "Cancel Mod", "Mega Rayquaza Clause"],
    onBegin() {
      this.add(`raw|<div class="broadcast-blue"><b>Battle Factory Tier: ${this.teamGenerator.factoryTier}</b></div>`);
    }
  },
  {
    name: "[Gen 7] BSS Factory",
    desc: `Randomized 3v3 Singles featuring Pok&eacute;mon and movesets popular in Battle Spot Singles.`,
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3604845/">Information and Suggestions Thread</a>`
    ],
    mod: "gen7",
    team: "randomBSSFactory",
    searchShow: false,
    ruleset: ["Flat Rules"]
  },
  {
    name: "[Gen 7] Hackmons Cup",
    desc: `Randomized teams of level-balanced Pok&eacute;mon with absolutely any ability, moves, and item.`,
    mod: "gen7",
    team: "randomHC",
    searchShow: false,
    ruleset: ["HP Percentage Mod", "Cancel Mod"],
    banlist: ["Nonexistent"]
  },
  {
    name: "[Gen 7 Let's Go] Random Battle",
    mod: "gen7letsgo",
    team: "random",
    searchShow: false,
    ruleset: ["Obtainable", "Allow AVs", "HP Percentage Mod", "Cancel Mod", "Sleep Clause Mod"]
  },
  {
    name: "[Gen 6] Random Battle",
    mod: "gen6",
    team: "random",
    ruleset: ["Obtainable", "Sleep Clause Mod", "HP Percentage Mod", "Cancel Mod", "Illusion Level Mod"]
  },
  {
    name: "[Gen 6] Battle Factory",
    desc: `Randomized teams of Pok&eacute;mon for a generated Smogon tier with sets that are competitively viable.`,
    mod: "gen6",
    team: "randomFactory",
    searchShow: false,
    challengeShow: false,
    ruleset: ["Obtainable", "Sleep Clause Mod", "Team Preview", "HP Percentage Mod", "Cancel Mod", "Mega Rayquaza Clause"],
    onBegin() {
      this.add(`raw|<div class="broadcast-blue"><b>Battle Factory Tier: ${this.teamGenerator.factoryTier}</b></div>`);
    }
  },
  {
    name: "[Gen 5] Random Battle",
    mod: "gen5",
    team: "random",
    ruleset: ["Obtainable", "Sleep Clause Mod", "HP Percentage Mod", "Cancel Mod", "Illusion Level Mod"]
  },
  {
    name: "[Gen 4] Random Battle",
    mod: "gen4",
    team: "random",
    ruleset: ["Obtainable", "Sleep Clause Mod", "HP Percentage Mod", "Cancel Mod"]
  },
  {
    name: "[Gen 3] Random Battle",
    mod: "gen3",
    team: "random",
    ruleset: ["Standard"]
  },
  {
    name: "[Gen 2] Random Battle",
    mod: "gen2",
    team: "random",
    ruleset: ["Standard"]
  },
  {
    name: "[Gen 1] Random Battle",
    mod: "gen1",
    team: "random",
    ruleset: ["Standard"]
  },
  {
    name: "[Gen 1] Challenge Cup",
    desc: `Randomized teams of level-balanced Pok&eacute;mon with absolutely any legal moves.`,
    mod: "gen1",
    team: "randomCC",
    searchShow: false,
    challengeShow: false,
    ruleset: ["Obtainable", "HP Percentage Mod", "Cancel Mod", "Desync Clause Mod", "Sleep Clause Mod", "Freeze Clause Mod"]
  },
  {
    name: "[Gen 1] Hackmons Cup",
    desc: `Randomized teams of level-balanced Pok&eacute;mon with absolutely any moves, types, and stats.`,
    mod: "gen1",
    team: "randomHC",
    searchShow: false,
    challengeShow: false,
    ruleset: ["HP Percentage Mod", "Cancel Mod", "Desync Clause Mod", "Sleep Clause Mod", "Freeze Clause Mod", "Team Type Preview"],
    banlist: ["Nonexistent"],
    onModifySpecies(species, target, source, effect) {
      if (!target)
        return;
      return { ...species, ...target.set.hc };
    },
    onSwitchIn(pokemon) {
      this.add("-start", pokemon, "typechange", pokemon.getTypes(true).join("/"), "[silent]");
      for (const i in pokemon.species.baseStats) {
        if (i === "spd")
          continue;
        this.add("-start", pokemon, `${pokemon.species.baseStats[i]}${i === "spa" ? "spc" : i}`, "[silent]");
      }
    }
  },
  // RoA Spotlight
  ///////////////////////////////////////////////////////////////////
  {
    section: "RoA Spotlight",
    column: 4
  },
  {
    name: "[Gen 3] UU",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3585923/">ADV UU Metagame Discussion</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3548578/">ADV UU Viability Rankings</a>`
    ],
    mod: "gen3",
    // searchShow: false,
    ruleset: ["Standard"],
    banlist: ["Uber", "OU", "UUBL", "Smeargle + Ingrain", "Arena Trap", "Baton Pass", "Swagger"]
  },
  {
    name: "[Gen 1] NU",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3679758/">RBY NU Metagame Discussion &amp; Resources</a>`
    ],
    mod: "gen1",
    // searchShow: false,
    ruleset: ["[Gen 1] UU", "!APT Clause"],
    banlist: ["UU", "NUBL"]
  },
  {
    name: "[Gen 4] Farceus Ubers",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/posts/9462709/">DPP Farceus Ubers</a>`
    ],
    mod: "gen4",
    ruleset: ["Standard", "Arceus EV Limit"]
  },
  // Past Gens OU
  ///////////////////////////////////////////////////////////////////
  {
    section: "Past Gens OU",
    column: 4
  },
  {
    name: "[Gen 8] OU",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3710887/">SS OU Metagame Discussion</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3710892/">SS OU Sample Teams</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3717979/">SS OU Viability Rankings</a>`
    ],
    mod: "gen8",
    ruleset: ["Standard", "Dynamax Clause"],
    banlist: ["Uber", "AG", "Arena Trap", "Moody", "Power Construct", "Sand Veil", "Shadow Tag", "Snow Cloak", "King's Rock", "Baton Pass"]
  },
  {
    name: "[Gen 7] OU",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3685980/">USM OU Metagame Discussion</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3695427/">USM OU Sample Teams</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3667522/">USM OU Viability Rankings</a>`
    ],
    mod: "gen7",
    ruleset: ["Standard"],
    banlist: ["Uber", "Arena Trap", "Power Construct", "Shadow Tag", "Baton Pass"]
  },
  {
    name: "[Gen 6] OU",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3719305/">ORAS OU Metagame Discussion</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3694551/">ORAS OU Sample Teams</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3623399/">ORAS OU Viability Rankings</a>`
    ],
    mod: "gen6",
    ruleset: ["Standard", "Swagger Clause"],
    banlist: ["Uber", "Arena Trap", "Shadow Tag", "Soul Dew", "Baton Pass"]
  },
  {
    name: "[Gen 5] OU",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3666724/">BW2 OU Metagame Discussion</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3686880/">BW2 OU Sample Teams</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3668699/">BW2 OU Viability Rankings</a>`
    ],
    mod: "gen5",
    ruleset: ["Standard", "Evasion Abilities Clause", "Sleep Moves Clause", "Swagger Clause", "Gems Clause", "Baton Pass Stat Clause"],
    banlist: ["Uber", "Arena Trap", "Drizzle ++ Swift Swim", "Drought ++ Chlorophyll", "Sand Rush", "Shadow Tag", "King's Rock", "Razor Fang", "Soul Dew", "Assist"]
  },
  {
    name: "[Gen 4] OU",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3685887/">DPP OU Metagame Discussion</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3687351/">DPP OU Sample Teams</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3683332/">DPP OU Viability Rankings</a>`
    ],
    mod: "gen4",
    ruleset: ["Standard", "Evasion Abilities Clause", "Baton Pass Stat Trap Clause", "Freeze Clause Mod"],
    banlist: ["AG", "Uber", "Arena Trap", "Quick Claw", "Soul Dew", "Swagger"]
  },
  {
    name: "[Gen 3] OU",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3687814/">ADV OU Metagame Discussion</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3687813/">ADV OU Sample Teams</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3503019/">ADV OU Viability Rankings</a>`
    ],
    mod: "gen3",
    ruleset: ["Standard", "One Boost Passer Clause", "Freeze Clause Mod"],
    banlist: ["Uber", "Smeargle + Ingrain", "Sand Veil", "Soundproof", "Assist", "Baton Pass + Block", "Baton Pass + Mean Look", "Baton Pass + Spider Web", "Swagger"]
  },
  {
    name: "[Gen 2] OU",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3688141/">GSC OU Metagame Discussion</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3688523/">GSC OU Sample Teams</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3633233/">GSC OU Viability Rankings</a>`
    ],
    mod: "gen2",
    ruleset: ["Standard"],
    banlist: ["Uber", "Mean Look + Baton Pass", "Spider Web + Baton Pass"]
  },
  {
    name: "[Gen 1] OU",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3685846/">RBY OU Metagame Discussion</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3689726/">RBY OU Sample Teams</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3685861/">RBY OU Viability Rankings</a>`
    ],
    mod: "gen1",
    ruleset: ["Standard"],
    banlist: ["Uber"]
  },
  // Past Gens Doubles OU
  ///////////////////////////////////////////////////////////////////
  {
    section: "Past Gens Doubles OU",
    column: 4
  },
  {
    name: "[Gen 8] Doubles OU",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3689189/">SS Doubles OU Metagame Discussion</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3658826/">SS Doubles OU Sample Teams</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3673519/">SS Doubles OU Viability Rankings</a>`
    ],
    mod: "gen8",
    gameType: "doubles",
    ruleset: ["Standard Doubles", "Dynamax Clause", "Swagger Clause"],
    banlist: ["DUber", "Power Construct", "Shadow Tag"]
  },
  {
    name: "[Gen 7] Doubles OU",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3661293/">USUM Doubles OU Metagame Discussion</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/posts/8394179/">USUM Doubles OU Viability Rankings</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/posts/8394190/">USUM Doubles OU Sample Teams</a>`
    ],
    mod: "gen7",
    gameType: "doubles",
    ruleset: ["Standard Doubles", "Swagger Clause"],
    banlist: ["DUber", "Power Construct", "Eevium Z", "Dark Void"]
  },
  {
    name: "[Gen 6] Doubles OU",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3606255/">ORAS Doubles OU Discussion</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/posts/7387213/">ORAS Doubles OU Viability Rankings</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/posts/7387215/">ORAS Doubles OU Sample Teams</a>`
    ],
    mod: "gen6",
    gameType: "doubles",
    ruleset: ["Standard Doubles", "Swagger Clause"],
    banlist: ["DUber", "Soul Dew", "Dark Void"]
  },
  {
    name: "[Gen 5] Doubles OU",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3606719/">BW2 Doubles Metagame Discussion</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/posts/7393048/">BW2 Doubles Viability Rankings</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/posts/7393081/">BW2 Doubles Sample Teams</a>`
    ],
    mod: "gen5",
    gameType: "doubles",
    searchShow: false,
    ruleset: ["Standard", "Evasion Abilities Clause", "Swagger Clause", "Sleep Clause Mod"],
    banlist: ["DUber", "Soul Dew", "Dark Void", "Gravity"]
  },
  {
    name: "[Gen 4] Doubles OU",
    threads: [`&bullet; <a href="https://www.smogon.com/forums/threads/3717286/">DPP Doubles</a>`],
    mod: "gen4",
    gameType: "doubles",
    searchShow: false,
    ruleset: ["Standard", "Evasion Abilities Clause"],
    banlist: ["AG", "Uber", "Soul Dew", "Dark Void"],
    unbanlist: ["Manaphy", "Mew", "Salamence", "Wobbuffet", "Wynaut"]
  },
  {
    name: "[Gen 3] Doubles OU",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3666831/">ADV Doubles OU</a>`
    ],
    mod: "gen3",
    gameType: "doubles",
    searchShow: false,
    ruleset: ["Standard", "!Switch Priority Clause Mod"],
    banlist: ["Uber", "Soul Dew", "Swagger"],
    unbanlist: ["Wobbuffet", "Wynaut"]
  },
  // Sw/Sh Singles
  ///////////////////////////////////////////////////////////////////
  {
    section: "Sw/Sh Singles",
    column: 4
  },
  {
    name: "[Gen 8] Ubers",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/posts/9462704/">SS Ubers</a>`
    ],
    mod: "gen8",
    searchShow: false,
    ruleset: ["Standard", "Dynamax Clause"],
    banlist: ["AG", "Shadow Tag", "Baton Pass"]
  },
  {
    name: "[Gen 8] UU",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3681331/">UU Metagame Discussion</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3679621/">UU Sample Teams</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3674793/">UU Viability Rankings</a>`
    ],
    mod: "gen8",
    searchShow: false,
    ruleset: ["[Gen 8] OU"],
    banlist: ["OU", "UUBL", "Light Clay"]
  },
  {
    name: "[Gen 8] RU",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3733236/">SS RU Resources</a>`
    ],
    mod: "gen8",
    searchShow: false,
    ruleset: ["[Gen 8] UU"],
    banlist: ["UU", "RUBL"]
  },
  {
    name: "[Gen 8] NU",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3687023/">NU Metagame Discussion</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3673598/">NU Sample Teams</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3676265/">NU Viability Rankings</a>`
    ],
    mod: "gen8",
    searchShow: false,
    ruleset: ["[Gen 8] RU"],
    banlist: ["RU", "NUBL", "Drizzle", "Drought", "Slush Rush"]
  },
  {
    name: "[Gen 8] PU",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3730849/">SS PU Resources</a>`
    ],
    mod: "gen8",
    searchShow: false,
    ruleset: ["[Gen 8] NU"],
    banlist: ["NU", "PUBL"]
  },
  {
    name: "[Gen 8] LC",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3724530/">SS LC Resources</a>`
    ],
    mod: "gen8",
    searchShow: false,
    ruleset: ["Little Cup", "Standard", "Dynamax Clause"],
    banlist: [
      "Corsola-Galar",
      "Cutiefly",
      "Drifloon",
      "Gastly",
      "Gothita",
      "Magby",
      "Rufflet",
      "Scraggy",
      "Scyther",
      "Sneasel",
      "Swirlix",
      "Tangela",
      "Vullaby",
      "Vulpix-Alola",
      "Woobat",
      "Zigzagoon-Base",
      "Chlorophyll",
      "Moody",
      "Baton Pass",
      "Sticky Web"
    ]
  },
  {
    name: "[Gen 8] Monotype",
    desc: `All the Pok&eacute;mon on a team must share a type.`,
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3710956/">SS Monotype Resources</a>`
    ],
    mod: "gen8",
    searchShow: false,
    ruleset: ["Same Type Clause", "Standard", "Evasion Abilities Clause", "Dynamax Clause"],
    banlist: [
      "Blaziken",
      "Calyrex-Ice",
      "Calyrex-Shadow",
      "Dialga",
      "Dracovish",
      "Eternatus",
      "Genesect",
      "Giratina",
      "Giratina-Origin",
      "Groudon",
      "Ho-Oh",
      "Kartana",
      "Kyogre",
      "Kyurem-Black",
      "Kyurem-White",
      "Landorus-Base",
      "Lugia",
      "Lunala",
      "Magearna",
      "Marshadow",
      "Mewtwo",
      "Naganadel",
      "Necrozma-Dawn-Wings",
      "Necrozma-Dusk-Mane",
      "Palkia",
      "Pheromosa",
      "Rayquaza",
      "Reshiram",
      "Solgaleo",
      "Urshifu-Base",
      "Xerneas",
      "Yveltal",
      "Zacian",
      "Zacian-Crowned",
      "Zamazenta",
      "Zamazenta-Crowned",
      "Zekrom",
      "Zygarde-Base",
      "Moody",
      "Power Construct",
      "Shadow Tag",
      "Damp Rock",
      "Focus Band",
      "King's Rock",
      "Quick Claw",
      "Smooth Rock",
      "Terrain Extender",
      "Acupressure",
      "Baton Pass"
    ]
  },
  {
    name: "[Gen 8] 1v1",
    desc: `Bring three Pok&eacute;mon to Team Preview and choose one to battle.`,
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/posts/8031457">SS 1v1 Resources</a>`
    ],
    mod: "gen8",
    searchShow: false,
    ruleset: [
      "Picked Team Size = 1",
      "Max Team Size = 3",
      "Obtainable",
      "Species Clause",
      "Nickname Clause",
      "OHKO Clause",
      "Evasion Moves Clause",
      "Accuracy Moves Clause",
      "Team Preview",
      "HP Percentage Mod",
      "Cancel Mod",
      "Dynamax Clause",
      "Endless Battle Clause"
    ],
    banlist: [
      "Calyrex-Ice",
      "Calyrex-Shadow",
      "Cinderace",
      "Dialga",
      "Dragonite",
      "Eternatus",
      "Genesect",
      "Giratina",
      "Giratina-Origin",
      "Groudon",
      "Ho-Oh",
      "Jirachi",
      "Kyogre",
      "Kyurem-Black",
      "Kyurem-White",
      "Lugia",
      "Lunala",
      "Magearna",
      "Marshadow",
      "Melmetal",
      "Mew",
      "Mewtwo",
      "Mimikyu",
      "Necrozma",
      "Necrozma-Dawn-Wings",
      "Necrozma-Dusk-Mane",
      "Palkia",
      "Rayquaza",
      "Reshiram",
      "Sableye",
      "Snorlax",
      "Solgaleo",
      "Victini",
      "Xerneas",
      "Yveltal",
      "Zacian",
      "Zacian-Crowned",
      "Zamazenta",
      "Zamazenta-Crowned",
      "Zekrom",
      "Moody",
      "Power Construct",
      "Bright Powder",
      "Focus Band",
      "Focus Sash",
      "Lax Incense",
      "Quick Claw",
      "Acupressure",
      "Hypnosis",
      "Perish Song",
      "Sing"
    ]
  },
  {
    name: "[Gen 8] Anything Goes",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/posts/9552584">SS AG Resources</a>`
    ],
    mod: "gen8",
    searchShow: false,
    ruleset: ["Obtainable", "Team Preview", "HP Percentage Mod", "Cancel Mod", "Endless Battle Clause"]
  },
  {
    name: "[Gen 8] ZU",
    desc: `The unofficial usage-based tier below PU.`,
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/posts/8034677">SS ZU Resources</a>`
    ],
    mod: "gen8",
    searchShow: false,
    ruleset: ["[Gen 8] PU"],
    banlist: ["PU", "ZUBL", "Damp Rock", "Grassy Seed"]
  },
  {
    name: "[Gen 8] CAP",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3656824/">SS CAP Metagame Discussion</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3671157/">SS CAP Sample Teams</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3674024/">SS CAP Viability Rankings</a>`
    ],
    mod: "gen8",
    searchShow: false,
    ruleset: ["[Gen 8] OU", "+CAP"],
    banlist: ["Crucibellite"]
  },
  {
    name: "[Gen 8] Battle Stadium Singles",
    mod: "gen8",
    searchShow: false,
    bestOfDefault: true,
    ruleset: ["Flat Rules", "!! Adjust Level = 50", "Min Source Gen = 8", "VGC Timer", "Limit Two Restricted"],
    restricted: ["Restricted Legendary"]
  },
  {
    name: "[Gen 8 BDSP] OU",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3693629/">BDSP OU Metagame Discussion</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3693721/">BDSP OU Sample Teams</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3696088/">BDSP OU Viability Rankings</a>`
    ],
    mod: "gen8bdsp",
    searchShow: false,
    ruleset: ["Standard", "Evasion Abilities Clause"],
    banlist: ["Uber", "Arena Trap", "Drizzle", "Moody", "Shadow Tag", "King's Rock", "Razor Fang", "Baton Pass"]
  },
  {
    name: "[Gen 8] Custom Game",
    mod: "gen8",
    searchShow: false,
    debug: true,
    battle: { trunc: Math.trunc },
    // no restrictions, for serious (other than team preview)
    ruleset: ["Team Preview", "Cancel Mod", "Max Team Size = 24", "Max Move Count = 24", "Max Level = 9999", "Default Level = 100"]
  },
  // Sw/Sh Doubles
  ///////////////////////////////////////////////////////////////////
  {
    section: "Sw/Sh Doubles",
    column: 4
  },
  {
    name: "[Gen 8] Doubles Ubers",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3661142/">Doubles Ubers</a>`
    ],
    mod: "gen8",
    gameType: "doubles",
    searchShow: false,
    ruleset: ["Standard Doubles", "!Gravity Sleep Clause"],
    banlist: []
  },
  {
    name: "[Gen 8] Doubles UU",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3658504/">Doubles UU</a>`
    ],
    mod: "gen8",
    gameType: "doubles",
    searchShow: false,
    ruleset: ["[Gen 8] Doubles OU"],
    banlist: ["DOU", "DBL"]
  },
  {
    name: "[Gen 8] VGC 2022",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3677186/">VGC 2022 Metagame Discussion</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3695848/">VGC 2022 Sample Teams</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3696395/">VGC 2022 Viability Rankings</a>`
    ],
    mod: "gen8",
    gameType: "doubles",
    searchShow: false,
    bestOfDefault: true,
    ruleset: ["Flat Rules", "!! Adjust Level = 50", "Min Source Gen = 8", "VGC Timer", "Limit Two Restricted"],
    restricted: ["Restricted Legendary"]
  },
  {
    name: "[Gen 8] VGC 2021",
    mod: "gen8",
    gameType: "doubles",
    searchShow: false,
    bestOfDefault: true,
    ruleset: ["Flat Rules", "!! Adjust Level = 50", "Min Source Gen = 8", "VGC Timer"]
  },
  {
    name: "[Gen 8] VGC 2020",
    mod: "gen8dlc1",
    gameType: "doubles",
    searchShow: false,
    bestOfDefault: true,
    ruleset: ["Flat Rules", "!! Adjust Level = 50", "Min Source Gen = 8", "VGC Timer"]
  },
  {
    name: "[Gen 8 BDSP] Doubles OU",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3693891/">BDSP Doubles OU</a>`
    ],
    mod: "gen8bdsp",
    gameType: "doubles",
    searchShow: false,
    ruleset: ["Standard Doubles"],
    banlist: ["DUber", "Dark Void"]
  },
  {
    name: "[Gen 8 BDSP] Battle Festival Doubles",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3694269/">Battle Festival Doubles</a>`
    ],
    mod: "gen8bdsp",
    gameType: "doubles",
    searchShow: false,
    ruleset: ["Flat Rules", "Min Source Gen = 8"]
  },
  {
    name: "[Gen 8] Doubles Custom Game",
    mod: "gen8",
    gameType: "doubles",
    searchShow: false,
    battle: { trunc: Math.trunc },
    debug: true,
    // no restrictions, for serious (other than team preview)
    ruleset: ["Team Preview", "Cancel Mod", "Max Team Size = 24", "Max Move Count = 24", "Max Level = 9999", "Default Level = 100"]
  },
  // US/UM Singles
  ///////////////////////////////////////////////////////////////////
  {
    section: "US/UM Singles",
    column: 4
  },
  {
    name: "[Gen 7] Ubers",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/posts/9462706/">USM Ubers</a>`
    ],
    mod: "gen7",
    searchShow: false,
    ruleset: ["Standard", "Mega Rayquaza Clause"],
    banlist: ["Baton Pass"]
  },
  {
    name: "[Gen 7] UU",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3621217/">USM UU Sample Teams</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3641346/">USM UU Viability Rankings</a>`
    ],
    mod: "gen7",
    searchShow: false,
    ruleset: ["[Gen 7] OU"],
    banlist: ["OU", "UUBL", "Drizzle", "Drought", "Kommonium Z", "Mewnium Z"]
  },
  {
    name: "[Gen 7] RU",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3733237/">USM RU Resources</a>`
    ],
    mod: "gen7",
    searchShow: false,
    ruleset: ["[Gen 7] UU"],
    banlist: ["UU", "RUBL", "Mimikyu", "Aurora Veil"],
    unbanlist: ["Drought"]
  },
  {
    name: "[Gen 7] NU",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3730730/">USM NU Resources</a>`
    ],
    mod: "gen7",
    searchShow: false,
    ruleset: ["[Gen 7] RU"],
    banlist: ["RU", "NUBL", "Drought"]
  },
  {
    name: "[Gen 7] PU",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3730846/">USM PU Resources</a>`
    ],
    mod: "gen7",
    searchShow: false,
    ruleset: ["[Gen 7] NU"],
    banlist: ["NU", "PUBL"]
  },
  {
    name: "[Gen 7] LC",
    threads: [
      `&bullet; <a href="https://www.smogon.com/dex/sm/formats/lc/">USM LC Banlist</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3639319/">USM LC Sample Teams</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3621440/">USM LC Viability Rankings</a>`
    ],
    mod: "gen7",
    searchShow: false,
    ruleset: ["Little Cup", "Standard", "Swagger Clause"],
    banlist: [
      "Aipom",
      "Cutiefly",
      "Drifloon",
      "Gligar",
      "Gothita",
      "Meditite",
      "Misdreavus",
      "Murkrow",
      "Porygon",
      "Scyther",
      "Sneasel",
      "Swirlix",
      "Tangela",
      "Trapinch",
      "Vulpix-Base",
      "Wingull",
      "Yanma",
      "Eevium Z",
      "Baton Pass",
      "Dragon Rage",
      "Sonic Boom",
      "Sticky Web"
    ]
  },
  {
    name: "[Gen 7] Monotype",
    desc: `All the Pok&eacute;mon on a team must share a type.`,
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/posts/8411581/">USM Monotype</a>`
    ],
    mod: "gen7",
    searchShow: false,
    ruleset: ["Same Type Clause", "Standard", "Evasion Abilities Clause", "Swagger Clause"],
    banlist: [
      "Aegislash",
      "Arceus",
      "Blaziken",
      "Darkrai",
      "Deoxys-Base",
      "Deoxys-Attack",
      "Dialga",
      "Genesect",
      "Gengar-Mega",
      "Giratina",
      "Giratina-Origin",
      "Groudon",
      "Ho-Oh",
      "Hoopa-Unbound",
      "Kangaskhan-Mega",
      "Kartana",
      "Kyogre",
      "Kyurem-White",
      "Lucario-Mega",
      "Lugia",
      "Lunala",
      "Magearna",
      "Marshadow",
      "Mawile-Mega",
      "Medicham-Mega",
      "Metagross-Mega",
      "Mewtwo",
      "Naganadel",
      "Necrozma-Dawn-Wings",
      "Necrozma-Dusk-Mane",
      "Palkia",
      "Pheromosa",
      "Rayquaza",
      "Reshiram",
      "Salamence-Mega",
      "Shaymin-Sky",
      "Solgaleo",
      "Tapu Lele",
      "Xerneas",
      "Yveltal",
      "Zekrom",
      "Zygarde",
      "Battle Bond",
      "Shadow Tag",
      "Damp Rock",
      "Focus Band",
      "King's Rock",
      "Quick Claw",
      "Razor Fang",
      "Smooth Rock",
      "Terrain Extender",
      "Baton Pass"
    ]
  },
  {
    name: "[Gen 7] 1v1",
    desc: `Bring three Pok&eacute;mon to Team Preview and choose one to battle.`,
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/posts/8031458/">USUM 1v1</a>`
    ],
    mod: "gen7",
    searchShow: false,
    ruleset: [
      "Picked Team Size = 1",
      "Max Team Size = 3",
      "Obtainable",
      "Species Clause",
      "Nickname Clause",
      "OHKO Clause",
      "Swagger Clause",
      "Evasion Moves Clause",
      "Accuracy Moves Clause",
      "Team Preview",
      "HP Percentage Mod",
      "Cancel Mod",
      "Endless Battle Clause"
    ],
    banlist: [
      "Arceus",
      "Darkrai",
      "Deoxys-Base",
      "Deoxys-Attack",
      "Deoxys-Defense",
      "Dialga",
      "Giratina",
      "Giratina-Origin",
      "Groudon",
      "Ho-Oh",
      "Kangaskhan-Mega",
      "Kyogre",
      "Kyurem-Black",
      "Kyurem-White",
      "Lugia",
      "Lunala",
      "Marshadow",
      "Mew",
      "Mewtwo",
      "Mimikyu",
      "Necrozma-Dawn-Wings",
      "Necrozma-Dusk-Mane",
      "Palkia",
      "Rayquaza",
      "Reshiram",
      "Salamence-Mega",
      "Shaymin-Sky",
      "Snorlax",
      "Solgaleo",
      "Tapu Koko",
      "Xerneas",
      "Yveltal",
      "Zekrom",
      "Moody",
      "Focus Sash",
      "Grass Whistle",
      "Hypnosis",
      "Perish Song",
      "Sing",
      "Detect + Fightinium Z"
    ]
  },
  {
    name: "[Gen 7] Anything Goes",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3587441/">Anything Goes Metagame Discussion</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3591711/">Anything Goes Viability Rankings</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3646736/">Anything Goes Sample Teams</a>`
    ],
    mod: "gen7",
    searchShow: false,
    ruleset: ["Obtainable", "Team Preview", "HP Percentage Mod", "Cancel Mod", "Endless Battle Clause"]
  },
  {
    name: "[Gen 7] ZU",
    desc: `The unofficial usage-based tier below PU.`,
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3646743/">ZU Metagame Discussion</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3643412/">ZU Viability Rankings</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3646739/">ZU Sample Teams</a>`
    ],
    mod: "gen7",
    searchShow: false,
    ruleset: ["[Gen 7] PU"],
    banlist: ["PU", "ZUBL"]
  },
  {
    name: "[Gen 7] CAP",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3621207/">USUM CAP Metagame Discussion</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/posts/8691482/">USUM CAP Viability Rankings</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/posts/8691484/">USUM CAP Sample Teams</a>`
    ],
    mod: "gen7",
    searchShow: false,
    ruleset: ["[Gen 7] OU", "+CAP"]
  },
  {
    name: "[Gen 7] Battle Spot Singles",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3601012/">Introduction to Battle Spot Singles</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3605970/">Battle Spot Singles Viability Rankings</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3601658/">Battle Spot Singles Role Compendium</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3619162/">Battle Spot Singles Sample Teams</a>`
    ],
    mod: "gen7",
    searchShow: false,
    bestOfDefault: true,
    ruleset: ["Flat Rules", "Min Source Gen = 6"],
    banlist: ["Battle Bond"]
  },
  {
    name: "[Gen 7 Let's Go] OU",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3667865/">LGPE OU Metagame Discussion</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3656868/">LGPE OU Viability Rankings</a>`
    ],
    mod: "gen7letsgo",
    searchShow: false,
    ruleset: ["Adjust Level = 50", "Obtainable", "Species Clause", "Nickname Clause", "OHKO Clause", "Evasion Moves Clause", "Team Preview", "HP Percentage Mod", "Cancel Mod", "Sleep Clause Mod"],
    banlist: ["Uber"]
  },
  {
    name: "[Gen 7] Custom Game",
    mod: "gen7",
    searchShow: false,
    debug: true,
    battle: { trunc: Math.trunc },
    // no restrictions, for serious (other than team preview)
    ruleset: ["Team Preview", "Cancel Mod", "Max Team Size = 24", "Max Move Count = 24", "Max Level = 9999", "Default Level = 100"]
  },
  // US/UM Doubles
  ///////////////////////////////////////////////////////////////////
  {
    section: "US/UM Doubles",
    column: 4
  },
  {
    name: "[Gen 7] Doubles UU",
    threads: [`&bullet; <a href="https://www.smogon.com/forums/threads/3598014/">Doubles UU Metagame Discussion</a>`],
    mod: "gen7",
    gameType: "doubles",
    searchShow: false,
    ruleset: ["[Gen 7] Doubles OU"],
    banlist: ["DOU", "DBL"]
  },
  {
    name: "[Gen 7] VGC 2019",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3641100/">VGC 2019 Discussion</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3641123/">VGC 2019 Viability Rankings</a>`
    ],
    mod: "gen7",
    gameType: "doubles",
    searchShow: false,
    bestOfDefault: true,
    ruleset: ["Flat Rules", "!! Adjust Level = 50", "Min Source Gen = 7", "VGC Timer", "Limit Two Restricted"],
    restricted: ["Restricted Legendary"],
    banlist: ["Unown", "Battle Bond"]
  },
  {
    name: "[Gen 7] VGC 2018",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3631800/">VGC 2018 Discussion</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3622041/">VGC 2018 Viability Rankings</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3628885/">VGC 2018 Sample Teams</a>`
    ],
    mod: "gen7",
    gameType: "doubles",
    searchShow: false,
    bestOfDefault: true,
    timer: {
      starting: 5 * 60,
      addPerTurn: 0,
      maxPerTurn: 55,
      maxFirstTurn: 90,
      grace: 90,
      timeoutAutoChoose: true,
      dcTimerBank: false
    },
    ruleset: ["Flat Rules", "!! Adjust Level = 50", "Min Source Gen = 7"],
    banlist: ["Oranguru + Symbiosis", "Passimian + Defiant", "Unown", "Custap Berry", "Enigma Berry", "Jaboca Berry", "Micle Berry", "Rowap Berry", "Battle Bond"]
  },
  {
    name: "[Gen 7] VGC 2017",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3583926/">VGC 2017 Discussion</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3591794/">VGC 2017 Viability Rankings</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3590391/">VGC 2017 Sample Teams</a>`
    ],
    mod: "gen7sm",
    gameType: "doubles",
    searchShow: false,
    bestOfDefault: true,
    timer: {
      starting: 15 * 60,
      addPerTurn: 0,
      maxPerTurn: 55,
      maxFirstTurn: 90,
      grace: 90,
      timeoutAutoChoose: true,
      dcTimerBank: false
    },
    ruleset: ["Flat Rules", "Old Alola Pokedex", "!! Adjust Level = 50", "Min Source Gen = 7"],
    banlist: ["Mega", "Custap Berry", "Enigma Berry", "Jaboca Berry", "Micle Berry", "Rowap Berry"]
  },
  {
    name: "[Gen 7] Battle Spot Doubles",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3595001/">Battle Spot Doubles Discussion</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3593890/">Battle Spot Doubles Viability Rankings</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3595859/">Battle Spot Doubles Sample Teams</a>`
    ],
    mod: "gen7",
    gameType: "doubles",
    searchShow: false,
    bestOfDefault: true,
    ruleset: ["Flat Rules", "Min Source Gen = 6"],
    banlist: ["Battle Bond"]
  },
  {
    name: "[Gen 7 Let's Go] Doubles OU",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3671748/#post-8685222">LGPE Doubles OU</a>`
    ],
    mod: "gen7letsgo",
    gameType: "doubles",
    searchShow: false,
    ruleset: ["Standard Doubles", "Sleep Clause Mod"],
    banlist: ["Mewtwo"]
  },
  {
    name: "[Gen 7] Doubles Custom Game",
    mod: "gen7",
    gameType: "doubles",
    searchShow: false,
    battle: { trunc: Math.trunc },
    debug: true,
    // no restrictions, for serious (other than team preview)
    ruleset: ["Team Preview", "Cancel Mod", "Max Team Size = 24", "Max Move Count = 24", "Max Level = 9999", "Default Level = 100"]
  },
  // OR/AS Singles
  ///////////////////////////////////////////////////////////////////
  {
    section: "OR/AS Singles",
    column: 4
  },
  {
    name: "[Gen 6] UU",
    threads: [
      `&bullet; <a href="https://www.smogon.com/dex/xy/formats/uu/">ORAS UU Banlist</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3598164/">ORAS UU Viability Rankings</a>`
    ],
    mod: "gen6",
    searchShow: false,
    ruleset: ["[Gen 6] OU"],
    banlist: ["OU", "UUBL", "Drizzle", "Drought"]
  },
  {
    name: "[Gen 6] Ubers",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/posts/9462707/">ORAS Ubers</a>`
    ],
    mod: "gen6",
    searchShow: false,
    ruleset: ["Standard", "Swagger Clause", "Mega Rayquaza Clause"]
  },
  {
    name: "[Gen 6] RU",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3733238/">ORAS RU Resources</a>`
    ],
    mod: "gen6",
    searchShow: false,
    ruleset: ["[Gen 6] UU"],
    banlist: ["UU", "RUBL"]
  },
  {
    name: "[Gen 6] NU",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3730794/">ORAS NU Resources</a>`
    ],
    mod: "gen6",
    searchShow: false,
    ruleset: ["[Gen 6] RU"],
    banlist: ["RU", "NUBL"]
  },
  {
    name: "[Gen 6] PU",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3730710/">ORAS PU Resources</a>`
    ],
    mod: "gen6",
    searchShow: false,
    ruleset: ["[Gen 6] NU"],
    banlist: ["NU", "PUBL", "Chatter"]
  },
  {
    name: "[Gen 6] LC",
    threads: [
      `&bullet; <a href="https://www.smogon.com/dex/xy/formats/lc/">ORAS LC Banlist</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3547566/">ORAS LC Viability Rankings</a>`
    ],
    mod: "gen6",
    searchShow: false,
    ruleset: ["Standard", "Little Cup"],
    banlist: [
      "Drifloon",
      "Gligar",
      "Meditite",
      "Misdreavus",
      "Murkrow",
      "Scyther",
      "Sneasel",
      "Swirlix",
      "Tangela",
      "Yanma",
      "Baton Pass",
      "Dragon Rage",
      "Sonic Boom",
      "Swagger"
    ]
  },
  {
    name: "[Gen 6] Monotype",
    desc: `All the Pok&eacute;mon on a team must share a type.`,
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/posts/8411583/">ORAS Monotype</a>`
    ],
    mod: "gen6",
    searchShow: false,
    ruleset: ["Standard", "Swagger Clause", "Evasion Abilities Clause", "Same Type Clause"],
    banlist: [
      "Aegislash",
      "Altaria-Mega",
      "Arceus",
      "Blaziken",
      "Darkrai",
      "Deoxys-Base",
      "Deoxys-Attack",
      "Deoxys-Speed",
      "Dialga",
      "Genesect",
      "Gengar-Mega",
      "Giratina",
      "Giratina-Origin",
      "Greninja",
      "Groudon",
      "Ho-Oh",
      "Hoopa-Unbound",
      "Kangaskhan-Mega",
      "Keldeo",
      "Kyogre",
      "Kyurem-White",
      "Lucario-Mega",
      "Lugia",
      "Mawile-Mega",
      "Medicham-Mega",
      "Metagross-Mega",
      "Mewtwo",
      "Palkia",
      "Rayquaza",
      "Reshiram",
      "Sableye-Mega",
      "Salamence-Mega",
      "Shaymin-Sky",
      "Slowbro-Mega",
      "Talonflame",
      "Xerneas",
      "Yveltal",
      "Zekrom",
      "Shadow Tag",
      "Damp Rock",
      "Focus Band",
      "King's Rock",
      "Quick Claw",
      "Razor Fang",
      "Smooth Rock",
      "Soul Dew",
      "Baton Pass"
    ]
  },
  {
    name: "[Gen 6] 1v1",
    desc: `Bring three Pok&eacute;mon to Team Preview and choose one to battle.`,
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/posts/8031459/">ORAS 1v1</a>`
    ],
    mod: "gen6",
    searchShow: false,
    ruleset: [
      "Max Team Size = 3",
      "Picked Team Size = 1",
      "Obtainable",
      "Nickname Clause",
      "Moody Clause",
      "OHKO Clause",
      "Evasion Moves Clause",
      "Accuracy Moves Clause",
      "Swagger Clause",
      "Endless Battle Clause",
      "HP Percentage Mod",
      "Cancel Mod",
      "Team Preview"
    ],
    banlist: [
      "Arceus",
      "Blaziken",
      "Charizard-Mega-Y",
      "Darkrai",
      "Deoxys-Base",
      "Deoxys-Attack",
      "Deoxys-Defense",
      "Dialga",
      "Giratina",
      "Giratina-Origin",
      "Groudon",
      "Ho-Oh",
      "Kangaskhan-Mega",
      "Kyogre",
      "Kyurem-White",
      "Lugia",
      "Mewtwo",
      "Palkia",
      "Rayquaza",
      "Reshiram",
      "Salamence-Mega",
      "Shaymin-Sky",
      "Snorlax",
      "Xerneas",
      "Yveltal",
      "Zekrom",
      "Focus Sash",
      "Soul Dew",
      "Grass Whistle",
      "Hypnosis",
      "Perish Song",
      "Sing",
      "Sleep Powder",
      "Yawn"
    ]
  },
  {
    name: "[Gen 6] Anything Goes",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3523229/">ORAS Anything Goes</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3548945/">ORAS AG Resources</a>`
    ],
    mod: "gen6",
    searchShow: false,
    ruleset: ["Obtainable", "Team Preview", "Endless Battle Clause", "HP Percentage Mod", "Cancel Mod"]
  },
  {
    name: "[Gen 6] ZU",
    threads: [
      `&bullet; <a href="https://www.smogon.com/dex/xy/formats/zu/">ORAS ZU Banlist</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/posts/8034679/">ORAS ZU Viability Rankings</a>`
    ],
    mod: "gen6",
    searchShow: false,
    ruleset: ["[Gen 6] PU"],
    banlist: ["PU", "ZUBL"]
  },
  {
    name: "[Gen 6] CAP",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3537407/">ORAS CAP Metagame Discussion</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/posts/8752281/">ORAS CAP Sample Teams</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/posts/8752280/">ORAS CAP Viability Rankings</a>`
    ],
    mod: "gen6",
    searchShow: false,
    ruleset: ["[Gen 6] OU", "+CAP"],
    banlist: ["Cawmodore"]
  },
  {
    name: "[Gen 6] Battle Spot Singles",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3527960/">ORAS Battle Spot Singles</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3554616/">ORAS BSS Viability Rankings</a>`
    ],
    mod: "gen6",
    searchShow: false,
    bestOfDefault: true,
    ruleset: ["Flat Rules", "Min Source Gen = 6"],
    banlist: ["Soul Dew"]
  },
  {
    name: "[Gen 6] Custom Game",
    mod: "gen6",
    searchShow: false,
    debug: true,
    battle: { trunc: Math.trunc },
    // no restrictions, for serious (other than team preview)
    ruleset: ["Team Preview", "Cancel Mod", "Max Team Size = 24", "Max Move Count = 24", "Max Level = 9999", "Default Level = 100"]
  },
  // OR/AS Doubles/Triples
  ///////////////////////////////////////////////////////////////////
  {
    section: "OR/AS Doubles/Triples",
    column: 4
  },
  {
    name: "[Gen 6] VGC 2016",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3558332/">VGC 2016 Rules</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3580592/">VGC 2016 Viability Rankings</a>`
    ],
    mod: "gen6",
    gameType: "doubles",
    searchShow: false,
    bestOfDefault: true,
    ruleset: ["Flat Rules", "Min Source Gen = 6", "Limit Two Restricted"],
    restricted: ["Restricted Legendary"],
    banlist: ["Soul Dew"]
  },
  {
    name: "[Gen 6] VGC 2015",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3524352/">VGC 2015 Rules</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3560820/">ORAS Battle Spot Doubles Discussion</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3530547/">VGC 2015 Viability Rankings</a>`
    ],
    mod: "gen6",
    gameType: "doubles",
    searchShow: false,
    bestOfDefault: true,
    ruleset: ["Flat Rules", "Min Source Gen = 6"],
    banlist: ["Soul Dew", "Articuno + Snow Cloak", "Zapdos + Static", "Moltres + Flame Body", "Dragonite + Barrier"]
  },
  {
    name: "[Gen 6] VGC 2014",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3493272/">VGC 2014 Rules</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3507789/">VGC 2014 Viability Rankings</a>`
    ],
    mod: "gen6xy",
    gameType: "doubles",
    searchShow: false,
    bestOfDefault: true,
    ruleset: ["Flat Rules", "Kalos Pokedex", "Min Source Gen = 6"]
  },
  {
    name: "[Gen 6] Battle Spot Doubles",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3560820/">ORAS Battle Spot Doubles Discussion</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3560824/">ORAS BSD Viability Rankings</a>`
    ],
    mod: "gen6",
    gameType: "doubles",
    searchShow: false,
    bestOfDefault: true,
    ruleset: ["Flat Rules", "Min Source Gen = 6"],
    banlist: ["Soul Dew"]
  },
  {
    name: "[Gen 6] Doubles Custom Game",
    mod: "gen6",
    gameType: "doubles",
    searchShow: false,
    battle: { trunc: Math.trunc },
    debug: true,
    // no restrictions, for serious (other than team preview)
    ruleset: ["Team Preview", "Cancel Mod", "Max Team Size = 24", "Max Move Count = 24", "Max Level = 9999", "Default Level = 100"]
  },
  {
    name: "[Gen 6] Battle Spot Triples",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3533914/">ORAS Battle Spot Triples Discussion</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3549201/">ORAS BST Viability Rankings</a>`
    ],
    mod: "gen6",
    gameType: "triples",
    searchShow: false,
    ruleset: ["Flat Rules", "Min Source Gen = 6"]
  },
  {
    name: "[Gen 6] Triples Custom Game",
    mod: "gen6",
    gameType: "triples",
    searchShow: false,
    battle: { trunc: Math.trunc },
    debug: true,
    // no restrictions, for serious (other than team preview)
    ruleset: ["Team Preview", "Cancel Mod", "Max Team Size = 24", "Max Move Count = 24", "Max Level = 9999", "Default Level = 100"]
  },
  // B2/W2 Singles
  ///////////////////////////////////////////////////////////////////
  {
    section: "B2/W2 Singles",
    column: 4
  },
  {
    name: "[Gen 5] Ubers",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/posts/9462708/">BW2 Ubers</a>`
    ],
    mod: "gen5",
    searchShow: false,
    ruleset: ["Standard", "Sleep Clause Mod"]
  },
  {
    name: "[Gen 5] UU",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3474024/">BW2 UU Viability Rankings</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/posts/6431094/">BW2 Sample Teams</a>`
    ],
    mod: "gen5",
    searchShow: false,
    ruleset: ["Standard", "Evasion Abilities Clause", "Swagger Clause", "Sleep Clause Mod"],
    banlist: ["Uber", "OU", "UUBL", "Arena Trap", "Drought", "Sand Stream", "Snow Warning", "Prankster + Assist", "Prankster + Copycat", "Baton Pass"]
  },
  {
    name: "[Gen 5] RU",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3733239/">BW2 RU Resources</a>`
    ],
    mod: "gen5",
    searchShow: false,
    ruleset: ["[Gen 5] UU", "Baton Pass Clause", "!Sleep Clause Mod", "Sleep Moves Clause"],
    banlist: ["UU", "RUBL", "Shadow Tag", "Shell Smash + Baton Pass"],
    unbanlist: ["Prankster + Assist", "Prankster + Copycat", "Baton Pass"]
  },
  {
    name: "[Gen 5] NU",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3731650/">BW2 NU Resources</a>`
    ],
    mod: "gen5",
    searchShow: false,
    ruleset: ["[Gen 5] RU", "!Sleep Moves Clause", "Sleep Clause Mod"],
    banlist: ["RU", "NUBL", "Assist", "Copycat"]
  },
  {
    name: "[Gen 5] PU",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3730796/">BW2 PU Resources</a>`
    ],
    mod: "gen5",
    searchShow: false,
    ruleset: ["[Gen 5] NU", "Sleep Moves Clause"],
    banlist: ["NU", "PUBL", "Damp Rock"]
  },
  {
    name: "[Gen 5] LC",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/posts/6431094/">BW2 Sample Teams</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3485860/">BW2 LC Viability Rankings</a>`
    ],
    mod: "gen5",
    searchShow: false,
    ruleset: ["Standard", "Little Cup", "Sleep Moves Clause"],
    banlist: [
      "Gligar",
      "Meditite",
      "Misdreavus",
      "Murkrow",
      "Scraggy",
      "Scyther",
      "Sneasel",
      "Tangela",
      "Vulpix",
      "Yanma",
      "Sand Rush",
      "Sand Veil",
      "Berry Juice",
      "Soul Dew",
      "Baton Pass",
      "Dragon Rage",
      "Sonic Boom",
      "Swagger"
    ]
  },
  {
    name: "[Gen 5] Monotype",
    desc: `All the Pok&eacute;mon on a team must share a type.`,
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/posts/8411584/">BW2 Monotype</a>`
    ],
    mod: "gen5",
    searchShow: false,
    ruleset: ["[Gen 5] OU", "Same Type Clause", "!Gems Clause"],
    banlist: ["Latios"]
  },
  {
    name: "[Gen 5] 1v1",
    desc: `Bring three Pok&eacute;mon to Team Preview and choose one to battle.`,
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/posts/8031460/">BW2 1v1</a>`
    ],
    mod: "gen5",
    searchShow: false,
    ruleset: [
      "Picked Team Size = 1",
      "Max Team Size = 3",
      "Standard",
      "Baton Pass Clause",
      "Swagger Clause",
      "Accuracy Moves Clause",
      "Sleep Moves Clause"
    ],
    banlist: [
      "Arceus",
      "Blaziken",
      "Cottonee",
      "Darkrai",
      "Deoxys",
      "Dialga",
      "Dragonite",
      "Giratina",
      "Groudon",
      "Ho-Oh",
      "Jirachi",
      "Kyogre",
      "Kyurem-Black",
      "Kyurem-White",
      "Lugia",
      "Mew",
      "Mewtwo",
      "Palkia",
      "Rayquaza",
      "Reshiram",
      "Shaymin-Sky",
      "Togekiss",
      "Victini",
      "Whimsicott",
      "Zekrom",
      "Focus Band",
      "Focus Sash",
      "Quick Claw",
      "Soul Dew",
      "Perish Song"
    ]
  },
  {
    name: "[Gen 5] ZU",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/posts/8034680/">BW2 ZU</a>`
    ],
    mod: "gen5",
    searchShow: false,
    ruleset: ["[Gen 5] PU"],
    banlist: [
      // PU
      "Audino",
      "Banette",
      "Beheeyem",
      "Bronzor",
      "Dodrio",
      "Duosion",
      "Dwebble",
      "Fraxure",
      "Gabite",
      "Golduck",
      "Huntail",
      "Jumpluff",
      "Klang",
      "Krokorok",
      "Mantine",
      "Maractus",
      "Mawile",
      "Monferno",
      "Murkrow",
      "Natu",
      "Purugly",
      "Rampardos",
      "Rapidash",
      "Relicanth",
      "Scraggy",
      "Shiftry",
      "Simisage",
      "Sneasel",
      "Stoutland",
      "Stunfisk",
      "Swanna",
      "Swoobat",
      "Tentacool",
      "Torterra",
      "Ursaring",
      "Victreebel",
      "Vileplume",
      "Volbeat",
      "Zebstrika",
      "Zweilous",
      // ZUBL
      "Articuno",
      "Dragonair",
      "Glalie",
      "Machoke",
      "Marowak",
      "Omanyte",
      "Regigigas",
      "Trubbish",
      "Whirlipede",
      "King's Rock",
      "Quick Claw",
      "Razor Fang",
      "Baton Pass"
    ],
    unbanlist: ["Damp Rock"]
  },
  {
    name: "[Gen 5] CAP",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/posts/8967093/">BW2 CAP Viability Rankings</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/posts/8969768/">BW2 CAP Sample Teams</a>`
    ],
    mod: "gen5",
    searchShow: false,
    ruleset: ["[Gen 5] OU", "+CAP"],
    banlist: ["Cawmodore"]
  },
  {
    name: "[Gen 5] GBU Singles",
    mod: "gen5",
    searchShow: false,
    bestOfDefault: true,
    ruleset: ["Flat Rules"],
    banlist: ["Dark Void", "Sky Drop", "Soul Dew"]
  },
  {
    name: "[Gen 5] Custom Game",
    mod: "gen5",
    searchShow: false,
    debug: true,
    battle: { trunc: Math.trunc },
    // no restrictions, for serious (other than team preview)
    ruleset: ["Team Preview", "Cancel Mod", "Max Team Size = 24", "Max Move Count = 24", "Max Level = 9999", "Default Level = 100"]
  },
  // B2/W2 Doubles
  ///////////////////////////////////////////////////////////////////
  {
    section: "B2/W2 Doubles",
    column: 4
  },
  {
    name: "[Gen 5] VGC 2013",
    mod: "gen5",
    gameType: "doubles",
    searchShow: false,
    bestOfDefault: true,
    ruleset: ["Flat Rules"],
    banlist: ["Chatot", "Dark Void", "Sky Drop", "Soul Dew"]
  },
  {
    name: "[Gen 5] VGC 2012",
    mod: "gen5bw1",
    gameType: "doubles",
    searchShow: false,
    bestOfDefault: true,
    ruleset: ["Flat Rules"],
    banlist: ["Dark Void", "Sky Drop"]
  },
  {
    name: "[Gen 5] VGC 2011",
    mod: "gen5bw1",
    gameType: "doubles",
    searchShow: false,
    bestOfDefault: true,
    ruleset: ["Flat Rules", "Old Unova Pokedex"],
    banlist: ["Sky Drop", "Belue Berry", "Durin Berry", "Nomel Berry", "Rabuta Berry", "Spelon Berry", "Watmel Berry"]
  },
  {
    name: "[Gen 5] Doubles Custom Game",
    mod: "gen5",
    gameType: "doubles",
    searchShow: false,
    debug: true,
    battle: { trunc: Math.trunc },
    // no restrictions, for serious (other than team preview)
    ruleset: ["Team Preview", "Cancel Mod", "Max Team Size = 24", "Max Move Count = 24", "Max Level = 9999", "Default Level = 100"]
  },
  {
    name: "[Gen 5] Triples Custom Game",
    mod: "gen5",
    gameType: "triples",
    searchShow: false,
    debug: true,
    battle: { trunc: Math.trunc },
    // no restrictions, for serious (other than team preview)
    ruleset: ["Team Preview", "Cancel Mod"]
  },
  // DPP Singles
  ///////////////////////////////////////////////////////////////////
  {
    section: "DPP Singles",
    column: 4
  },
  {
    name: "[Gen 4] Ubers",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/posts/9462709/">DPP Ubers</a>`
    ],
    mod: "gen4",
    searchShow: false,
    ruleset: ["Standard"],
    banlist: ["AG"]
  },
  {
    name: "[Gen 4] UU",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3532624/">DPP UU Metagame Discussion</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3503638/">DPP UU Viability Rankings</a>`
    ],
    mod: "gen4",
    searchShow: false,
    ruleset: ["[Gen 4] OU", "!Baton Pass Stat Trap Clause", "!Freeze Clause Mod"],
    banlist: ["OU", "UUBL", "Baton Pass"],
    unbanlist: ["Arena Trap", "Snow Cloak", "Quick Claw", "Swagger"]
  },
  {
    name: "[Gen 4] NU",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3731691/">DPP NU Resources</a>`
    ],
    mod: "gen4",
    searchShow: false,
    ruleset: ["[Gen 4] UU", "Baton Pass Clause"],
    banlist: ["UU", "NUBL"],
    unbanlist: ["Sand Veil", "Baton Pass"]
  },
  {
    name: "[Gen 4] PU",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3730821/">DPP PU Resources</a>`
    ],
    mod: "gen4",
    searchShow: false,
    ruleset: ["[Gen 4] NU"],
    banlist: [
      "Articuno",
      "Cacturne",
      "Charizard",
      "Cradily",
      "Dodrio",
      "Drifblim",
      "Dusclops",
      "Electrode",
      "Floatzel",
      "Gardevoir",
      "Gligar",
      "Golem",
      "Grumpig",
      "Haunter",
      "Hitmonchan",
      "Hypno",
      "Jumpluff",
      "Jynx",
      "Lickilicky",
      "Linoone",
      "Magmortar",
      "Magneton",
      "Manectric",
      "Medicham",
      "Meganium",
      "Nidoqueen",
      "Ninetales",
      "Piloswine",
      "Poliwrath",
      "Porygon2",
      "Regice",
      "Regirock",
      "Roselia",
      "Sandslash",
      "Sharpedo",
      "Shiftry",
      "Skuntank",
      "Slowking",
      "Tauros",
      "Typhlosion",
      "Venomoth",
      "Vileplume"
    ]
  },
  {
    name: "[Gen 4] LC",
    threads: [
      `&bullet; <a href="https://www.smogon.com/dp/articles/little_cup_guide">DPP LC Guide</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/posts/7336500/">DPP LC Viability Rankings</a>`
    ],
    mod: "gen4",
    searchShow: false,
    ruleset: ["Standard", "Little Cup", "Sleep Moves Clause"],
    banlist: [
      "Meditite",
      "Misdreavus",
      "Murkrow",
      "Scyther",
      "Sneasel",
      "Tangela",
      "Yanma",
      "Berry Juice",
      "Deep Sea Tooth",
      "Dragon Rage",
      "Sonic Boom",
      "Swagger"
    ]
  },
  {
    name: "[Gen 4] Anything Goes",
    mod: "gen4",
    searchShow: false,
    ruleset: ["Obtainable", "Arceus EV Limit", "Endless Battle Clause", "HP Percentage Mod", "Cancel Mod"]
  },
  {
    name: "[Gen 4] 1v1",
    desc: `Bring three Pok&eacute;mon to Team Preview and choose one to battle.`,
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/posts/8031462/">DPP 1v1</a>`
    ],
    mod: "gen4",
    searchShow: false,
    ruleset: [
      "Picked Team Size = 1",
      "Max Team Size = 3",
      "Standard",
      "Accuracy Moves Clause",
      "Sleep Moves Clause",
      "Team Preview"
    ],
    banlist: [
      "Arceus",
      "Darkrai",
      "Deoxys-Attack",
      "Deoxys-Base",
      "Deoxys-Defense",
      "Deoxys-Speed",
      "Dialga",
      "Garchomp",
      "Giratina",
      "Groudon",
      "Ho-Oh",
      "Jirachi",
      "Kyogre",
      "Latias",
      "Latios",
      "Lugia",
      "Machamp",
      "Manaphy",
      "Mew",
      "Mewtwo",
      "Palkia",
      "Porygon-Z",
      "Rayquaza",
      "Salamence",
      "Shaymin",
      "Shaymin-Sky",
      "Snorlax",
      "Togekiss",
      "Focus Band",
      "Focus Sash",
      "Quick Claw",
      "Soul Dew",
      "Destiny Bond",
      "Explosion",
      "Perish Song",
      "Self-Destruct"
    ]
  },
  {
    name: "[Gen 4] ZU",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/posts/8034681/">DPP ZU</a>`
    ],
    mod: "gen4",
    searchShow: false,
    ruleset: ["[Gen 4] PU"],
    banlist: [
      "Ampharos",
      "Armaldo",
      "Bellossom",
      "Dragonair",
      "Electabuzz",
      "Gabite",
      "Gastrodon",
      "Glaceon",
      "Glalie",
      "Golduck",
      "Gorebyss",
      "Hippopotas",
      "Kadabra",
      "Kingler",
      "Lapras",
      "Machoke",
      "Magmar",
      "Mantine",
      "Marowak",
      "Metang",
      "Misdreavus",
      "Monferno",
      "Mr. Mime",
      "Muk",
      "Murkrow",
      "Pinsir",
      "Politoed",
      "Purugly",
      "Quagsire",
      "Raichu",
      "Rampardos",
      "Rapidash",
      "Regigigas",
      "Relicanth",
      "Rhydon",
      "Scyther",
      "Sneasel",
      "Snover",
      "Solrock",
      "Tangela",
      "Torkoal",
      "Victreebel",
      "Xatu",
      "Walrein",
      "Zangoose",
      "Damp Rock"
    ]
  },
  {
    name: "[Gen 4] CAP",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/posts/8851251/">DPP CAP Viability Rankings</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/posts/8869378/">DPP CAP Sample Teams</a>`
    ],
    mod: "gen4",
    searchShow: false,
    ruleset: ["[Gen 4] OU", "+CAP"]
  },
  {
    name: "[Gen 4] Custom Game",
    mod: "gen4",
    searchShow: false,
    debug: true,
    battle: { trunc: Math.trunc },
    // no restrictions
    ruleset: ["Cancel Mod", "Max Team Size = 24", "Max Move Count = 24", "Max Level = 9999", "Default Level = 100"]
  },
  // DPP Doubles
  ///////////////////////////////////////////////////////////////////
  {
    section: "DPP Doubles",
    column: 4
  },
  {
    name: "[Gen 4] VGC 2010",
    mod: "gen4",
    gameType: "doubles",
    searchShow: false,
    ruleset: ["Flat Rules", "Min Team Size = 4", "Max Team Size = 4", "Limit Two Restricted"],
    restricted: ["Restricted Legendary"],
    banlist: ["Soul Dew"]
  },
  {
    name: "[Gen 4] VGC 2009",
    mod: "gen4pt",
    gameType: "doubles",
    searchShow: false,
    ruleset: ["Flat Rules", "! Adjust Level Down", "Max Level = 50", "Min Team Size = 4", "Max Team Size = 4"],
    banlist: ["Tyranitar", "Rotom", "Judgment", "Soul Dew"]
  },
  {
    name: "[Gen 4] Doubles Custom Game",
    mod: "gen4",
    gameType: "doubles",
    searchShow: false,
    debug: true,
    battle: { trunc: Math.trunc },
    // no restrictions
    ruleset: ["Cancel Mod", "Max Team Size = 24", "Max Move Count = 24", "Max Level = 9999", "Default Level = 100"]
  },
  // Past Generations
  ///////////////////////////////////////////////////////////////////
  {
    section: "Past Generations",
    column: 4
  },
  {
    name: "[Gen 3] Ubers",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/posts/9462710/">ADV Ubers</a>`
    ],
    mod: "gen3",
    searchShow: false,
    ruleset: ["Standard", "Deoxys Camouflage Clause", "One Baton Pass Clause"],
    banlist: ["Wobbuffet + Leftovers", "Baton Pass"]
  },
  {
    name: "[Gen 3] NU",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3730732/">ADV NU Resources</a>`
    ],
    mod: "gen3",
    searchShow: false,
    ruleset: ["Standard"],
    banlist: ["Uber", "OU", "UUBL", "UU", "Smeargle + Ingrain"]
  },
  {
    name: "[Gen 3] PU",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3729689">ADV PU</a>`
    ],
    mod: "gen3",
    searchShow: false,
    ruleset: ["Standard", "Baton Pass Stat Clause"],
    banlist: ["Uber", "OU", "UUBL", "UU", "NUBL", "NU", "PUBL"]
  },
  {
    name: "[Gen 3] ZU",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/posts/8034684">ADV ZU</a>`
    ],
    mod: "gen3",
    searchShow: false,
    ruleset: ["Standard", "Baton Pass Stat Trap Clause"],
    banlist: ["Uber", "OU", "UUBL", "UU", "NUBL", "NU", "PUBL", "PU", "ZUBL", "Baton Pass + Substitute"]
  },
  {
    name: "[Gen 3] 1v1",
    desc: `Bring three Pok&eacute;mon to Team Preview and choose one to battle.`,
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/posts/8031463/">ADV 1v1</a>`
    ],
    mod: "gen3",
    searchShow: false,
    ruleset: [
      "Picked Team Size = 1",
      "Max Team Size = 3",
      "Standard",
      "Accuracy Moves Clause",
      "Sleep Moves Clause",
      "Team Preview"
    ],
    banlist: [
      "Clefable",
      "Deoxys",
      "Deoxys-Attack",
      "Deoxys-Defense",
      "Deoxys-Speed",
      "Groudon",
      "Ho-Oh",
      "Kyogre",
      "Latias",
      "Latios",
      "Lugia",
      "Mew",
      "Mewtwo",
      "Rayquaza",
      "Slaking",
      "Snorlax",
      "Suicune",
      "Zapdos",
      "Destiny Bond",
      "Explosion",
      "Perish Song",
      "Self-Destruct",
      "Focus Band",
      "King's Rock",
      "Quick Claw"
    ]
  },
  {
    name: "[Gen 3] Custom Game",
    mod: "gen3",
    searchShow: false,
    debug: true,
    battle: { trunc: Math.trunc },
    ruleset: ["HP Percentage Mod", "Cancel Mod", "Max Team Size = 24", "Max Move Count = 24", "Max Level = 9999", "Default Level = 100"]
  },
  {
    name: "[Gen 3] Doubles Custom Game",
    mod: "gen3",
    gameType: "doubles",
    searchShow: false,
    debug: true,
    ruleset: ["HP Percentage Mod", "Cancel Mod", "Max Team Size = 24", "Max Move Count = 24", "Max Level = 9999", "Default Level = 100"]
  },
  {
    name: "[Gen 2] Ubers",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/posts/9462711/">GSC Ubers</a>`
    ],
    mod: "gen2",
    searchShow: false,
    ruleset: ["Standard"]
  },
  {
    name: "[Gen 2] UU",
    threads: [`&bullet; <a href="https://www.smogon.com/forums/threads/3576710/">GSC UU</a>`],
    mod: "gen2",
    searchShow: false,
    ruleset: ["[Gen 2] OU"],
    banlist: ["OU", "UUBL", "Agility + Baton Pass"],
    unbanlist: ["Mean Look + Baton Pass", "Spider Web + Baton Pass"]
  },
  {
    name: "[Gen 2] NU",
    threads: [`&bullet; <a href="https://www.smogon.com/forums/threads/3642565/">GSC NU</a>`],
    mod: "gen2",
    searchShow: false,
    ruleset: ["[Gen 2] UU"],
    banlist: ["UU", "NUBL", "Swagger"],
    unbanlist: ["Agility + Baton Pass"]
  },
  {
    name: "[Gen 2] PU",
    threads: [`&bullet; <a href="https://www.smogon.com/forums/threads/3671458/">GSC PU</a>`],
    mod: "gen2",
    searchShow: false,
    ruleset: ["[Gen 2] NU"],
    banlist: ["NU", "PUBL"],
    unbanlist: ["Swagger"]
  },
  {
    name: "[Gen 2] 1v1",
    threads: [`&bullet; <a href="https://www.smogon.com/forums/posts/8031464/">GSC 1v1</a>`],
    mod: "gen2",
    searchShow: false,
    ruleset: [
      "Picked Team Size = 1",
      "Max Team Size = 3",
      "Standard",
      "Accuracy Moves Clause",
      "Sleep Moves Clause",
      "Team Preview"
    ],
    banlist: [
      "Alakazam",
      "Celebi",
      "Clefable",
      "Ho-Oh",
      "Lugia",
      "Mew",
      "Mewtwo",
      "Snorlax",
      "Zapdos",
      "Berserk Gene",
      "Focus Band",
      "King's Rock",
      "Quick Claw",
      "Attract",
      "Destiny Bond",
      "Explosion",
      "Perish Song",
      "Present",
      "Self-Destruct",
      "Swagger"
    ]
  },
  {
    name: "[Gen 2] NC 2000",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3682691/">NC 2000 Resource Hub</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3677370/">Differences between NC 2000 and GSC OU</a>`
    ],
    mod: "gen2stadium2",
    searchShow: false,
    ruleset: [
      "Picked Team Size = 3",
      "Min Level = 50",
      "Max Level = 55",
      "Max Total Level = 155",
      "Obtainable",
      "Stadium Sleep Clause",
      "Freeze Clause Mod",
      "Species Clause",
      "Item Clause",
      "Endless Battle Clause",
      "Cancel Mod",
      "Event Moves Clause",
      "Nickname Clause",
      "Team Preview",
      "NC 2000 Move Legality"
    ],
    banlist: ["Uber"]
  },
  {
    name: "[Gen 2] Stadium OU",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3677370/">Placeholder</a>`
    ],
    mod: "gen2stadium2",
    searchShow: false,
    ruleset: ["Standard"],
    banlist: ["Uber"]
  },
  {
    name: "[Gen 2] Custom Game",
    mod: "gen2",
    searchShow: false,
    debug: true,
    battle: { trunc: Math.trunc },
    ruleset: ["HP Percentage Mod", "Cancel Mod", "Max Team Size = 24", "Max Move Count = 24", "Max Level = 9999", "Default Level = 100"]
  },
  {
    name: "[Gen 1] Ubers",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/posts/9462712/">RBY Ubers</a>`
    ],
    mod: "gen1",
    searchShow: false,
    ruleset: ["Standard"]
  },
  {
    name: "[Gen 1] UU",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3573896/">RBY UU Metagame Discussion</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3647713/">RBY UU Viability Rankings</a>`
    ],
    mod: "gen1",
    searchShow: false,
    ruleset: ["[Gen 1] OU", "APT Clause"],
    banlist: ["OU", "UUBL"]
  },
  {
    name: "[Gen 1] PU",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3700527/">RBY PU Metagame Discussion &amp; Resources</a>`
    ],
    mod: "gen1",
    searchShow: false,
    ruleset: ["[Gen 1] NU"],
    banlist: ["NU", "PUBL"]
  },
  {
    name: "[Gen 1] 1v1",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/posts/8031468">RBY 1v1</a>`
    ],
    mod: "gen1",
    searchShow: false,
    ruleset: [
      "Picked Team Size = 1",
      "Max Team Size = 3",
      "Standard",
      "Accuracy Moves Clause",
      "Sleep Moves Clause",
      "Team Preview"
    ],
    banlist: ["Mew", "Mewtwo", "Bind", "Clamp", "Explosion", "Fire Spin", "Self-Destruct", "Wrap"]
  },
  {
    name: "[Gen 1] Japanese OU",
    desc: `Generation 1 with Japanese battle mechanics.`,
    mod: "gen1jpn",
    searchShow: false,
    ruleset: ["Standard"],
    banlist: ["Uber"]
  },
  {
    name: "[Gen 1] Stadium OU",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3685877/">Stadium OU Viability Rankings</a>`
    ],
    mod: "gen1stadium",
    searchShow: false,
    ruleset: ["Standard", "Team Preview"],
    banlist: [
      "Uber",
      "Nidoking + Fury Attack + Thrash",
      "Exeggutor + Poison Powder + Stomp",
      "Exeggutor + Sleep Powder + Stomp",
      "Exeggutor + Stun Spore + Stomp",
      "Jolteon + Focus Energy + Thunder Shock",
      "Flareon + Focus Energy + Ember"
    ]
  },
  {
    name: "[Gen 1] Tradebacks OU",
    desc: `RBY OU with movepool additions from the Time Capsule.`,
    threads: [
      `&bullet; <a href="https://www.smogon.com/articles/rby-tradebacks-ou">RBY Tradebacks OU</a>`
    ],
    mod: "gen1",
    searchShow: false,
    ruleset: ["[Gen 1] OU", "Allow Tradeback"]
  },
  {
    name: "[Gen 1] NC 1997",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3682412/">NC 1997 Discussion &amp; Resources</a>`
    ],
    mod: "gen1jpn",
    searchShow: false,
    ruleset: [
      "Picked Team Size = 3",
      "Min Level = 50",
      "Max Level = 55",
      "Max Total Level = 155",
      "Obtainable",
      "Team Preview",
      "Stadium Sleep Clause",
      "Species Clause",
      "Nickname Clause",
      "HP Percentage Mod",
      "Cancel Mod",
      "NC 1997 Move Legality"
    ],
    banlist: ["Uber"]
  },
  {
    name: "[Gen 1] Custom Game",
    mod: "gen1",
    searchShow: false,
    debug: true,
    battle: { trunc: Math.trunc },
    ruleset: ["HP Percentage Mod", "Cancel Mod", "Desync Clause Mod", "Max Team Size = 24", "Max Move Count = 24", "Max Level = 9999", "Default Level = 100"]
  }
];
//# sourceMappingURL=formats.js.map
