"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var moves_exports = {};
__export(moves_exports, {
  Moves: () => Moves
});
module.exports = __toCommonJS(moves_exports);
const Moves = {
  "10000000voltthunderbolt": {
    inherit: true,
    isNonstandard: null
  },
  aciddownpour: {
    inherit: true,
    isNonstandard: null
  },
  alloutpummeling: {
    inherit: true,
    isNonstandard: null
  },
  assist: {
    inherit: true,
    isNonstandard: null
  },
  baddybad: {
    inherit: true,
    accuracy: 100,
    basePower: 90
  },
  barrage: {
    inherit: true,
    isNonstandard: null
  },
  barrier: {
    inherit: true,
    isNonstandard: null
  },
  beakblast: {
    inherit: true,
    isNonstandard: null
  },
  bestow: {
    inherit: true,
    isNonstandard: null
  },
  bide: {
    inherit: true,
    isNonstandard: null
  },
  blackholeeclipse: {
    inherit: true,
    isNonstandard: null
  },
  bloomdoom: {
    inherit: true,
    isNonstandard: null
  },
  boneclub: {
    inherit: true,
    isNonstandard: null
  },
  bouncybubble: {
    inherit: true,
    basePower: 90,
    pp: 15
  },
  breakneckblitz: {
    inherit: true,
    isNonstandard: null
  },
  bubble: {
    inherit: true,
    isNonstandard: null
  },
  buzzybuzz: {
    inherit: true,
    basePower: 90,
    pp: 15
  },
  camouflage: {
    inherit: true,
    isNonstandard: null
  },
  captivate: {
    inherit: true,
    isNonstandard: null
  },
  catastropika: {
    inherit: true,
    isNonstandard: null
  },
  chatter: {
    inherit: true,
    isNonstandard: null
  },
  chipaway: {
    inherit: true,
    isNonstandard: null
  },
  clamp: {
    inherit: true,
    isNonstandard: null
  },
  clangoroussoulblaze: {
    inherit: true,
    isNonstandard: null
  },
  cometpunch: {
    inherit: true,
    isNonstandard: null
  },
  constrict: {
    inherit: true,
    isNonstandard: null
  },
  continentalcrush: {
    inherit: true,
    isNonstandard: null
  },
  corkscrewcrash: {
    inherit: true,
    isNonstandard: null
  },
  curse: {
    inherit: true,
    target: "normal"
  },
  darkvoid: {
    inherit: true,
    isNonstandard: null
  },
  defog: {
    inherit: true,
    onHit(target, source, move) {
      let success = false;
      if (!target.volatiles["substitute"] || move.infiltrates)
        success = !!this.boost({ evasion: -1 });
      const removeTarget = [
        "reflect",
        "lightscreen",
        "auroraveil",
        "safeguard",
        "mist",
        "spikes",
        "toxicspikes",
        "stealthrock",
        "stickyweb"
      ];
      const removeAll = ["spikes", "toxicspikes", "stealthrock", "stickyweb"];
      for (const targetCondition of removeTarget) {
        if (target.side.removeSideCondition(targetCondition)) {
          if (!removeAll.includes(targetCondition))
            continue;
          this.add("-sideend", target.side, this.dex.conditions.get(targetCondition).name, "[from] move: Defog", "[of] " + source);
          success = true;
        }
      }
      for (const sideCondition of removeAll) {
        if (source.side.removeSideCondition(sideCondition)) {
          this.add("-sideend", source.side, this.dex.conditions.get(sideCondition).name, "[from] move: Defog", "[of] " + source);
          success = true;
        }
      }
      return success;
    }
  },
  devastatingdrake: {
    inherit: true,
    isNonstandard: null
  },
  dive: {
    inherit: true,
    flags: {
      contact: 1,
      charge: 1,
      protect: 1,
      mirror: 1,
      nonsky: 1,
      metronome: 1,
      nosleeptalk: 1,
      noassist: 1,
      failinstruct: 1
    }
  },
  dizzypunch: {
    inherit: true,
    isNonstandard: null
  },
  doubleironbash: {
    inherit: true,
    isNonstandard: "LGPE"
  },
  doubleslap: {
    inherit: true,
    isNonstandard: null
  },
  dragonhammer: {
    inherit: true,
    flags: { contact: 1, protect: 1, mirror: 1, metronome: 1 }
  },
  dragonrage: {
    inherit: true,
    isNonstandard: null
  },
  eggbomb: {
    inherit: true,
    isNonstandard: null
  },
  electricterrain: {
    inherit: true,
    condition: {
      duration: 5,
      durationCallback(source, effect) {
        if (source?.hasItem("terrainextender")) {
          return 8;
        }
        return 5;
      },
      onSetStatus(status, target, source, effect) {
        if (status.id === "slp" && target.isGrounded() && !target.isSemiInvulnerable()) {
          if (effect.id === "yawn" || effect.effectType === "Move" && !effect.secondaries) {
            this.add("-activate", target, "move: Electric Terrain");
          }
          return false;
        }
      },
      onTryAddVolatile(status, target) {
        if (!target.isGrounded() || target.isSemiInvulnerable())
          return;
        if (status.id === "yawn") {
          this.add("-activate", target, "move: Electric Terrain");
          return null;
        }
      },
      onBasePower(basePower, attacker, defender, move) {
        if (move.type === "Electric" && attacker.isGrounded() && !attacker.isSemiInvulnerable()) {
          this.debug("electric terrain boost");
          return this.chainModify(1.5);
        }
      },
      onFieldStart(field, source, effect) {
        if (effect && effect.effectType === "Ability") {
          this.add("-fieldstart", "move: Electric Terrain", "[from] ability: " + effect, "[of] " + source);
        } else {
          this.add("-fieldstart", "move: Electric Terrain");
        }
      },
      onFieldResidualOrder: 27,
      onFieldResidualSubOrder: 7,
      onFieldEnd() {
        this.add("-fieldend", "move: Electric Terrain");
      }
    }
  },
  embargo: {
    inherit: true,
    isNonstandard: null
  },
  extremeevoboost: {
    inherit: true,
    isNonstandard: null
  },
  feintattack: {
    inherit: true,
    isNonstandard: null
  },
  flameburst: {
    inherit: true,
    isNonstandard: null
  },
  flash: {
    inherit: true,
    isNonstandard: null
  },
  floralhealing: {
    inherit: true,
    onHit(target, source) {
      let success = false;
      if (this.field.isTerrain("grassyterrain")) {
        success = !!this.heal(this.modify(target.baseMaxhp, 0.667));
      } else {
        success = !!this.heal(Math.ceil(target.baseMaxhp * 0.5));
      }
      if (success && !target.isAlly(source)) {
        target.staleness = "external";
      }
      if (!success) {
        this.add("-fail", target, "heal");
        return null;
      }
      return success;
    }
  },
  fly: {
    inherit: true,
    onTryMove(attacker, defender, move) {
      if (attacker.removeVolatile(move.id)) {
        return;
      }
      this.add("-prepare", attacker, move.name);
      if (!this.runEvent("ChargeMove", attacker, defender, move)) {
        return;
      }
      attacker.addVolatile("twoturnmove", defender);
      return null;
    }
  },
  foresight: {
    inherit: true,
    isNonstandard: null
  },
  freezyfrost: {
    inherit: true,
    accuracy: 100,
    basePower: 90,
    pp: 15
  },
  frustration: {
    inherit: true,
    isNonstandard: null
  },
  genesissupernova: {
    inherit: true,
    isNonstandard: null
  },
  gigavolthavoc: {
    inherit: true,
    isNonstandard: null
  },
  glitzyglow: {
    inherit: true,
    accuracy: 100,
    basePower: 90
  },
  grassknot: {
    inherit: true,
    onTryHit() {
    }
  },
  grasswhistle: {
    inherit: true,
    isNonstandard: null
  },
  grassyterrain: {
    inherit: true,
    condition: {
      duration: 5,
      durationCallback(source, effect) {
        if (source?.hasItem("terrainextender")) {
          return 8;
        }
        return 5;
      },
      onBasePower(basePower, attacker, defender, move) {
        const weakenedMoves = ["earthquake", "bulldoze", "magnitude"];
        if (weakenedMoves.includes(move.id) && defender.isGrounded() && !defender.isSemiInvulnerable()) {
          this.debug("move weakened by grassy terrain");
          return this.chainModify(0.5);
        }
        if (move.type === "Grass" && attacker.isGrounded()) {
          this.debug("grassy terrain boost");
          return this.chainModify(1.5);
        }
      },
      onFieldStart(field, source, effect) {
        if (effect && effect.effectType === "Ability") {
          this.add("-fieldstart", "move: Grassy Terrain", "[from] ability: " + effect, "[of] " + source);
        } else {
          this.add("-fieldstart", "move: Grassy Terrain");
        }
      },
      onResidualOrder: 5,
      onResidualSubOrder: 2,
      onResidual(pokemon) {
        if (pokemon.isGrounded() && !pokemon.isSemiInvulnerable()) {
          this.heal(pokemon.baseMaxhp / 16, pokemon, pokemon);
        } else {
          this.debug(`Pokemon semi-invuln or not grounded; Grassy Terrain skipped`);
        }
      },
      onFieldResidualOrder: 27,
      onFieldResidualSubOrder: 7,
      onFieldEnd() {
        this.add("-fieldend", "move: Grassy Terrain");
      }
    }
  },
  guardianofalola: {
    inherit: true,
    isNonstandard: null
  },
  healbell: {
    inherit: true,
    onHit(target, source) {
      this.add("-activate", source, "move: Heal Bell");
      let success = false;
      const allies = [...target.side.pokemon, ...target.side.allySide?.pokemon || []];
      for (const ally of allies) {
        if (ally.hasAbility("soundproof"))
          continue;
        if (ally.cureStatus())
          success = true;
      }
      return success;
    }
  },
  healblock: {
    inherit: true,
    isNonstandard: null
  },
  healingwish: {
    inherit: true,
    condition: {
      duration: 2,
      onSwitchInPriority: 1,
      onSwitchIn(target) {
        if (!target.fainted) {
          target.heal(target.maxhp);
          target.clearStatus();
          this.add("-heal", target, target.getHealth, "[from] move: Healing Wish");
          target.side.removeSlotCondition(target, "healingwish");
        }
      }
    }
  },
  healorder: {
    inherit: true,
    isNonstandard: null
  },
  healpulse: {
    inherit: true,
    onHit(target, source) {
      let success = false;
      if (source.hasAbility("megalauncher")) {
        success = !!this.heal(this.modify(target.baseMaxhp, 0.75));
      } else {
        success = !!this.heal(Math.ceil(target.baseMaxhp * 0.5));
      }
      if (success && !target.isAlly(source)) {
        target.staleness = "external";
      }
      if (!success) {
        this.add("-fail", target, "heal");
        return null;
      }
      return success;
    }
  },
  heartstamp: {
    inherit: true,
    isNonstandard: null
  },
  heartswap: {
    inherit: true,
    isNonstandard: null
  },
  heatcrash: {
    inherit: true,
    onTryHit() {
    }
  },
  heavyslam: {
    inherit: true,
    onTryHit() {
    }
  },
  hiddenpower: {
    inherit: true,
    isNonstandard: null
  },
  hiddenpowerbug: {
    inherit: true,
    isNonstandard: null
  },
  hiddenpowerdark: {
    inherit: true,
    isNonstandard: null
  },
  hiddenpowerdragon: {
    inherit: true,
    isNonstandard: null
  },
  hiddenpowerelectric: {
    inherit: true,
    isNonstandard: null
  },
  hiddenpowerfighting: {
    inherit: true,
    isNonstandard: null
  },
  hiddenpowerfire: {
    inherit: true,
    isNonstandard: null
  },
  hiddenpowerflying: {
    inherit: true,
    isNonstandard: null
  },
  hiddenpowerghost: {
    inherit: true,
    isNonstandard: null
  },
  hiddenpowergrass: {
    inherit: true,
    isNonstandard: null
  },
  hiddenpowerground: {
    inherit: true,
    isNonstandard: null
  },
  hiddenpowerice: {
    inherit: true,
    isNonstandard: null
  },
  hiddenpowerpoison: {
    inherit: true,
    isNonstandard: null
  },
  hiddenpowerpsychic: {
    inherit: true,
    isNonstandard: null
  },
  hiddenpowerrock: {
    inherit: true,
    isNonstandard: null
  },
  hiddenpowersteel: {
    inherit: true,
    isNonstandard: null
  },
  hiddenpowerwater: {
    inherit: true,
    isNonstandard: null
  },
  howl: {
    inherit: true,
    flags: { snatch: 1, metronome: 1 },
    boosts: {
      atk: 1
    },
    target: "self"
  },
  hydrovortex: {
    inherit: true,
    isNonstandard: null
  },
  hyperfang: {
    inherit: true,
    isNonstandard: null
  },
  hyperspacefury: {
    inherit: true,
    isNonstandard: null
  },
  hyperspacehole: {
    inherit: true,
    isNonstandard: null
  },
  iceball: {
    inherit: true,
    isNonstandard: null
  },
  icehammer: {
    inherit: true,
    isNonstandard: null
  },
  infernooverdrive: {
    inherit: true,
    isNonstandard: null
  },
  iondeluge: {
    inherit: true,
    isNonstandard: null
  },
  judgment: {
    inherit: true,
    isNonstandard: null
  },
  jumpkick: {
    inherit: true,
    isNonstandard: null
  },
  karatechop: {
    inherit: true,
    isNonstandard: null
  },
  kingsshield: {
    inherit: true,
    condition: {
      duration: 1,
      onStart(target) {
        this.add("-singleturn", target, "Protect");
      },
      onTryHitPriority: 3,
      onTryHit(target, source, move) {
        if (!move.flags["protect"] || move.category === "Status") {
          if (move.isZ || move.isMax)
            target.getMoveHitData(move).zBrokeProtect = true;
          return;
        }
        this.add("-activate", target, "move: Protect");
        const lockedmove = source.getVolatile("lockedmove");
        if (lockedmove) {
          if (source.volatiles["lockedmove"].duration === 2) {
            delete source.volatiles["lockedmove"];
          }
        }
        if (this.checkMoveMakesContact(move, source, target)) {
          this.boost({ atk: -2 }, source, target, this.dex.getActiveMove("King's Shield"));
        }
        return this.NOT_FAIL;
      },
      onHit(target, source, move) {
        if (move.isZOrMaxPowered && this.checkMoveMakesContact(move, source, target)) {
          this.boost({ atk: -2 }, source, target, this.dex.getActiveMove("King's Shield"));
        }
      }
    }
  },
  letssnuggleforever: {
    inherit: true,
    isNonstandard: null
  },
  lightofruin: {
    inherit: true,
    isNonstandard: "Unobtainable"
  },
  lightthatburnsthesky: {
    inherit: true,
    isNonstandard: null
  },
  lowkick: {
    inherit: true,
    onTryHit() {
    }
  },
  luckychant: {
    inherit: true,
    isNonstandard: null
  },
  lunardance: {
    inherit: true,
    condition: {
      duration: 2,
      onSwitchInPriority: 1,
      onSwitchIn(target) {
        if (!target.fainted) {
          target.heal(target.maxhp);
          target.clearStatus();
          for (const moveSlot of target.moveSlots) {
            moveSlot.pp = moveSlot.maxpp;
          }
          this.add("-heal", target, target.getHealth, "[from] move: Lunar Dance");
          target.side.removeSlotCondition(target, "lunardance");
        }
      }
    }
  },
  magnetbomb: {
    inherit: true,
    isNonstandard: null
  },
  magnitude: {
    inherit: true,
    isNonstandard: null
  },
  maliciousmoonsault: {
    inherit: true,
    isNonstandard: null
  },
  meditate: {
    inherit: true,
    isNonstandard: null
  },
  mefirst: {
    inherit: true,
    isNonstandard: null
  },
  menacingmoonrazemaelstrom: {
    inherit: true,
    isNonstandard: null
  },
  miracleeye: {
    inherit: true,
    isNonstandard: null
  },
  mirrormove: {
    inherit: true,
    isNonstandard: null
  },
  mirrorshot: {
    inherit: true,
    isNonstandard: null
  },
  moongeistbeam: {
    inherit: true,
    flags: { protect: 1, mirror: 1, metronome: 1 }
  },
  moonlight: {
    inherit: true,
    onHit(pokemon) {
      let factor = 0.5;
      switch (pokemon.effectiveWeather()) {
        case "sunnyday":
        case "desolateland":
          factor = 0.667;
          break;
        case "raindance":
        case "primordialsea":
        case "sandstorm":
        case "hail":
          factor = 0.25;
          break;
      }
      const success = !!this.heal(this.modify(pokemon.maxhp, factor));
      if (!success) {
        this.add("-fail", pokemon, "heal");
        return null;
      }
      return success;
    }
  },
  morningsun: {
    inherit: true,
    onHit(pokemon) {
      let factor = 0.5;
      switch (pokemon.effectiveWeather()) {
        case "sunnyday":
        case "desolateland":
          factor = 0.667;
          break;
        case "raindance":
        case "primordialsea":
        case "sandstorm":
        case "hail":
          factor = 0.25;
          break;
      }
      const success = !!this.heal(this.modify(pokemon.maxhp, factor));
      if (!success) {
        this.add("-fail", pokemon, "heal");
        return null;
      }
      return success;
    }
  },
  mudbomb: {
    inherit: true,
    isNonstandard: null
  },
  mudsport: {
    inherit: true,
    isNonstandard: null
  },
  multiattack: {
    inherit: true,
    basePower: 90
  },
  naturalgift: {
    inherit: true,
    isNonstandard: null
  },
  naturesmadness: {
    inherit: true,
    flags: { protect: 1, mirror: 1, metronome: 1 }
  },
  needlearm: {
    inherit: true,
    isNonstandard: null
  },
  neverendingnightmare: {
    inherit: true,
    isNonstandard: null
  },
  nightmare: {
    inherit: true,
    isNonstandard: null
  },
  oceanicoperetta: {
    inherit: true,
    isNonstandard: null
  },
  odorsleuth: {
    inherit: true,
    isNonstandard: null
  },
  ominouswind: {
    inherit: true,
    isNonstandard: null
  },
  pollenpuff: {
    inherit: true,
    flags: { protect: 1, mirror: 1, metronome: 1, bullet: 1 },
    onHit(target, source) {
      if (source.isAlly(target)) {
        if (!this.heal(Math.floor(target.baseMaxhp * 0.5))) {
          this.add("-immune", target);
          return null;
        }
      }
    }
  },
  powder: {
    inherit: true,
    isNonstandard: null
  },
  precipiceblades: {
    inherit: true,
    isNonstandard: null
  },
  psychicterrain: {
    inherit: true,
    condition: {
      duration: 5,
      durationCallback(source, effect) {
        if (source?.hasItem("terrainextender")) {
          return 8;
        }
        return 5;
      },
      onTryHitPriority: 4,
      onTryHit(target, source, effect) {
        if (effect && (effect.priority <= 0.1 || effect.target === "self")) {
          return;
        }
        if (target.isSemiInvulnerable() || target.isAlly(source))
          return;
        if (!target.isGrounded()) {
          const baseMove = this.dex.moves.get(effect.id);
          if (baseMove.priority > 0) {
            this.hint("Psychic Terrain doesn't affect Pok\xE9mon immune to Ground.");
          }
          return;
        }
        this.add("-activate", target, "move: Psychic Terrain");
        return null;
      },
      onBasePower(basePower, attacker, defender, move) {
        if (move.type === "Psychic" && attacker.isGrounded() && !attacker.isSemiInvulnerable()) {
          this.debug("psychic terrain boost");
          return this.chainModify(1.5);
        }
      },
      onFieldStart(field, source, effect) {
        if (effect && effect.effectType === "Ability") {
          this.add("-fieldstart", "move: Psychic Terrain", "[from] ability: " + effect, "[of] " + source);
        } else {
          this.add("-fieldstart", "move: Psychic Terrain");
        }
      },
      onFieldResidualOrder: 27,
      onFieldResidualSubOrder: 7,
      onFieldEnd() {
        this.add("-fieldend", "move: Psychic Terrain");
      }
    }
  },
  psychoboost: {
    inherit: true,
    isNonstandard: null
  },
  psywave: {
    inherit: true,
    isNonstandard: null
  },
  pulverizingpancake: {
    inherit: true,
    isNonstandard: null
  },
  punishment: {
    inherit: true,
    isNonstandard: null
  },
  purify: {
    inherit: true,
    onHit(target, source) {
      if (!target.cureStatus())
        return false;
      this.heal(Math.ceil(source.maxhp * 0.5), source);
    }
  },
  pursuit: {
    inherit: true,
    isNonstandard: null
  },
  quash: {
    inherit: true,
    onHit(target) {
      if (this.activePerHalf === 1)
        return false;
      const action = this.queue.willMove(target);
      if (!action)
        return false;
      action.priority = -7.1;
      this.queue.cancelMove(target);
      for (let i = this.queue.list.length - 1; i >= 0; i--) {
        if (this.queue.list[i].choice === "residual") {
          this.queue.list.splice(i, 0, action);
          break;
        }
      }
      this.add("-activate", target, "move: Quash");
    }
  },
  rage: {
    inherit: true,
    isNonstandard: null
  },
  rapidspin: {
    inherit: true,
    basePower: 20,
    secondary: null
  },
  razorwind: {
    inherit: true,
    isNonstandard: null
  },
  refresh: {
    inherit: true,
    isNonstandard: null
  },
  relicsong: {
    inherit: true,
    isNonstandard: null
  },
  return: {
    inherit: true,
    isNonstandard: null
  },
  revelationdance: {
    inherit: true,
    isNonstandard: null
  },
  rockclimb: {
    inherit: true,
    isNonstandard: null
  },
  rollingkick: {
    inherit: true,
    isNonstandard: null
  },
  rototiller: {
    inherit: true,
    isNonstandard: null
  },
  sappyseed: {
    inherit: true,
    accuracy: 100,
    basePower: 90,
    pp: 15
  },
  savagespinout: {
    inherit: true,
    isNonstandard: null
  },
  searingsunrazesmash: {
    inherit: true,
    isNonstandard: null
  },
  secretpower: {
    inherit: true,
    isNonstandard: null
  },
  seedflare: {
    inherit: true,
    isNonstandard: null
  },
  sharpen: {
    inherit: true,
    isNonstandard: null
  },
  shatteredpsyche: {
    inherit: true,
    isNonstandard: null
  },
  shoreup: {
    inherit: true,
    onHit(pokemon) {
      let factor = 0.5;
      if (this.field.isWeather("sandstorm")) {
        factor = 0.667;
      }
      const success = !!this.heal(this.modify(pokemon.maxhp, factor));
      if (!success) {
        this.add("-fail", pokemon, "heal");
        return null;
      }
      return success;
    }
  },
  signalbeam: {
    inherit: true,
    isNonstandard: null
  },
  silverwind: {
    inherit: true,
    isNonstandard: null
  },
  sinisterarrowraid: {
    inherit: true,
    isNonstandard: null
  },
  sizzlyslide: {
    inherit: true,
    basePower: 90,
    pp: 15
  },
  sketch: {
    inherit: true,
    isNonstandard: null
  },
  skydrop: {
    inherit: true,
    isNonstandard: null
  },
  skyuppercut: {
    inherit: true,
    isNonstandard: null
  },
  smellingsalts: {
    inherit: true,
    isNonstandard: null
  },
  snatch: {
    inherit: true,
    isNonstandard: null
  },
  sonicboom: {
    inherit: true,
    isNonstandard: null
  },
  soulstealing7starstrike: {
    inherit: true,
    isNonstandard: null
  },
  sparklyswirl: {
    inherit: true,
    accuracy: 100,
    basePower: 90,
    pp: 15
  },
  spiderweb: {
    inherit: true,
    isNonstandard: null
  },
  spikecannon: {
    inherit: true,
    isNonstandard: null
  },
  splinteredstormshards: {
    inherit: true,
    isNonstandard: null
  },
  spotlight: {
    inherit: true,
    isNonstandard: null
  },
  steamroller: {
    inherit: true,
    isNonstandard: null
  },
  stokedsparksurfer: {
    inherit: true,
    isNonstandard: null
  },
  subzeroslammer: {
    inherit: true,
    isNonstandard: null
  },
  sunsteelstrike: {
    inherit: true,
    flags: { contact: 1, protect: 1, mirror: 1, metronome: 1 }
  },
  supersonicskystrike: {
    inherit: true,
    isNonstandard: null
  },
  swallow: {
    inherit: true,
    onHit(pokemon) {
      const healAmount = [0.25, 0.5, 1];
      const success = !!this.heal(this.modify(pokemon.maxhp, healAmount[pokemon.volatiles["stockpile"].layers - 1]));
      if (!success)
        this.add("-fail", pokemon, "heal");
      pokemon.removeVolatile("stockpile");
      return success || null;
    }
  },
  switcheroo: {
    inherit: true,
    onHit(target, source, move) {
      const yourItem = target.takeItem(source);
      const myItem = source.takeItem();
      if (target.item || source.item || !yourItem && !myItem) {
        if (yourItem)
          target.item = yourItem.id;
        if (myItem)
          source.item = myItem.id;
        return false;
      }
      if (myItem && !this.singleEvent("TakeItem", myItem, source.itemState, target, source, move, myItem) || yourItem && !this.singleEvent("TakeItem", yourItem, target.itemState, source, target, move, yourItem)) {
        if (yourItem)
          target.item = yourItem.id;
        if (myItem)
          source.item = myItem.id;
        return false;
      }
      this.add("-activate", source, "move: Trick", "[of] " + target);
      if (myItem) {
        target.setItem(myItem);
        this.add("-item", target, myItem, "[from] move: Switcheroo");
      } else {
        this.add("-enditem", target, yourItem, "[silent]", "[from] move: Switcheroo");
      }
      if (yourItem) {
        source.setItem(yourItem);
        this.add("-item", source, yourItem, "[from] move: Switcheroo");
      } else {
        this.add("-enditem", source, myItem, "[silent]", "[from] move: Switcheroo");
      }
    }
  },
  synchronoise: {
    inherit: true,
    isNonstandard: null
  },
  synthesis: {
    inherit: true,
    onHit(pokemon) {
      let factor = 0.5;
      switch (pokemon.effectiveWeather()) {
        case "sunnyday":
        case "desolateland":
          factor = 0.667;
          break;
        case "raindance":
        case "primordialsea":
        case "sandstorm":
        case "hail":
          factor = 0.25;
          break;
      }
      const success = !!this.heal(this.modify(pokemon.maxhp, factor));
      if (!success) {
        this.add("-fail", pokemon, "heal");
        return null;
      }
      return success;
    }
  },
  tailglow: {
    inherit: true,
    isNonstandard: null
  },
  tectonicrage: {
    inherit: true,
    isNonstandard: null
  },
  telekinesis: {
    inherit: true,
    isNonstandard: null
  },
  teleport: {
    inherit: true,
    priority: 0,
    selfSwitch: false,
    onTry: false
  },
  toxic: {
    inherit: true,
    onPrepareHit(target, source, move) {
      if (source.hasType("Poison"))
        source.addVolatile("toxic");
    },
    condition: {
      noCopy: true,
      duration: 1,
      onSourceInvulnerabilityPriority: 1,
      onSourceInvulnerability(target, source, move) {
        if (move && source === this.effectState.target)
          return 0;
      },
      onSourceAccuracy(accuracy, target, source, move) {
        if (move && source === this.effectState.target)
          return true;
      }
    }
  },
  toxicthread: {
    inherit: true,
    isNonstandard: null
  },
  trick: {
    inherit: true,
    onHit(target, source, move) {
      const yourItem = target.takeItem(source);
      const myItem = source.takeItem();
      if (target.item || source.item || !yourItem && !myItem) {
        if (yourItem)
          target.item = yourItem.id;
        if (myItem)
          source.item = myItem.id;
        return false;
      }
      if (myItem && !this.singleEvent("TakeItem", myItem, source.itemState, target, source, move, myItem) || yourItem && !this.singleEvent("TakeItem", yourItem, target.itemState, source, target, move, yourItem)) {
        if (yourItem)
          target.item = yourItem.id;
        if (myItem)
          source.item = myItem.id;
        return false;
      }
      this.add("-activate", source, "move: Trick", "[of] " + target);
      if (myItem) {
        target.setItem(myItem);
        this.add("-item", target, myItem, "[from] move: Trick");
      } else {
        this.add("-enditem", target, yourItem, "[silent]", "[from] move: Trick");
      }
      if (yourItem) {
        source.setItem(yourItem);
        this.add("-item", source, yourItem, "[from] move: Trick");
      } else {
        this.add("-enditem", source, myItem, "[silent]", "[from] move: Trick");
      }
    }
  },
  trumpcard: {
    inherit: true,
    isNonstandard: null
  },
  twineedle: {
    inherit: true,
    isNonstandard: null
  },
  twinkletackle: {
    inherit: true,
    isNonstandard: null
  },
  wakeupslap: {
    inherit: true,
    isNonstandard: null
  },
  watersport: {
    inherit: true,
    isNonstandard: null
  },
  wringout: {
    inherit: true,
    isNonstandard: null
  },
  zippyzap: {
    inherit: true,
    basePower: 50,
    pp: 15,
    willCrit: true,
    secondary: null
  }
};
//# sourceMappingURL=moves.js.map
